/*
 * Decompiled with CFR 0.152.
 */
package net.xmind.share.jobs;

import java.io.File;
import java.io.FileNotFoundException;
import net.xmind.share.Messages;
import net.xmind.share.jobs.HttpUtils;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.methods.multipart.FilePart;
import org.apache.commons.httpclient.methods.multipart.Part;
import org.eclipse.osgi.util.NLS;

public class TransferFileJob
implements Runnable {
    private String userName;
    private String session;
    private Part[] parts;
    private Exception exception = null;
    private boolean done = false;
    private HttpClient client;

    public TransferFileJob(String userName, String session, File file) throws FileNotFoundException {
        this.userName = userName;
        this.session = session;
        this.parts = new Part[]{new FilePart("map", file)};
    }

    public void run() {
        this.client = new HttpClient();
        try {
            int ret = HttpUtils.uploadFile(this.client, this.userName, this.session, this.parts);
            if (ret != 200) {
                this.exception = new HttpException(NLS.bind((String)Messages.TransferFileJob_ErrorCode_message, (Object)ret));
            }
        }
        catch (Exception e) {
            this.exception = e;
        }
        this.client = null;
        this.done = true;
    }

    public boolean isDone() {
        return this.done;
    }

    public Exception getException() {
        return this.exception;
    }
}

