/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.wizards;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.MarginBorder;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.TextStyle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Widget;
import org.xmind.core.Core;
import org.xmind.core.INotesContent;
import org.xmind.core.IPlainNotesContent;
import org.xmind.core.ISheet;
import org.xmind.core.ITopic;
import org.xmind.core.IWorkbook;
import org.xmind.core.marker.IMarker;
import org.xmind.core.marker.IMarkerRef;
import org.xmind.gef.GraphicalViewer;
import org.xmind.gef.IGraphicalViewer;
import org.xmind.gef.draw2d.AdvancedToolbarLayout;
import org.xmind.gef.draw2d.RotatableWrapLabel;
import org.xmind.gef.draw2d.SizeableImageFigure;
import org.xmind.gef.part.GraphicalEditPart;
import org.xmind.gef.part.IPart;
import org.xmind.gef.part.IPartFactory;
import org.xmind.gef.util.Properties;
import org.xmind.ui.gallery.FramePart;
import org.xmind.ui.gallery.GalleryLayout;
import org.xmind.ui.gallery.GalleryViewer;
import org.xmind.ui.internal.mindmap.ViewerModel;
import org.xmind.ui.internal.wizards.WizardMessages;
import org.xmind.ui.mindmap.IViewerModel;
import org.xmind.ui.mindmap.MindMapUI;
import org.xmind.ui.resources.FontUtils;
import org.xmind.ui.resources.ImageUtils;
import org.xmind.ui.util.Logger;
import org.xmind.ui.util.MarkerImageDescriptor;
import org.xmind.ui.util.MindMapUtils;
import org.xmind.ui.wizards.AbstractMindMapExportPage;
import org.xmind.ui.wizards.ExportUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class DocumentExportPageBase
extends AbstractMindMapExportPage {
    private static final String PROPERTY_NAME = "PROPERTY_NAME";
    protected static final String OVERVIEW1 = "icons/misc/overview_preview.png";
    protected static final String OVERVIEW2 = "icons/misc/overview_preview2.png";
    protected static final String OVERVIEW3 = "icons/misc/overview_preview3.png";
    private Map<String, Widget> widgets = new HashMap<String, Widget>();
    private boolean handlingEvent = false;
    private Map<String, Image> images = null;
    private String sampleNotes = null;
    private Map<String, List<IPart>> propertyListeners = null;
    private GraphicalViewer previewViewer = null;
    private Button allCheck;
    private Set<String> propertyNames;
    private boolean handlingAllCheck = false;
    private boolean allCheckCreationEnded = false;

    public DocumentExportPageBase(String pageName, String title) {
        super(pageName, title);
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.verticalSpacing = 15;
        composite.setLayout((Layout)layout);
        this.setControl((Control)composite);
        Control settingsGroup = this.createSettingsGroup(composite);
        settingsGroup.setLayoutData((Object)new GridData(4, 4, true, true));
        Control fileGroup = this.createFileControls(composite);
        fileGroup.setLayoutData((Object)new GridData(4, 4, true, false));
        this.updateStatus();
    }

    protected Control createSettingsGroup(Composite parent) {
        Group group = new Group(parent, 0);
        group.setText(WizardMessages.DocumentExportPage_SettingsGroup_title);
        GridLayout layout = new GridLayout(2, false);
        layout.verticalSpacing = 0;
        layout.horizontalSpacing = 20;
        layout.marginWidth = 7;
        layout.marginHeight = 7;
        group.setLayout((Layout)layout);
        Composite widgetContainer = new Composite((Composite)group, 0);
        widgetContainer.setLayoutData((Object)new GridData(4, 4, true, true));
        GridLayout containerLayout = new GridLayout(1, false);
        containerLayout.marginHeight = 0;
        containerLayout.marginWidth = 0;
        containerLayout.verticalSpacing = 7;
        widgetContainer.setLayout((Layout)containerLayout);
        this.createPropertyWidgets(widgetContainer);
        Composite previewContainer = new Composite((Composite)group, 0);
        GridData previewLayoutData = new GridData(0x1000008, 4, false, true);
        previewLayoutData.widthHint = 260;
        previewLayoutData.heightHint = 330;
        previewContainer.setLayoutData((Object)previewLayoutData);
        GridLayout previewLayout = new GridLayout(1, false);
        previewLayout.marginHeight = 0;
        previewLayout.marginWidth = 0;
        previewContainer.setLayout((Layout)previewLayout);
        this.createPreviewViewer(previewContainer);
        return group;
    }

    protected void createPreviewViewer(Composite parent) {
        this.previewViewer = new GalleryViewer();
        this.initPreviewViewer((IGraphicalViewer)this.previewViewer);
        this.previewViewer.createControl(parent);
        GridData gridData = new GridData(4, 4, true, true);
        this.previewViewer.getControl().setLayoutData((Object)gridData);
        this.previewViewer.getControl().setBackground(null);
        if (!"win32".equals(SWT.getPlatform())) {
            this.previewViewer.getCanvas().getLightweightSystem().getRootFigure().setOpaque(false);
        }
        this.previewViewer.setInput(this.getPreviewViewerInput());
    }

    public GraphicalViewer getPreviewViewer() {
        return this.previewViewer;
    }

    protected Object getPreviewViewerInput() {
        return this.createSampleSheet();
    }

    protected void initPreviewViewer(IGraphicalViewer previewViewer) {
        previewViewer.setPartFactory((IPartFactory)new PreviewPartFactory(previewViewer.getPartFactory()));
        Properties properties = previewViewer.getProperties();
        properties.set("org.xmind.ui.gallery.horizontal", (Object)Boolean.FALSE);
        properties.set("org.xmind.ui.gallery.solidFrames", (Object)Boolean.TRUE);
        properties.set("org.xmind.ui.gallery.hideTitle", (Object)Boolean.TRUE);
        properties.set("org.xmind.ui.gallery.layout", (Object)new GalleryLayout().margins(0));
    }

    protected void createPropertyWidgets(Composite parent) {
        this.createBooleanWidget(parent, "includeOverview", WizardMessages.DocumentExportPage_IncludeOverview);
        Widget widget = this.createBooleanWidget(parent, "separateOverview", WizardMessages.DocumentExportPage_SeparateOverviews);
        this.indentWidget(widget, 16);
        this.setWidgetEnabled(widget, this.getBoolean("includeOverview"));
        this.createAdditionalWidgets(parent);
    }

    protected void createAdditionalWidgets(Composite parent) {
        this.createAllCheck(parent);
        this.createBooleanWidget(parent, "includeHyperlink");
        this.createBooleanWidget(parent, "includeAttachment");
        this.createBooleanWidget(parent, "includeMarkers");
        this.createBooleanWidget(parent, "includeLabels");
        this.createBooleanWidget(parent, "includeImage");
        this.createBooleanWidget(parent, "includeNotes");
        this.createBooleanWidget(parent, "includeRelationships");
        this.createBooleanWidget(parent, "includeSummaries");
        this.createBooleanWidget(parent, "includeFloatingTopics");
        this.endAllCheckCreation();
    }

    protected Widget createBooleanWidget(Composite parent, String propertyName) {
        return this.createBooleanWidget(parent, propertyName, DocumentExportPageBase.getDefaultLabel(propertyName));
    }

    protected Widget createBooleanWidget(Composite parent, String propertyName, String text) {
        Button widget = new Button(parent, 32);
        widget.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        widget.setText(text);
        this.registerPropertyWidget(propertyName, (Widget)widget);
        widget.setSelection(this.getBoolean(propertyName));
        this.hookWidget((Widget)widget, 13);
        return widget;
    }

    protected void registerPropertyWidget(String propertyName, Widget widget) {
        widget.setData(PROPERTY_NAME, (Object)propertyName);
        this.widgets.put(propertyName, widget);
        if (this.propertyNames != null && !this.allCheckCreationEnded) {
            this.propertyNames.add(propertyName);
            this.indentWidget(widget, 16);
            this.updateAllCheck();
        }
    }

    protected void indentWidget(Widget widget, int indent) {
        Object layoutData;
        if (widget instanceof Control && (layoutData = ((Control)widget).getLayoutData()) instanceof GridData) {
            ((GridData)layoutData).horizontalIndent = indent;
        }
    }

    protected void setWidgetEnabled(Widget widget, boolean enabled) {
        if (widget instanceof Control) {
            ((Control)widget).setEnabled(enabled);
        }
    }

    @Override
    protected void handleWidgetEvent(Event event) {
        if (event.widget == this.allCheck) {
            this.handlingAllCheck = true;
            boolean selection = this.allCheck.getSelection();
            this.setAllBooleanProperties(selection);
            this.handlingAllCheck = false;
            this.allCheck.setGrayed(!selection);
        } else {
            Object propertyName = event.widget.getData(PROPERTY_NAME);
            if (propertyName instanceof String) {
                if (event.widget instanceof Button) {
                    this.handlingEvent = true;
                    this.setValue((String)propertyName, ((Button)event.widget).getSelection());
                    this.handlingEvent = false;
                }
            } else {
                super.handleWidgetEvent(event);
            }
        }
    }

    protected Widget getWidget(String propertyName) {
        return this.widgets.get(propertyName);
    }

    protected void setValue(String propertyName, boolean value) {
        Widget widget2;
        IDialogSettings dialogSettings = this.getWizard().getDialogSettings();
        if (dialogSettings != null) {
            dialogSettings.put(propertyName, value);
            this.firePropertyChanged(propertyName);
        }
        if (!this.handlingEvent) {
            this.setValueToWidget(propertyName, value);
        }
        if ("includeOverview".equals(propertyName) && (widget2 = this.getWidget("separateOverview")) instanceof Control) {
            ((Control)widget2).setEnabled(value);
        }
        if (!this.handlingAllCheck && this.propertyNames != null && this.propertyNames.contains(propertyName)) {
            this.updateAllCheck();
        }
    }

    protected void setValueToWidget(String propertyName, boolean value) {
        Widget widget = this.getWidget(propertyName);
        if (widget instanceof Button) {
            ((Button)widget).setSelection(value);
        }
    }

    protected boolean getBoolean(String propertyName) {
        IDialogSettings dialogSettings = this.getWizard().getDialogSettings();
        if (dialogSettings != null) {
            return dialogSettings.getBoolean(propertyName);
        }
        return false;
    }

    protected void createAllCheck(Composite parent) {
        this.allCheck = new Button(parent, 32);
        this.allCheck.setText(WizardMessages.DocumentExportPage_AllContents_text);
        GridData layoutData = new GridData(4, 4, true, false);
        layoutData.verticalIndent = 8;
        this.allCheck.setLayoutData((Object)layoutData);
        this.hookWidget((Widget)this.allCheck, 13);
        this.propertyNames = new HashSet<String>();
    }

    private Set<String> getCurrentSelection() {
        if (this.propertyNames == null) {
            return null;
        }
        HashSet<String> selected = null;
        for (String propertyName : this.propertyNames) {
            if (!this.getBoolean(propertyName)) continue;
            if (selected == null) {
                selected = new HashSet<String>();
            }
            selected.add(propertyName);
        }
        return selected;
    }

    private void setAllBooleanProperties(boolean value) {
        if (this.propertyNames == null) {
            return;
        }
        for (String propertyName : this.propertyNames) {
            this.setValue(propertyName, value);
        }
    }

    protected void updateAllCheck() {
        if (this.allCheck == null || this.allCheck.isDisposed()) {
            return;
        }
        Set<String> selection = this.getCurrentSelection();
        this.allCheck.setSelection(selection != null && !selection.isEmpty());
        this.allCheck.setGrayed(!this.isAllSelected(selection));
    }

    private boolean isAllSelected(Set<String> selection) {
        return selection == this.propertyNames || selection != null && selection.equals(this.propertyNames);
    }

    protected void endAllCheckCreation() {
        this.allCheckCreationEnded = true;
    }

    @Override
    public void dispose() {
        this.widgets.clear();
        super.dispose();
        if (this.images != null) {
            for (Image image : this.images.values()) {
                image.dispose();
            }
            this.images = null;
        }
        this.sampleNotes = null;
        this.propertyListeners = null;
        this.propertyNames = null;
        this.allCheck = null;
        this.allCheckCreationEnded = false;
    }

    protected Image getOverviewImage(String path) {
        ImageDescriptor id;
        Image image;
        if (this.images == null) {
            this.images = new HashMap<String, Image>();
        }
        if ((image = this.images.get(path)) == null && !this.images.containsKey(path) && (id = MindMapUI.getImages().get(path)) != null) {
            image = id.createImage(false);
            this.images.put(path, image);
        }
        return image;
    }

    protected Image getMarkerImage(String markerId) {
        IMarker marker;
        Image image;
        if (this.images == null) {
            this.images = new HashMap<String, Image>();
        }
        if ((image = this.images.get(markerId)) == null && !this.images.containsKey(markerId) && (marker = MindMapUI.getResourceManager().getSystemMarkerSheet().findMarker(markerId)) != null) {
            ImageDescriptor id = MarkerImageDescriptor.createFromMarker(marker);
            image = id.createImage(false);
            this.images.put(markerId, image);
        }
        return image;
    }

    protected String getSampleNotes() {
        if (this.sampleNotes == null) {
            this.sampleNotes = this.createSampleNotes();
        }
        return this.sampleNotes;
    }

    protected String createSampleNotes() {
        StringBuilder sb = new StringBuilder(200);
        int i = 0;
        while (i < 190) {
            sb.append('x');
            sb.append(' ');
            ++i;
        }
        return sb.toString();
    }

    protected void addPropertyListener(String propertyName, IPart listener) {
        List<IPart> list;
        if (this.propertyListeners == null) {
            this.propertyListeners = new HashMap<String, List<IPart>>();
        }
        if ((list = this.propertyListeners.get(propertyName)) == null) {
            list = new ArrayList<IPart>();
            this.propertyListeners.put(propertyName, list);
        }
        list.add(listener);
    }

    protected void removePropertyListener(String propertyName, IPart listener) {
        if (this.propertyListeners == null) {
            return;
        }
        List<IPart> list = this.propertyListeners.get(propertyName);
        if (list == null) {
            return;
        }
        list.remove(listener);
        if (list.isEmpty()) {
            this.propertyListeners.remove(propertyName);
            if (this.propertyListeners.isEmpty()) {
                this.propertyListeners = null;
            }
        }
    }

    private void firePropertyChanged(String propertyName) {
        if (this.propertyListeners == null) {
            return;
        }
        List<IPart> list = this.propertyListeners.get(propertyName);
        if (list == null) {
            return;
        }
        Object[] objectArray = list.toArray();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object o = objectArray[n2];
            ((IPart)o).refresh();
            ++n2;
        }
    }

    protected ISheet createSampleSheet() {
        IWorkbook workbook = Core.getWorkbookBuilder().createWorkbook();
        ISheet sheet = workbook.getPrimarySheet();
        ITopic rootTopic = sheet.getRootTopic();
        rootTopic.setTitleText(WizardMessages.DocumentExportPage_Sample_CentralTopic);
        ITopic mainTopic = workbook.createTopic();
        rootTopic.add(mainTopic);
        mainTopic.setTitleText(WizardMessages.DocumentExportPage_Sample_MainTopic1);
        mainTopic.addMarker("priority-1");
        mainTopic.addMarker("smiley-smile");
        mainTopic.setLabels((Collection)Arrays.asList(WizardMessages.DocumentExportPage_Sample_Label1, WizardMessages.DocumentExportPage_Sample_Label2));
        mainTopic.setHyperlink("http://www.xmind.net");
        mainTopic.getImage().setSource("temp.png");
        INotesContent notesContent = workbook.createNotesContent("plain");
        ((IPlainNotesContent)notesContent).setTextContent(this.getSampleNotes());
        mainTopic.getNotes().setContent("plain", notesContent);
        ITopic sub1 = workbook.createTopic();
        sub1.setTitleText(WizardMessages.DocumentExportPage_Sample_Subtopic1);
        mainTopic.add(sub1);
        ITopic sub2 = workbook.createTopic();
        sub2.setTitleText(WizardMessages.DocumentExportPage_Sample_Attachment);
        sub2.setHyperlink("xap:attachments/foo.bar");
        mainTopic.add(sub2);
        ITopic summary1 = workbook.createTopic();
        summary1.setTitleText(WizardMessages.DocumentExportPage_Sample_Summary1);
        mainTopic.add(summary1, "summary");
        ITopic summary2 = workbook.createTopic();
        summary2.setTitleText(WizardMessages.DocumentExportPage_Sample_Summary2);
        mainTopic.add(summary2, "summary");
        ITopic floating1 = workbook.createTopic();
        floating1.setTitleText(WizardMessages.DocumentExportPage_Sample_FloatingTopic1);
        rootTopic.add(floating1, "detached");
        ITopic floating2 = workbook.createTopic();
        floating2.setTitleText(WizardMessages.DocumentExportPage_Sample_FloatingTopic2);
        rootTopic.add(floating2, "detached");
        return sheet;
    }

    private static final String getDefaultLabel(String propertyName) {
        if ("includeMarkers".equals(propertyName)) {
            return WizardMessages.DocumentExportPage_IncludeMarkers;
        }
        if ("includeImage".equals(propertyName)) {
            return WizardMessages.DocumentExportPage_IncludeImages;
        }
        if ("includeNotes".equals(propertyName)) {
            return WizardMessages.DocumentExportPage_IncludeNotes;
        }
        if ("includeLabels".equals(propertyName)) {
            return WizardMessages.DocumentExportPage_IncludeLabels;
        }
        if ("includeRelationships".equals(propertyName)) {
            return WizardMessages.DocumentExportPage_IncludeRelationships;
        }
        if ("includeSummaries".equals(propertyName)) {
            return WizardMessages.DocumentExportPage_IncludeSummaries;
        }
        if ("includeFloatingTopics".equals(propertyName)) {
            return WizardMessages.DocumentExportPage_IncludeFloatingTopics;
        }
        if ("includeHyperlink".equals(propertyName)) {
            return WizardMessages.DocumentExportPage_IncludeHyperlinks;
        }
        if ("includeAttachment".equals(propertyName)) {
            return WizardMessages.DocumentExportPage_IncludeAttachments;
        }
        return "";
    }

    private class AttachmentPreviewPart
    extends TopicTitlePreviewPart {
        protected void installModelListeners() {
            super.installModelListeners();
            DocumentExportPageBase.this.addPropertyListener("includeAttachment", (IPart)this);
        }

        protected void uninstallModelListeners() {
            DocumentExportPageBase.this.removePropertyListener("includeAttachment", (IPart)this);
            super.uninstallModelListeners();
        }

        protected void updateView() {
            super.updateView();
            RotatableWrapLabel label = this.getTitle();
            TextStyle style = new TextStyle();
            style.font = label.getFont();
            if (DocumentExportPageBase.this.getBoolean("includeAttachment")) {
                style.foreground = ColorConstants.blue;
                style.underline = true;
            } else {
                style.foreground = ColorConstants.black;
                style.underline = false;
            }
            label.setStyle(style);
        }
    }

    private class HyperlinkPreviewPart
    extends TopicTitlePreviewPart {
        protected void installModelListeners() {
            super.installModelListeners();
            DocumentExportPageBase.this.addPropertyListener("includeHyperlink", (IPart)this);
        }

        protected void uninstallModelListeners() {
            DocumentExportPageBase.this.removePropertyListener("includeHyperlink", (IPart)this);
            super.uninstallModelListeners();
        }

        protected void updateView() {
            super.updateView();
            RotatableWrapLabel label = this.getTitle();
            TextStyle style = new TextStyle();
            style.font = label.getFont();
            if (DocumentExportPageBase.this.getBoolean("includeHyperlink")) {
                style.foreground = ColorConstants.blue;
                style.underline = true;
            } else {
                style.foreground = ColorConstants.black;
                style.underline = false;
            }
            label.setStyle(style);
        }
    }

    private class ImagePreviewPart
    extends GraphicalEditPart {
        protected IFigure createFigure() {
            return new Figure();
        }

        public ITopic getTopic() {
            return (ITopic)MindMapUtils.getRealModel((IPart)this);
        }

        protected LayoutManager createLayoutManager() {
            AdvancedToolbarLayout layout = new AdvancedToolbarLayout(true);
            layout.setMajorAlignment(1);
            return layout;
        }

        protected void initFigure(IFigure figure) {
            super.initFigure(figure);
            SizeableImageFigure imgFigure = new SizeableImageFigure();
            figure.add((IFigure)imgFigure);
            Image image = ImageUtils.getImage((ImageDescriptor)MindMapUI.getImages().get("insertimage.gif", true));
            imgFigure.setImage(image);
            imgFigure.setPreferredSize(imgFigure.getImageSize());
        }
    }

    private class LabelsPreviewPart
    extends GraphicalEditPart {
        protected IFigure createFigure() {
            return new RotatableWrapLabel(0);
        }

        public ITopic getTopic() {
            return (ITopic)MindMapUtils.getRealModel((IPart)this);
        }

        protected void initFigure(IFigure figure) {
            super.initFigure(figure);
            RotatableWrapLabel label = (RotatableWrapLabel)figure;
            label.setFont(FontUtils.getNewHeight((String)"org.eclipse.jface.defaultfont", (int)6));
            label.setForegroundColor(ColorConstants.darkGray);
            String text = MindMapUtils.getLabelText(this.getTopic().getLabels());
            label.setText(text);
        }
    }

    private class MarkerPreviewPart
    extends GraphicalEditPart {
        protected IFigure createFigure() {
            return new SizeableImageFigure();
        }

        public IMarkerRef getMarkerRef() {
            return (IMarkerRef)MindMapUtils.getRealModel((IPart)this);
        }

        protected void initFigure(IFigure figure) {
            super.initFigure(figure);
            SizeableImageFigure imgFigure = (SizeableImageFigure)figure;
            IMarkerRef mr = this.getMarkerRef();
            imgFigure.setImage(DocumentExportPageBase.this.getMarkerImage(mr.getMarkerId()));
            Dimension size = new Dimension(12, 12);
            imgFigure.setStretched(true);
            imgFigure.setPreferredSize(size);
            imgFigure.setSize(size);
        }
    }

    private class NotesPreviewPart
    extends GraphicalEditPart {
        protected IFigure createFigure() {
            return new RotatableWrapLabel(0);
        }

        protected void initFigure(IFigure figure) {
            super.initFigure(figure);
            RotatableWrapLabel label = (RotatableWrapLabel)figure;
            label.setTextAlignment(1);
            label.setFont(FontUtils.getNewHeight((String)"org.eclipse.jface.defaultfont", (int)4));
            label.setForegroundColor(ColorConstants.darkGray);
            label.setText(DocumentExportPageBase.this.getSampleNotes());
        }
    }

    private class OverviewPreviewPart
    extends GraphicalEditPart {
        private SizeableImageFigure imgFigure;

        public ITopic getTopic() {
            return (ITopic)MindMapUtils.getRealModel((IPart)this);
        }

        protected IFigure createFigure() {
            return new Figure();
        }

        protected LayoutManager createLayoutManager() {
            AdvancedToolbarLayout layout = new AdvancedToolbarLayout(true);
            return layout;
        }

        protected void installModelListeners() {
            super.installModelListeners();
            if (this.getTopic().isRoot()) {
                DocumentExportPageBase.this.addPropertyListener("separateOverview", (IPart)this);
            }
        }

        protected void uninstallModelListeners() {
            if (this.getTopic().isRoot()) {
                DocumentExportPageBase.this.removePropertyListener("separateOverview", (IPart)this);
            }
            super.uninstallModelListeners();
        }

        protected void initFigure(IFigure figure) {
            super.initFigure(figure);
            this.imgFigure = new SizeableImageFigure();
            figure.add((IFigure)this.imgFigure);
        }

        protected void updateView() {
            super.updateView();
            if (this.getTopic().isRoot()) {
                if (DocumentExportPageBase.this.getBoolean("separateOverview")) {
                    this.imgFigure.setImage(DocumentExportPageBase.this.getOverviewImage(DocumentExportPageBase.OVERVIEW2));
                } else {
                    this.imgFigure.setImage(DocumentExportPageBase.this.getOverviewImage(DocumentExportPageBase.OVERVIEW1));
                }
            } else {
                this.imgFigure.setImage(DocumentExportPageBase.this.getOverviewImage(DocumentExportPageBase.OVERVIEW3));
            }
            this.imgFigure.setPreferredSize(this.imgFigure.getImageSize());
        }
    }

    private class PreviewPartFactory
    implements IPartFactory {
        private IPartFactory factory;

        public PreviewPartFactory(IPartFactory factory) {
            this.factory = factory;
        }

        public IPart createPart(IPart context, Object model) {
            if (model instanceof ISheet && context instanceof FramePart) {
                return new SheetPreviewPart((ISheet)model);
            }
            if (model instanceof IViewerModel) {
                IViewerModel m = (IViewerModel)model;
                try {
                    IPart part = (IPart)m.getPartType().getConstructors()[0].newInstance(new Object[]{DocumentExportPageBase.this});
                    part.setModel(model);
                    return part;
                }
                catch (Throwable e) {
                    Logger.log(e, "Failed to create export preview part: " + m.getPartType());
                }
            }
            return this.factory.createPart(context, model);
        }
    }

    private class RelationshipsPreviewPart
    extends GraphicalEditPart {
        protected IFigure createFigure() {
            return new Figure();
        }

        protected LayoutManager createLayoutManager() {
            AdvancedToolbarLayout layout = new AdvancedToolbarLayout(true);
            layout.setMinorAlignment(2);
            layout.setMajorAlignment(1);
            layout.setSpacing(3);
            return layout;
        }

        protected void initFigure(IFigure figure) {
            super.initFigure(figure);
            RotatableWrapLabel seeAlsoLabel = new RotatableWrapLabel(0);
            seeAlsoLabel.setPrefWidth(300);
            seeAlsoLabel.setFont(FontUtils.getBold((String)"org.eclipse.jface.defaultfont", (int)6));
            seeAlsoLabel.setForegroundColor(ColorConstants.darkGray);
            seeAlsoLabel.setText(WizardMessages.Export_SeeAlso);
            RotatableWrapLabel relationshipsLabel = new RotatableWrapLabel(0);
            relationshipsLabel.setPrefWidth(250);
            relationshipsLabel.setFont(FontUtils.getNewHeight((String)"org.eclipse.jface.defaultfont", (int)6));
            relationshipsLabel.setForegroundColor(ColorConstants.darkGray);
            relationshipsLabel.setText(WizardMessages.DocumentExportPage_Sample_Relationships);
            figure.add((IFigure)seeAlsoLabel);
            figure.add((IFigure)relationshipsLabel);
        }
    }

    private class SheetPreviewPart
    extends GraphicalEditPart {
        public SheetPreviewPart(ISheet sheet) {
            this.setModel(sheet);
        }

        protected IFigure createFigure() {
            return new Figure();
        }

        protected void initFigure(IFigure figure) {
            super.initFigure(figure);
            figure.setBorder((Border)new MarginBorder(10));
            figure.setPreferredSize(new Dimension(240, 310));
        }

        protected LayoutManager createLayoutManager() {
            AdvancedToolbarLayout layout = new AdvancedToolbarLayout(false);
            layout.setMajorAlignment(1);
            layout.setStretchMinorAxis(true);
            layout.setSpacing(2);
            return layout;
        }

        public ISheet getSheet() {
            return (ISheet)super.getModel();
        }

        protected void installModelListeners() {
            super.installModelListeners();
            DocumentExportPageBase.this.addPropertyListener("includeOverview", (IPart)this);
            DocumentExportPageBase.this.addPropertyListener("separateOverview", (IPart)this);
            DocumentExportPageBase.this.addPropertyListener("includeMarkers", (IPart)this);
            DocumentExportPageBase.this.addPropertyListener("includeLabels", (IPart)this);
            DocumentExportPageBase.this.addPropertyListener("includeImage", (IPart)this);
            DocumentExportPageBase.this.addPropertyListener("includeNotes", (IPart)this);
            DocumentExportPageBase.this.addPropertyListener("includeRelationships", (IPart)this);
            DocumentExportPageBase.this.addPropertyListener("includeFloatingTopics", (IPart)this);
            DocumentExportPageBase.this.addPropertyListener("includeSummaries", (IPart)this);
        }

        protected void uninstallModelListeners() {
            DocumentExportPageBase.this.removePropertyListener("includeMarkers", (IPart)this);
            DocumentExportPageBase.this.removePropertyListener("includeLabels", (IPart)this);
            DocumentExportPageBase.this.removePropertyListener("includeOverview", (IPart)this);
            DocumentExportPageBase.this.removePropertyListener("separateOverview", (IPart)this);
            DocumentExportPageBase.this.removePropertyListener("includeImage", (IPart)this);
            DocumentExportPageBase.this.removePropertyListener("includeNotes", (IPart)this);
            DocumentExportPageBase.this.removePropertyListener("includeRelationships", (IPart)this);
            DocumentExportPageBase.this.removePropertyListener("includeFloatingTopics", (IPart)this);
            DocumentExportPageBase.this.removePropertyListener("includeSummaries", (IPart)this);
            super.uninstallModelListeners();
        }

        protected Object[] getModelChildren(Object model) {
            ArrayList<ViewerModel> list = new ArrayList<ViewerModel>();
            ISheet sheet = this.getSheet();
            ITopic rootTopic = sheet.getRootTopic();
            list.add(new ViewerModel(TopicTitlePreviewPart.class, rootTopic));
            boolean includeOverview = DocumentExportPageBase.this.getBoolean("includeOverview");
            if (includeOverview) {
                list.add(new ViewerModel(OverviewPreviewPart.class, rootTopic));
            }
            List children = rootTopic.getChildren("attached");
            ITopic mainTopic = (ITopic)children.get(0);
            list.add(new ViewerModel(HyperlinkPreviewPart.class, mainTopic));
            if (DocumentExportPageBase.this.getBoolean("includeMarkers") || DocumentExportPageBase.this.getBoolean("includeLabels")) {
                list.add(new ViewerModel(TagsPreviewPart.class, mainTopic));
            }
            if (includeOverview && DocumentExportPageBase.this.getBoolean("separateOverview")) {
                list.add(new ViewerModel(OverviewPreviewPart.class, mainTopic));
            }
            if (DocumentExportPageBase.this.getBoolean("includeImage")) {
                list.add(new ViewerModel(ImagePreviewPart.class, mainTopic));
            }
            if (DocumentExportPageBase.this.getBoolean("includeNotes")) {
                list.add(new ViewerModel(NotesPreviewPart.class, mainTopic));
            }
            if (DocumentExportPageBase.this.getBoolean("includeRelationships")) {
                list.add(new ViewerModel(RelationshipsPreviewPart.class, mainTopic));
            }
            for (ITopic sub : mainTopic.getChildren("attached")) {
                if (sub.getHyperlink() != null) {
                    list.add(new ViewerModel(AttachmentPreviewPart.class, sub));
                    continue;
                }
                list.add(new ViewerModel(TopicTitlePreviewPart.class, sub));
            }
            if (DocumentExportPageBase.this.getBoolean("includeSummaries")) {
                for (ITopic t : mainTopic.getChildren("summary")) {
                    list.add(new ViewerModel(TopicTitlePreviewPart.class, t));
                }
            }
            if (DocumentExportPageBase.this.getBoolean("includeFloatingTopics")) {
                for (ITopic t : rootTopic.getChildren("detached")) {
                    list.add(new ViewerModel(TopicTitlePreviewPart.class, t));
                }
            }
            return list.toArray();
        }
    }

    private class TagsPreviewPart
    extends GraphicalEditPart {
        public ITopic getTopic() {
            return (ITopic)MindMapUtils.getRealModel((IPart)this);
        }

        protected IFigure createFigure() {
            return new Figure();
        }

        protected LayoutManager createLayoutManager() {
            AdvancedToolbarLayout layout = new AdvancedToolbarLayout(true);
            layout.setMinorAlignment(2);
            layout.setInnerMinorAlignment(2);
            layout.setMajorAlignment(1);
            layout.setSpacing(2);
            return layout;
        }

        protected void installModelListeners() {
            super.installModelListeners();
            DocumentExportPageBase.this.addPropertyListener("includeMarkers", (IPart)this);
            DocumentExportPageBase.this.addPropertyListener("includeLabels", (IPart)this);
        }

        protected void uninstallModelListeners() {
            DocumentExportPageBase.this.removePropertyListener("includeLabels", (IPart)this);
            DocumentExportPageBase.this.removePropertyListener("includeMarkers", (IPart)this);
            super.uninstallModelListeners();
        }

        protected Object[] getModelChildren(Object model) {
            ArrayList<ViewerModel> list = new ArrayList<ViewerModel>();
            ITopic topic = this.getTopic();
            if (DocumentExportPageBase.this.getBoolean("includeMarkers")) {
                for (IMarkerRef mr : topic.getMarkerRefs()) {
                    list.add(new ViewerModel(MarkerPreviewPart.class, mr));
                }
            }
            if (DocumentExportPageBase.this.getBoolean("includeLabels") && !topic.getLabels().isEmpty()) {
                list.add(new ViewerModel(LabelsPreviewPart.class, topic));
            }
            return list.toArray();
        }
    }

    private class TopicTitlePreviewPart
    extends GraphicalEditPart {
        private RotatableWrapLabel number;
        private RotatableWrapLabel title;

        public ITopic getTopic() {
            return (ITopic)MindMapUtils.getRealModel((IPart)this);
        }

        protected IFigure createFigure() {
            return new Figure();
        }

        protected LayoutManager createLayoutManager() {
            AdvancedToolbarLayout layout = new AdvancedToolbarLayout(true);
            if (this.getTopic().isRoot()) {
                layout.setMajorAlignment(0);
            } else {
                layout.setMajorAlignment(1);
            }
            layout.setMinorAlignment(2);
            layout.setInnerMinorAlignment(2);
            layout.setSpacing(5);
            return layout;
        }

        public RotatableWrapLabel getNumber() {
            return this.number;
        }

        public RotatableWrapLabel getTitle() {
            return this.title;
        }

        protected void initFigure(IFigure figure) {
            super.initFigure(figure);
            ITopic topic = this.getTopic();
            int level = MindMapUtils.getLevel(this.getTopic(), null);
            level = Math.min(2, level);
            Font font = level <= 1 ? FontUtils.getBoldRelative((String)"org.eclipse.jface.defaultfont", (int)(-level)) : FontUtils.getRelativeHeight((String)"org.eclipse.jface.defaultfont", (int)(-level));
            String num = ExportUtils.getNumberingText(topic, null);
            if (num != null) {
                this.number = new RotatableWrapLabel(0);
                this.number.setFont(font);
                this.number.setForegroundColor(ColorConstants.black);
                this.number.setText(num);
                figure.add((IFigure)this.number);
            }
            this.title = new RotatableWrapLabel(0);
            this.title.setFont(font);
            this.title.setForegroundColor(ColorConstants.black);
            this.title.setText(topic.getTitleText());
            figure.add((IFigure)this.title);
        }
    }
}

