/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.wizards;

import java.io.File;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchWindow;
import org.xmind.core.util.FileUtils;
import org.xmind.gef.IGraphicalViewer;
import org.xmind.gef.ui.editor.IGraphicalEditor;
import org.xmind.gef.ui.editor.IGraphicalEditorPage;
import org.xmind.ui.internal.dialogs.DialogUtils;
import org.xmind.ui.internal.wizards.UncompletablePage;
import org.xmind.ui.internal.wizards.WizardMessages;
import org.xmind.ui.io.MonitoredOutputStream;
import org.xmind.ui.io.StreamInterruptedException;
import org.xmind.ui.mindmap.IMindMap;
import org.xmind.ui.mindmap.IMindMapViewer;
import org.xmind.ui.util.Logger;
import org.xmind.ui.wizards.AbstractExportWizard;

public abstract class AbstractMindMapExportWizard
extends AbstractExportWizard {
    private IGraphicalEditor sourceEditor;
    private IGraphicalEditorPage sourcePage;
    private IMindMapViewer sourceViewer;
    private IMindMap sourceMindMap;

    public AbstractMindMapExportWizard() {
        this.setNeedsProgressMonitor(true);
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.initSources(workbench);
        super.init(workbench, selection);
    }

    protected void initSources(IWorkbench workbench) {
        IMindMapViewer mmv;
        IMindMap mindMap;
        IGraphicalViewer viewer;
        IGraphicalEditor editor;
        IGraphicalEditorPage page;
        IWorkbenchWindow window = workbench.getActiveWorkbenchWindow();
        IEditorPart activeEditor = window.getActivePage().getActiveEditor();
        if (activeEditor instanceof IGraphicalEditor && (page = (editor = (IGraphicalEditor)activeEditor).getActivePageInstance()) != null && (viewer = page.getViewer()) instanceof IMindMapViewer && (mindMap = (mmv = (IMindMapViewer)viewer).getMindMap()) != null) {
            this.setSourceMindMap(mindMap);
            this.setSourceViewer(mmv);
            this.setSourcePage(page);
            this.setSourceEditor(editor);
            return;
        }
        this.setSourceViewer(null);
        this.setSourcePage(null);
        this.setSourceEditor(null);
    }

    public void dispose() {
        this.setSourceEditor(null);
        this.setSourcePage(null);
        this.setSourceViewer(null);
        super.dispose();
    }

    public void addPages() {
        if (this.hasSource()) {
            this.addValidPages();
        } else {
            UncompletablePage errorPage = new UncompletablePage(WizardMessages.NoContentPage_title, WizardMessages.NoContentPage_message);
            errorPage.setDescription(WizardMessages.NoContentPage_description);
            this.addPage((IWizardPage)errorPage);
        }
    }

    protected abstract void addValidPages();

    public boolean canFinish() {
        return super.canFinish() && this.hasSource() && this.hasTargetPath();
    }

    public boolean performFinish() {
        if (!this.hasSource() || !this.hasTargetPath()) {
            return false;
        }
        if (!this.isExtensionCompatible(this.getTargetPath(), FileUtils.getExtension((String)this.getTargetPath()))) {
            String fileName = new File(this.getTargetPath()).getName();
            String formatName = this.getFormatName();
            String messages = NLS.bind((String)WizardMessages.Export_UncompatibleFormat_message, (Object)fileName, (Object)formatName);
            if (!MessageDialog.openConfirm((Shell)this.getShell(), (String)WizardMessages.Export_UncompatibleFormat_title, (String)messages)) {
                return false;
            }
        }
        if (!this.isOverwriteWithoutPrompt() && new File(this.getTargetPath()).exists() && !DialogUtils.confirmOverwrite(this.getShell(), this.getTargetPath())) {
            return false;
        }
        return this.doExport();
    }

    protected boolean doExport() {
        final Display display = Display.getCurrent();
        final Shell parentShell = this.findParentShell(display);
        try {
            this.getContainer().run(true, true, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    AbstractMindMapExportWizard.this.doExport(monitor, display, parentShell);
                }
            });
            return true;
        }
        catch (Throwable e) {
            if (e instanceof InterruptedException || e instanceof StreamInterruptedException) {
                return false;
            }
            if (e instanceof InvocationTargetException) {
                e = ((InvocationTargetException)e).getCause();
            }
            void ex = e;
            display.asyncExec(new Runnable((Throwable)ex){
                private final /* synthetic */ Throwable val$ex;
                {
                    this.val$ex = throwable;
                }

                public void run() {
                    AbstractMindMapExportWizard.this.handleExportException(this.val$ex);
                }
            });
            return false;
        }
    }

    protected void handleExportException(Throwable e) {
        Logger.log(e, NLS.bind((String)WizardMessages.Export_FailedWhenExport, (Object)this.getFormatName()));
    }

    private Shell findParentShell(Display display) {
        Shell parentShell;
        Composite shellParent;
        Shell shell = this.getContainer().getShell();
        if (shell != null && (shellParent = shell.getParent()) instanceof Shell && !(parentShell = (Shell)shellParent).isDisposed() && parentShell.getDisplay() == display) {
            return parentShell;
        }
        return null;
    }

    protected abstract void doExport(IProgressMonitor var1, Display var2, Shell var3) throws InvocationTargetException, InterruptedException;

    protected OutputStream wrapMonitor(OutputStream realStream, IProgressMonitor monitor) {
        return new MonitoredOutputStream(realStream, monitor);
    }

    public IGraphicalEditor getSourceEditor() {
        return this.sourceEditor;
    }

    public IGraphicalEditorPage getSourcePage() {
        return this.sourcePage;
    }

    public IMindMapViewer getSourceViewer() {
        return this.sourceViewer;
    }

    public void setSourceEditor(IGraphicalEditor sourceEditor) {
        this.sourceEditor = sourceEditor;
    }

    public void setSourcePage(IGraphicalEditorPage sourcePage) {
        this.sourcePage = sourcePage;
    }

    public void setSourceViewer(IMindMapViewer sourceViewer) {
        this.sourceViewer = sourceViewer;
    }

    public IMindMap getSourceMindMap() {
        return this.sourceMindMap;
    }

    public void setSourceMindMap(IMindMap sourceMindMap) {
        this.sourceMindMap = sourceMindMap;
    }

    public boolean hasSource() {
        return this.sourceEditor != null && this.sourcePage != null && this.sourceViewer != null && this.sourceViewer.getInput() != null && this.sourceMindMap != null;
    }

    protected abstract String getFormatName();

    protected boolean isExtensionCompatible(String path, String extension) {
        return true;
    }
}

