/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.util;

import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.swt.widgets.Display;
import org.xmind.gef.draw2d.geometry.PrecisionInsets;
import org.xmind.gef.draw2d.geometry.PrecisionPoint;

public class UnitConvertor {
    public static final double INCH_TO_MM = 25.4;
    public static final double MM_TO_INCH = 0.03937007874015748;
    private static Point dpi = null;
    private static Point defaultDpi = null;

    public static Point getScreenDpi() {
        if (dpi == null) {
            Display display = Display.getCurrent();
            if (display == null) {
                if (defaultDpi == null) {
                    defaultDpi = new Point(72, 72);
                }
                return defaultDpi;
            }
            dpi = new Point(display.getDPI());
        }
        return dpi;
    }

    public static double inch2mm(double value) {
        return value * 25.4;
    }

    public static double mm2inch(double value) {
        return value / 25.4;
    }

    public static PrecisionPoint scrDots2inch(Point p) {
        double x = (double)p.x * 1.0 / (double)UnitConvertor.getScreenDpi().x;
        double y = (double)p.y * 1.0 / (double)UnitConvertor.getScreenDpi().y;
        return new PrecisionPoint(x, y);
    }

    public static PrecisionInsets scrDots2inch(Insets ins) {
        double top = (double)ins.top * 1.0 / (double)UnitConvertor.getScreenDpi().y;
        double left = (double)ins.left * 1.0 / (double)UnitConvertor.getScreenDpi().x;
        double bottom = (double)ins.bottom * 1.0 / (double)UnitConvertor.getScreenDpi().y;
        double right = (double)ins.right * 1.0 / (double)UnitConvertor.getScreenDpi().x;
        return new PrecisionInsets(top, left, bottom, right);
    }

    public static PrecisionPoint scrDots2mm(Point dots) {
        PrecisionPoint p = UnitConvertor.scrDots2inch(dots);
        p.x = UnitConvertor.inch2mm(p.x);
        p.y = UnitConvertor.inch2mm(p.y);
        return p;
    }

    public static PrecisionInsets scrDots2mm(Insets dots) {
        PrecisionInsets ins = UnitConvertor.scrDots2inch(dots);
        ins.top = UnitConvertor.inch2mm(ins.top);
        ins.left = UnitConvertor.inch2mm(ins.left);
        ins.bottom = UnitConvertor.inch2mm(ins.bottom);
        ins.right = UnitConvertor.inch2mm(ins.right);
        return ins;
    }

    public static Point inch2scrDots(PrecisionPoint p) {
        return UnitConvertor.inch2scrDots(p.x, p.y);
    }

    public static Point inch2scrDots(double x, double y) {
        int x2 = (int)(x * (double)UnitConvertor.getScreenDpi().x);
        int y2 = (int)(y * (double)UnitConvertor.getScreenDpi().y);
        return new Point(x2, y2);
    }

    public static Point mm2scrDots(PrecisionPoint p) {
        double x = UnitConvertor.mm2inch(p.x);
        double y = UnitConvertor.mm2inch(p.y);
        return UnitConvertor.inch2scrDots(new PrecisionPoint(x, y));
    }

    public static Point mm2scrDots(double x, double y) {
        double x2 = UnitConvertor.mm2inch(x);
        double y2 = UnitConvertor.mm2inch(y);
        return UnitConvertor.inch2scrDots(x2, y2);
    }

    public static PrecisionInsets inch2mm(PrecisionInsets ins) {
        double left = UnitConvertor.inch2mm(ins.left);
        double right = UnitConvertor.inch2mm(ins.right);
        double top = UnitConvertor.inch2mm(ins.top);
        double bottom = UnitConvertor.inch2mm(ins.bottom);
        return new PrecisionInsets(top, left, bottom, right);
    }

    public static PrecisionInsets mm2inch(PrecisionInsets ins) {
        double left = UnitConvertor.mm2inch(ins.left);
        double right = UnitConvertor.mm2inch(ins.right);
        double top = UnitConvertor.mm2inch(ins.top);
        double bottom = UnitConvertor.mm2inch(ins.bottom);
        return new PrecisionInsets(top, left, bottom, right);
    }

    public static PrecisionInsets inch2dots(PrecisionInsets ins, Point dpi) {
        double left = ins.left * (double)dpi.x;
        double right = ins.right * (double)dpi.x;
        double top = ins.top * (double)dpi.y;
        double bottom = ins.bottom * (double)dpi.y;
        return new PrecisionInsets(top, left, bottom, right);
    }

    public static PrecisionInsets dots2inch(Insets ins, Point dpi) {
        double left = (double)ins.left * 1.0 / (double)dpi.x;
        double right = (double)ins.right * 1.0 / (double)dpi.x;
        double top = (double)ins.top * 1.0 / (double)dpi.y;
        double bottom = (double)ins.bottom * 1.0 / (double)dpi.y;
        return new PrecisionInsets(top, left, bottom, right);
    }

    public static PrecisionInsets dots2mm(Insets ins, Point dpi) {
        return UnitConvertor.inch2mm(UnitConvertor.dots2inch(ins, dpi));
    }

    public static PrecisionInsets mm2dots(PrecisionInsets ins, Point dpi) {
        return UnitConvertor.inch2dots(UnitConvertor.mm2inch(ins), dpi);
    }
}

