/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.util;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.graphics.ImageData;
import org.xmind.core.marker.IMarker;
import org.xmind.core.marker.IMarkerRef;
import org.xmind.core.marker.IMarkerResource;
import org.xmind.ui.resources.ImageUtils;

public class MarkerImageDescriptor
extends ImageDescriptor {
    private static ImageDescriptor ErrorImage = null;
    private IMarker marker;
    private IMarkerRef markerRef;
    private String markerId;
    private int widthHint;
    private int heightHint;

    protected MarkerImageDescriptor(IMarker marker, int widthHint, int heightHint) {
        this.marker = marker;
        this.markerRef = null;
        this.markerId = marker.getId();
        this.widthHint = widthHint;
        this.heightHint = heightHint;
    }

    protected MarkerImageDescriptor(IMarkerRef markerRef, int widthHint, int heightHint) {
        this.marker = null;
        this.markerRef = markerRef;
        this.markerId = markerRef.getMarkerId();
        this.widthHint = widthHint;
        this.heightHint = heightHint;
    }

    public ImageData getImageData() {
        ImageData result;
        block14: {
            InputStream in = this.getStream();
            result = null;
            if (in != null) {
                try {
                    try {
                        result = new ImageData(in);
                        result = this.performScale(result);
                    }
                    catch (SWTException e) {
                        if (e.code != 40) {
                            throw e;
                        }
                        try {
                            in.close();
                        }
                        catch (IOException iOException) {}
                        break block14;
                    }
                }
                catch (Throwable throwable) {
                    try {
                        in.close();
                    }
                    catch (IOException iOException) {}
                    throw throwable;
                }
                try {
                    in.close();
                }
                catch (IOException iOException) {}
            }
        }
        if (result == null) {
            result = MarkerImageDescriptor.getErrorImage().getImageData();
        }
        return result;
    }

    private ImageData performScale(ImageData result) {
        if (this.widthHint >= 0 || this.heightHint >= 0) {
            int w = this.widthHint;
            int h = this.heightHint;
            if (w < 0) {
                w = result.width;
            }
            if (h < 0) {
                h = result.height;
            }
            result = result.scaledTo(w, h);
        } else {
            boolean shouldScaleHeight;
            double hScale = (double)result.width / 48.0;
            double vScale = (double)result.height / 48.0;
            boolean shouldScaleWidth = hScale > 1.0;
            boolean bl = shouldScaleHeight = vScale > 1.0;
            if (shouldScaleWidth || shouldScaleHeight) {
                int h;
                int w;
                if (hScale > vScale) {
                    w = 48;
                    h = (int)((double)result.height / hScale);
                } else {
                    w = (int)((double)result.width / vScale);
                    h = 48;
                }
                result = result.scaledTo(w, h);
            }
        }
        return result;
    }

    private IMarker getMarker() {
        if (this.marker == null && this.markerRef != null) {
            return this.markerRef.getMarker();
        }
        return this.marker;
    }

    private InputStream getStream() {
        IMarker m = this.getMarker();
        if (m == null) {
            return null;
        }
        IMarkerResource res = m.getResource();
        if (res == null) {
            return null;
        }
        InputStream in = res.getInputStream();
        if (in == null) {
            return null;
        }
        return new BufferedInputStream(in);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || !(obj instanceof MarkerImageDescriptor)) {
            return false;
        }
        MarkerImageDescriptor that = (MarkerImageDescriptor)((Object)obj);
        if (!(this.widthHint < 0 ? that.widthHint < 0 : this.widthHint == that.widthHint) || (this.heightHint < 0 ? that.heightHint >= 0 : this.heightHint != that.heightHint)) {
            return false;
        }
        IMarker thisMarker = this.getMarker();
        return thisMarker != null && thisMarker.equals(that.getMarker());
    }

    public int hashCode() {
        return this.markerId.hashCode();
    }

    public String toString() {
        return "MarkerImageDescriptor(marker=" + this.markerId + ")";
    }

    private static ImageDescriptor getErrorImage() {
        if (ErrorImage == null) {
            ErrorImage = ImageUtils.createErrorImage((int)16, (int)16);
        }
        return ErrorImage;
    }

    public static ImageDescriptor createFromMarker(IMarker marker) {
        if (marker == null) {
            return MarkerImageDescriptor.getErrorImage();
        }
        return new MarkerImageDescriptor(marker, -1, -1);
    }

    public static ImageDescriptor createFromMarkerRef(IMarkerRef markerRef) {
        if (markerRef == null) {
            return MarkerImageDescriptor.getErrorImage();
        }
        return new MarkerImageDescriptor(markerRef, -1, -1);
    }

    public static ImageDescriptor createFromMarker(IMarker marker, int widthHint, int heightHint) {
        if (marker == null) {
            return MarkerImageDescriptor.getErrorImage();
        }
        return new MarkerImageDescriptor(marker, widthHint, heightHint);
    }

    public static ImageDescriptor createFromMarkerRef(IMarkerRef markerRef, int widthHint, int heightHint) {
        if (markerRef == null) {
            return MarkerImageDescriptor.getErrorImage();
        }
        return new MarkerImageDescriptor(markerRef, widthHint, heightHint);
    }
}

