/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.properties;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.xmind.core.event.CoreEvent;
import org.xmind.core.event.CoreEventRegister;
import org.xmind.core.event.ICoreEventListener;
import org.xmind.core.event.ICoreEventRegister;
import org.xmind.core.event.ICoreEventSource;
import org.xmind.gef.EditDomain;
import org.xmind.gef.IGraphicalViewer;
import org.xmind.gef.ISourceProvider;
import org.xmind.gef.IViewer;
import org.xmind.gef.Request;
import org.xmind.gef.command.Command;
import org.xmind.gef.command.ICommandStack;
import org.xmind.gef.graphicalpolicy.IStyleSelector;
import org.xmind.gef.part.IGraphicalPart;
import org.xmind.gef.part.IPart;
import org.xmind.gef.ui.editor.IGraphicalEditorPage;
import org.xmind.gef.ui.properties.PropertySectionPart;
import org.xmind.ui.style.StyleUtils;

public abstract class MindMapPropertySectionPartBase
extends PropertySectionPart
implements ICoreEventListener {
    protected static final Object[] NO_ELEMENTS = new Object[0];
    private ICoreEventRegister eventRegister = null;
    private boolean refreshing = false;

    protected boolean isRefreshing() {
        return this.refreshing;
    }

    public void refresh() {
        super.refresh();
        this.refreshing = true;
        this.doRefresh();
        this.refreshing = false;
    }

    protected abstract void doRefresh();

    protected IGraphicalEditorPage getActivePage() {
        return this.getContributedEditor().getActivePageInstance();
    }

    protected IGraphicalViewer getActiveViewer() {
        IGraphicalEditorPage editorPage = this.getActivePage();
        return editorPage == null ? null : editorPage.getViewer();
    }

    protected EditDomain getActiveDomain() {
        IGraphicalEditorPage editorPage = this.getActivePage();
        return editorPage == null ? null : editorPage.getEditDomain();
    }

    protected IPart getPart(Object o) {
        IGraphicalViewer viewer = this.getActiveViewer();
        return viewer == null ? null : viewer.findPart(o);
    }

    protected IGraphicalPart getGraphicalPart(Object o) {
        return this.getGraphicalPart(o, (IViewer)this.getActiveViewer());
    }

    protected IGraphicalPart getGraphicalPart(Object o, IViewer viewer) {
        if (viewer == null) {
            return null;
        }
        IPart p = viewer.findPart(o);
        return p instanceof IGraphicalPart ? (IGraphicalPart)p : null;
    }

    protected IStyleSelector getStyleSelector(IGraphicalPart part) {
        return StyleUtils.getStyleSelector(part);
    }

    protected void saveAndRun(Command command) {
        ICommandStack cs = this.getContributedEditor().getCommandStack();
        if (cs != null) {
            cs.execute(command);
            if (command instanceof ISourceProvider) {
                List sources = ((ISourceProvider)command).getSources();
                this.getContributedEditor().getSite().getSelectionProvider().setSelection((ISelection)new StructuredSelection(sources));
            }
        }
    }

    protected void sendRequest(String request) {
        EditDomain domain = this.getActiveDomain();
        if (domain != null) {
            domain.handleRequest(request, (IViewer)this.getActiveViewer());
        }
    }

    protected void sendRequest(Request request) {
        if (request == null) {
            return;
        }
        EditDomain domain = this.getActiveDomain();
        if (domain != null) {
            domain.handleRequest(request);
        }
    }

    protected Request fillTargets(Request request) {
        IGraphicalViewer viewer = this.getActiveViewer();
        if (viewer != null) {
            request.setViewer((IViewer)viewer);
            request.setDomain(viewer.getEditDomain());
            Object[] elements = this.getSelectedElements();
            ArrayList<IPart> parts = new ArrayList<IPart>(elements.length);
            Object[] objectArray = elements;
            int n = elements.length;
            int n2 = 0;
            while (n2 < n) {
                Object o = objectArray[n2];
                IPart p = viewer.findPart(o);
                if (p != null && !parts.contains(p) && this.isRequestTarget(request, p)) {
                    parts.add(p);
                }
                ++n2;
            }
            if (!parts.isEmpty()) {
                request.setTargets(parts);
            }
        }
        return request;
    }

    protected boolean isRequestTarget(Request request, IPart part) {
        return true;
    }

    protected Object[] getSelectedElements() {
        if (this.getCurrentSelection() != null && this.getCurrentSelection() instanceof IStructuredSelection) {
            return ((IStructuredSelection)this.getCurrentSelection()).toArray();
        }
        return NO_ELEMENTS;
    }

    protected void hookSelection(ISelection selection) {
        super.hookSelection(selection);
        Object[] objectArray = this.getSelectedElements();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object o = objectArray[n2];
            if (o instanceof ICoreEventSource) {
                if (this.eventRegister == null) {
                    this.eventRegister = new CoreEventRegister((ICoreEventListener)this);
                }
                ICoreEventSource source = (ICoreEventSource)o;
                this.eventRegister.setNextSource(source);
                this.registerEventListener(source, this.eventRegister);
            }
            ++n2;
        }
    }

    public void createControl(Composite parent) {
        parent.setLayout((Layout)this.createLayout(parent));
        this.createContent(parent);
    }

    protected GridLayout createLayout(Composite parent) {
        GridLayout layout = new GridLayout(1, true);
        layout.marginWidth = 3;
        layout.marginHeight = 3;
        layout.horizontalSpacing = 3;
        layout.verticalSpacing = 3;
        return layout;
    }

    protected abstract void createContent(Composite var1);

    protected abstract void registerEventListener(ICoreEventSource var1, ICoreEventRegister var2);

    protected void unhookSelection(ISelection selection) {
        if (this.eventRegister != null) {
            this.eventRegister.unregisterAll();
            this.eventRegister = null;
        }
        super.unhookSelection(selection);
    }

    public void handleCoreEvent(CoreEvent event) {
        this.refresh();
    }
}

