/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.wizards;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;
import org.xmind.core.util.FileUtils;
import org.xmind.gef.image.ImageExportUtils;
import org.xmind.gef.image.ImageWriter;
import org.xmind.ui.internal.MindMapUIPlugin;
import org.xmind.ui.internal.dialogs.DialogUtils;
import org.xmind.ui.internal.wizards.WizardMessages;
import org.xmind.ui.io.MonitoredOutputStream;
import org.xmind.ui.io.StreamInterruptedException;
import org.xmind.ui.mindmap.MindMapImageExtractor;
import org.xmind.ui.mindmap.MindMapUI;
import org.xmind.ui.resources.FontUtils;
import org.xmind.ui.util.ImageFormat;
import org.xmind.ui.viewers.ImagePreviewViewer;
import org.xmind.ui.wizards.AbstractMindMapExportPage;
import org.xmind.ui.wizards.AbstractMindMapExportWizard;

public class ImageExportWizard
extends AbstractMindMapExportWizard {
    private static final String IMAGE_EXPORT_PAGE_NAME = "imageExportPage";
    private static final String DIALOG_SETTINGS_SECTION_ID = "org.xmind.ui.export.image";
    private static final String PROP_FORMAT = "FORMAT";
    private static final int LARGE_SIZE = 0x140000;
    private ImageFormat format;
    private ImageExportPage page;
    private MindMapImageExtractor imageExtractor;

    public ImageExportWizard() {
        this.setWindowTitle(WizardMessages.ImageExportWizard_windowTitle);
        this.setDefaultPageImageDescriptor(MindMapUI.getImages().getWizBan("export_wiz.png"));
        this.setDialogSettings(MindMapUIPlugin.getDefault().getDialogSettings(DIALOG_SETTINGS_SECTION_ID));
        this.setNeedsProgressMonitor(true);
    }

    protected void loadDialogSettings(IDialogSettings settings) {
        super.loadDialogSettings(settings);
        String mediaType = settings.get(PROP_FORMAT);
        ImageFormat lastFormat = ImageFormat.findByMediaType((String)mediaType, (ImageFormat)ImageFormat.BMP);
        this.setFormat(lastFormat);
    }

    protected void saveDialogSettings(IDialogSettings settings) {
        super.saveDialogSettings(settings);
        if (this.format != null) {
            settings.put(PROP_FORMAT, this.format.getMediaType());
        }
    }

    protected void addValidPages() {
        this.page = new ImageExportPage();
        this.addPage((IWizardPage)this.page);
    }

    public void setFormat(ImageFormat format) {
        this.format = format;
    }

    public ImageFormat getFormat() {
        return this.format;
    }

    public boolean hasFormat() {
        return this.format != null;
    }

    public boolean performFinish() {
        if (this.page.getPreviewState() == PreviewState.Error && !MessageDialog.openConfirm((Shell)this.getShell(), (String)WizardMessages.ImageExport_ConfirmProceedWithError_title, (String)WizardMessages.ImageExport_ConfirmProceedWithError_message)) {
            return false;
        }
        if (this.page != null) {
            this.page.cancel();
        }
        return super.performFinish();
    }

    protected String getFormatName() {
        return this.hasFormat() ? "'" + this.getFormat().getName() + "'" : "";
    }

    protected boolean isExtensionCompatible(String path, String extension) {
        return super.isExtensionCompatible(path, extension) && this.hasFormat() && this.getFormat().getExtensions().contains(extension.toLowerCase());
    }

    private boolean isImageLarge(Image image) {
        Rectangle r = image.getBounds();
        return r.width * r.height > 0x140000;
    }

    private Shell findParentShell(Display display) {
        Shell parentShell;
        Composite shellParent;
        Shell shell = this.getContainer().getShell();
        if (shell != null && (shellParent = shell.getParent()) instanceof Shell && !(parentShell = (Shell)shellParent).isDisposed() && parentShell.getDisplay() == display) {
            return parentShell;
        }
        return null;
    }

    protected void releaseImageExtractor(MindMapImageExtractor imageExtractor) {
        if (imageExtractor == this.imageExtractor) {
            return;
        }
        imageExtractor.dispose();
    }

    protected MindMapImageExtractor getImageExtractor(Display display, Shell parentShell) {
        if (this.imageExtractor == null) {
            this.imageExtractor = this.createImageExtractor(display, parentShell);
        }
        return this.imageExtractor;
    }

    private MindMapImageExtractor createImageExtractor(Display display, Shell parentShell) {
        if (parentShell != null && !parentShell.isDisposed()) {
            return new MindMapImageExtractor((Composite)parentShell, this.getSourceMindMap().getSheet(), this.getSourceMindMap().getCentralTopic());
        }
        return new MindMapImageExtractor(display, this.getSourceMindMap().getSheet(), this.getSourceMindMap().getCentralTopic());
    }

    public void dispose() {
        if (this.imageExtractor != null) {
            this.imageExtractor.dispose();
            this.imageExtractor = null;
        }
        super.dispose();
    }

    protected void writeImage(Image image, String destPath, IProgressMonitor monitor) throws IOException {
        MonitoredOutputStream output = new MonitoredOutputStream((OutputStream)new FileOutputStream(destPath), monitor);
        ImageWriter writer = this.createImageWriter(image, (OutputStream)output);
        try {
            writer.write();
        }
        finally {
            output.close();
        }
    }

    protected ImageWriter createImageWriter(Image image, OutputStream output) {
        return ImageExportUtils.createImageWriter((Image)image, (int)this.getFormat().getSWTFormat(), (OutputStream)output);
    }

    protected void doExport(IProgressMonitor monitor, Display display, Shell parentShell) throws InvocationTargetException, InterruptedException {
        Image image;
        monitor.beginTask(null, 100);
        monitor.subTask(WizardMessages.ImageExport_CreatingSourceImage);
        MindMapImageExtractor imageExtractor = this.getImageExtractor(display, parentShell);
        try {
            image = imageExtractor.getImage();
        }
        catch (Throwable e) {
            monitor.setCanceled(true);
            throw new InvocationTargetException(e);
        }
        if (monitor.isCanceled()) {
            throw new InterruptedException();
        }
        monitor.worked(50);
        String path = this.getTargetPath();
        monitor.subTask(NLS.bind((String)WizardMessages.ImageExport_WritingTargetFile, (Object)path));
        try {
            try {
                this.writeImage(image, path, monitor);
            }
            catch (IOException e) {
                if (monitor.isCanceled()) {
                    throw new InterruptedException();
                }
                throw new InvocationTargetException(e);
            }
        }
        finally {
            this.releaseImageExtractor(imageExtractor);
        }
        monitor.worked(49);
        this.launchTargetFile(true, monitor, display, parentShell);
        monitor.done();
    }

    private static String makeErrorMessage(String originalMessage, boolean largeImage) {
        if (largeImage) {
            return String.valueOf(originalMessage) + " " + WizardMessages.ImageExportPage_ImageTooLarge;
        }
        return originalMessage;
    }

    protected void handleExportException(Throwable e) {
        super.handleExportException(e);
        this.page.setErrorMessage(e.getLocalizedMessage());
    }

    private class ImageExportPage
    extends AbstractMindMapExportPage {
        private Combo formatCombo;
        private ImagePreviewViewer viewer;
        private Image previewImage;
        private String previewPath;
        private GeneratePreviewJob generatePreviewJob;
        private PreviewState previewState;

        protected ImageExportPage() {
            super(ImageExportWizard.IMAGE_EXPORT_PAGE_NAME, WizardMessages.ImageExportPage_title);
            this.setDescription(WizardMessages.ImageExportPage_description);
        }

        public void createControl(Composite parent) {
            Composite composite = new Composite(parent, 0);
            GridLayout layout = new GridLayout();
            layout.verticalSpacing = 15;
            composite.setLayout((Layout)layout);
            this.setControl((Control)composite);
            this.createFormatControls(composite);
            this.createPreviewControl(composite);
            Control fileGroup = this.createFileControls(composite);
            fileGroup.setLayoutData((Object)new GridData(4, 4, true, false));
            this.updateStatus();
            this.generatePreview(ImageExportWizard.this.getFormat());
        }

        private void createPreviewControl(Composite parent) {
            this.viewer = new ImagePreviewViewer(true);
            this.viewer.setPrefWidth(400);
            this.viewer.createControl(parent);
            this.viewer.getControl().setLayoutData((Object)new GridData(4, 4, true, true));
            this.viewer.getControl().setFont(FontUtils.getNewHeight((String)"org.eclipse.jface.defaultfont", (int)8));
            this.hookWidget((Widget)this.viewer.getControl(), 11);
            parent.getDisplay().asyncExec(new Runnable(){

                public void run() {
                    ImageExportPage.this.updateViewerSize();
                }
            });
        }

        private void createFormatControls(Composite parent) {
            Group group = new Group(parent, 0);
            group.setLayoutData((Object)new GridData(4, 4, true, false));
            group.setLayout((Layout)new GridLayout());
            group.setText(WizardMessages.ImageExportPage_FormatGroup_title);
            Label label = new Label((Composite)group, 64);
            GridData gd = new GridData(4, 4, true, false);
            gd.widthHint = 400;
            label.setLayoutData((Object)gd);
            label.setText(WizardMessages.ImageExportPage_FormatGroup_description);
            this.formatCombo = new Combo((Composite)group, 2124);
            this.formatCombo.setLayoutData((Object)new GridData(4, 4, true, false));
            ImageFormat[] imageFormatArray = ImageFormat.values();
            int n = imageFormatArray.length;
            int n2 = 0;
            while (n2 < n) {
                ImageFormat format = imageFormatArray[n2];
                this.formatCombo.add(format.getDescription());
                ++n2;
            }
            if (ImageExportWizard.this.getFormat() != null) {
                this.formatCombo.select(ImageExportWizard.this.getFormat().ordinal());
            }
            this.hookWidget((Widget)this.formatCombo, 13);
        }

        public void dispose() {
            super.dispose();
            this.viewer = null;
            this.disposePreview();
        }

        private void disposePreview() {
            this.cancel();
            if (this.previewImage != null) {
                this.previewImage.dispose();
                this.previewImage = null;
            }
            if (this.previewPath != null) {
                ImageExportWizard.this.deleteTemporaryPath(this.previewPath);
                this.previewPath = null;
            }
        }

        protected void handleWidgetEvent(Event event) {
            if (event.widget == this.formatCombo) {
                int selection = this.formatCombo.getSelectionIndex();
                ImageFormat oldFormat = ImageExportWizard.this.getFormat();
                if (selection < 0) {
                    ImageExportWizard.this.setFormat(null);
                } else {
                    ImageExportWizard.this.setFormat(ImageFormat.values()[selection]);
                }
                if (oldFormat != ImageExportWizard.this.getFormat()) {
                    this.formatChanged();
                }
            } else if (this.viewer != null && event.widget == this.viewer.getControl()) {
                this.updateViewerSize();
            } else {
                super.handleWidgetEvent(event);
            }
        }

        private void updateViewerSize() {
            if (this.viewer == null || this.viewer.getControl().isDisposed()) {
                return;
            }
            Canvas canvas = this.viewer.getCanvas();
            if (canvas == null || canvas.isDisposed()) {
                return;
            }
            Rectangle bounds = canvas.getBounds();
            this.viewer.setPrefWidth(bounds.width);
            this.viewer.setPrefHeight(bounds.height);
        }

        protected boolean isPageCompletable() {
            return super.isPageCompletable() && ImageExportWizard.this.hasFormat();
        }

        protected String generateWarningMessage() {
            if (this.previewState == PreviewState.Error && this.viewer != null) {
                return this.viewer.getTitle();
            }
            return super.generateWarningMessage();
        }

        public PreviewState getPreviewState() {
            return this.previewState;
        }

        protected FileDialog createBrowseDialog() {
            FileDialog dialog = super.createBrowseDialog();
            DialogUtils.makeImageSelectorDialog(dialog, false, ImageExportWizard.this.getFormat());
            return dialog;
        }

        protected String getSuggestedFileName() {
            return String.valueOf(super.getSuggestedFileName()) + (String)ImageExportWizard.this.getFormat().getExtensions().get(0);
        }

        private void formatChanged() {
            String ext;
            List exts;
            if (this.hasTargetPath() && ImageExportWizard.this.hasFormat() && !(exts = ImageExportWizard.this.getFormat().getExtensions()).contains(ext = FileUtils.getExtension((String)this.getTargetPath()))) {
                this.setTargetPath(this.replaceExtension(this.getTargetPath(), ext, (String)exts.get(0)));
            }
            this.updateStatus();
            this.generatePreview(ImageExportWizard.this.getFormat());
        }

        private String replaceExtension(String path, String oldExt, String newExt) {
            return String.valueOf(path.substring(0, path.length() - oldExt.length())) + newExt;
        }

        private void generatePreview(ImageFormat format) {
            if (format == null) {
                return;
            }
            if (this.viewer != null && !this.viewer.getControl().isDisposed()) {
                this.updateViewer(null, PreviewState.Generating, false, null);
            }
            this.disposePreview();
            this.previewPath = ImageExportWizard.this.requestTemporaryPath(null, (String)format.getExtensions().get(0), true);
            if (this.previewPath == null) {
                this.updateViewer(null, PreviewState.Error, false, null);
                return;
            }
            Display display = Display.getCurrent();
            this.generatePreviewJob = new GeneratePreviewJob(this.previewPath, format, display);
            this.generatePreviewJob.schedule();
        }

        private void asyncUpdateViewer(Display display, final Image image, final PreviewState state, final boolean largeImage, final Point origin) {
            if (Thread.currentThread() != display.getThread()) {
                display.asyncExec(new Runnable(){

                    public void run() {
                        ImageExportPage.this.updateViewer(image, state, largeImage, origin);
                    }
                });
            } else {
                this.updateViewer(image, state, largeImage, origin);
            }
        }

        private void updateViewer(Image image, PreviewState state, boolean largeImage, Point origin) {
            this.previewState = state;
            if (this.viewer == null || this.viewer.getControl().isDisposed()) {
                return;
            }
            if (image != null && origin != null) {
                this.viewer.setImage(image, (double)origin.x, (double)origin.y);
            } else {
                this.viewer.setImage(image);
            }
            if (this.viewer.getRatio() > 1.0) {
                this.viewer.changeRatio(1.0);
            }
            this.viewer.setTitle(state.getTitle(image, largeImage));
            this.viewer.setTitlePlacement(state.getTitlePlacement());
            state.setColor(this.viewer.getControl());
            this.updateStatus();
        }

        public void cancel() {
            if (this.generatePreviewJob != null) {
                this.generatePreviewJob.cancel();
                this.generatePreviewJob = null;
            }
        }

        private class GeneratePreviewJob
        extends Job {
            private String destPath;
            private Display display;
            private Shell parentShell;

            public GeneratePreviewJob(String destPath, ImageFormat format, Display display) {
                super(NLS.bind((String)WizardMessages.ImageExportPage_GeneratePreview_jobName, (Object)format.getName()));
                this.destPath = destPath;
                this.display = display;
                this.parentShell = ImageExportWizard.this.findParentShell(display);
            }

            protected IStatus run(IProgressMonitor monitor) {
                Image image;
                monitor.beginTask(null, 100);
                monitor.subTask(WizardMessages.ImageExportPage_GeneratePreview_CreatingSourceImage);
                MindMapImageExtractor imageExtractor = ImageExportWizard.this.getImageExtractor(this.display, this.parentShell);
                try {
                    image = imageExtractor.getImage();
                }
                catch (Throwable e) {
                    if (ImageExportPage.this.generatePreviewJob == this) {
                        ImageExportPage.this.generatePreviewJob = null;
                    }
                    ImageExportPage.this.asyncUpdateViewer(this.display, null, PreviewState.Error, false, null);
                    return new Status(4, "org.xmind.ui.mindmap", WizardMessages.ImageExportPage_GeneratePreview_CouldNotCreateSourceImage, e);
                }
                if (monitor.isCanceled()) {
                    ImageExportWizard.this.releaseImageExtractor(imageExtractor);
                    if (ImageExportPage.this.generatePreviewJob == this) {
                        ImageExportPage.this.generatePreviewJob = null;
                    }
                    return new Status(8, "org.xmind.ui.mindmap", WizardMessages.ImageExportPage_GeneratePreview_Canceled);
                }
                monitor.worked(40);
                boolean largeImage = ImageExportWizard.this.isImageLarge(image);
                Point origin = null;
                monitor.subTask(WizardMessages.ImageExportPage_GeneratePreview_SavingTempFile);
                try {
                    try {
                        ImageExportWizard.this.writeImage(image, this.destPath, monitor);
                        origin = imageExtractor.getOrigin();
                    }
                    catch (StreamInterruptedException streamInterruptedException) {
                        ImageExportWizard.this.deleteTemporaryPath(this.destPath);
                        if (ImageExportPage.this.generatePreviewJob == this) {
                            ImageExportPage.this.generatePreviewJob = null;
                        }
                        Status status = new Status(8, "org.xmind.ui.mindmap", WizardMessages.ImageExportPage_GeneratePreview_Canceled);
                        ImageExportWizard.this.releaseImageExtractor(imageExtractor);
                        return status;
                    }
                    catch (Throwable e) {
                        block24: {
                            ImageExportWizard.this.deleteTemporaryPath(this.destPath);
                            if (!monitor.isCanceled()) break block24;
                            if (ImageExportPage.this.generatePreviewJob == this) {
                                ImageExportPage.this.generatePreviewJob = null;
                            }
                            Status status = new Status(8, "org.xmind.ui.mindmap", WizardMessages.ImageExportPage_GeneratePreview_Canceled);
                            ImageExportWizard.this.releaseImageExtractor(imageExtractor);
                            return status;
                        }
                        ImageExportPage.this.asyncUpdateViewer(this.display, null, PreviewState.Error, largeImage, origin);
                        Status status = new Status(8, "org.xmind.ui.mindmap", ImageExportWizard.makeErrorMessage(WizardMessages.ImageExportPage_GeneratePreview_CouldNotSavePreviewImage, largeImage), e);
                        ImageExportWizard.this.releaseImageExtractor(imageExtractor);
                        return status;
                    }
                }
                finally {
                    ImageExportWizard.this.releaseImageExtractor(imageExtractor);
                }
                if (monitor.isCanceled()) {
                    ImageExportWizard.this.deleteTemporaryPath(this.destPath);
                    if (ImageExportPage.this.generatePreviewJob == this) {
                        ImageExportPage.this.generatePreviewJob = null;
                    }
                    return new Status(8, "org.xmind.ui.mindmap", WizardMessages.ImageExportPage_GeneratePreview_Canceled);
                }
                monitor.worked(40);
                monitor.subTask(WizardMessages.ImageExportPage_GeneratePreview_LoadingTempFile);
                File previewFile = new File(this.destPath);
                if (!previewFile.exists() || !previewFile.canRead()) {
                    if (ImageExportPage.this.generatePreviewJob == this) {
                        ImageExportPage.this.generatePreviewJob = null;
                    }
                    ImageExportPage.this.asyncUpdateViewer(this.display, null, PreviewState.Error, largeImage, origin);
                    return new Status(8, "org.xmind.ui.mindmap", WizardMessages.ImageExportPage_GeneratePreview_CouldNotLoadPreviewImage);
                }
                try {
                    ImageExportPage.this.previewImage = new Image((Device)Display.getCurrent(), this.destPath);
                }
                catch (Throwable e) {
                    if (ImageExportPage.this.generatePreviewJob == this) {
                        ImageExportPage.this.generatePreviewJob = null;
                    }
                    ImageExportPage.this.asyncUpdateViewer(this.display, null, PreviewState.Error, largeImage, origin);
                    return new Status(8, "org.xmind.ui.mindmap", WizardMessages.ImageExportPage_GeneratePreview_CouldNotLoadPreviewImage, e);
                }
                ImageExportPage.this.asyncUpdateViewer(this.display, ImageExportPage.this.previewImage, PreviewState.Showing, false, origin);
                if (ImageExportPage.this.generatePreviewJob == this) {
                    ImageExportPage.this.generatePreviewJob = null;
                }
                monitor.done();
                return new Status(0, "org.xmind.ui.mindmap", WizardMessages.ImageExportPage_GeneratePreview_Completed);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum PreviewState {
        Showing(null, 16, 132096){

            public String getTitle(Image image, boolean largeImage) {
                if (image == null) {
                    return super.getTitle(image, largeImage);
                }
                Rectangle r = image.getBounds();
                return String.format("%d x %d", r.width, r.height);
            }
        }
        ,
        Generating(WizardMessages.ImageExportPage_GeneratingPreview, 16, 0),
        Error(WizardMessages.ImageExportPage_FailedToGeneratePreview, 4, 0){

            public String getTitle(Image image, boolean largeImage) {
                return ImageExportWizard.makeErrorMessage(super.getTitle(image, largeImage), largeImage);
            }
        };

        private int colorId;
        private String title;
        private int titlePlacement;

        private PreviewState(String title, int colorId, int titlePlacement) {
            this.title = title;
            this.colorId = colorId;
            this.titlePlacement = titlePlacement;
        }

        public String getTitle(Image image, boolean largeImage) {
            return this.title;
        }

        public void setColor(Control control) {
            control.setForeground(control.getDisplay().getSystemColor(this.colorId));
        }

        public int getTitlePlacement() {
            return this.titlePlacement;
        }
    }
}

