/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.views;

import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.xmind.core.style.IStyle;
import org.xmind.gef.EditDomain;
import org.xmind.gef.IViewer;
import org.xmind.gef.part.GraphicalEditPart;
import org.xmind.gef.part.IPart;
import org.xmind.gef.part.IPartFactory;
import org.xmind.gef.tool.ITool;
import org.xmind.gef.util.Properties;
import org.xmind.ui.gallery.FramePart;
import org.xmind.ui.gallery.GalleryEditTool;
import org.xmind.ui.gallery.GalleryLayout;
import org.xmind.ui.gallery.GallerySelectTool;
import org.xmind.ui.gallery.GalleryViewer;
import org.xmind.ui.internal.views.ThemeFigure;
import org.xmind.ui.mindmap.MindMapUI;
import org.xmind.ui.texteditor.FloatingTextEditor;

public class ThemesViewer
extends GalleryViewer {
    public ThemesViewer(Composite parent) {
        this.setPartFactory(new ThemePartFactory(this.getPartFactory()));
        this.setLabelProvider((IBaseLabelProvider)new ThemeLabelProvider());
        Properties properties = this.getProperties();
        properties.set("org.xmind.ui.gallery.horizontal", (Object)Boolean.TRUE);
        properties.set("org.xmind.ui.gallery.wrap", (Object)Boolean.TRUE);
        properties.set("org.xmind.ui.gallery.layout", (Object)new GalleryLayout(0, 3, 1, 1, new Insets(5)));
        properties.set("org.xmind.ui.gallery.frameContentSize", (Object)new Dimension(128, 64));
        properties.set("org.xmind.ui.gallery.titlePlacement", (Object)GalleryViewer.TITLE_TOP);
        properties.set("org.xmind.ui.gallery.singleClickToOpen", (Object)Boolean.FALSE);
        EditDomain editDomain = new EditDomain();
        editDomain.installTool("select tool", (ITool)new ThemeSelectTool());
        editDomain.installTool("edit tool", (ITool)new ThemeNameEditTool());
        editDomain.setViewer((IViewer)this);
        this.createControl(parent);
        Display display = parent.getDisplay();
        this.getControl().setBackground(display.getSystemColor(25));
    }

    public void setSelection(ISelection selection) {
        super.setSelection(selection, true);
    }

    private static class ThemeLabelProvider
    extends LabelProvider {
        private ThemeLabelProvider() {
        }

        public String getText(Object element) {
            if (element instanceof IStyle) {
                IStyle style = (IStyle)element;
                return style.getName();
            }
            return super.getText(element);
        }
    }

    private static class ThemeNameEditTool
    extends GalleryEditTool {
        private ThemeNameEditTool() {
        }

        protected IDocument getTextContents(IPart source) {
            return new Document(((IStyle)source.getModel()).getName());
        }

        protected void handleTextModified(IPart source, IDocument document) {
            ((IStyle)source.getModel()).setName(document.get());
            MindMapUI.getResourceManager().saveUserThemeSheet();
        }

        protected void hookEditor(FloatingTextEditor editor) {
            super.hookEditor(editor);
            this.getHelper().setPrefWidth(130);
        }
    }

    private static class ThemePart
    extends GraphicalEditPart {
        public ThemePart(IStyle style) {
            this.setModel(style);
        }

        public IStyle getStyle() {
            return (IStyle)super.getModel();
        }

        protected IFigure createFigure() {
            return new ThemeFigure();
        }

        protected void updateView() {
            super.updateView();
            ((ThemeFigure)this.getFigure()).setTheme(this.getStyle());
            Properties properties = ((GalleryViewer)this.getSite().getViewer()).getProperties();
            Dimension size = (Dimension)properties.get("org.xmind.ui.gallery.frameContentSize");
            if (size != null) {
                this.getFigure().setPreferredSize(size);
            }
        }
    }

    private static class ThemePartFactory
    implements IPartFactory {
        private IPartFactory factory;

        public ThemePartFactory(IPartFactory factory) {
            this.factory = factory;
        }

        public IPart createPart(IPart context, Object model) {
            if (context instanceof FramePart && model instanceof IStyle) {
                return new ThemePart((IStyle)model);
            }
            return this.factory.createPart(context, model);
        }
    }

    private static class ThemeSelectTool
    extends GallerySelectTool {
        private ThemeSelectTool() {
        }

        public boolean isTitleEditable(IPart p) {
            if (!super.isTitleEditable(p)) {
                return false;
            }
            IStyle theme = (IStyle)p.getModel();
            return theme != MindMapUI.getResourceManager().getDefaultTheme() && theme.getOwnedStyleSheet() != MindMapUI.getResourceManager().getSystemThemeSheet();
        }
    }
}

