/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.views;

import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.swt.graphics.Color;
import org.xmind.core.style.IStyle;
import org.xmind.gef.draw2d.graphics.GraphicsUtils;
import org.xmind.ui.internal.views.StyleFigureUtils;

public class ThemeFigure
extends Figure {
    private static final Rectangle RECT = new Rectangle();
    private IStyle theme = null;

    public IStyle getTheme() {
        return this.theme;
    }

    public void setTheme(IStyle theme) {
        if (theme == this.theme) {
            return;
        }
        this.theme = theme;
        this.repaint();
    }

    public void paint(Graphics graphics) {
        GraphicsUtils.fixGradientBugForCarbon((Graphics)graphics, (IFigure)this);
        super.paint(graphics);
    }

    protected void paintFigure(Graphics graphics) {
        super.paintFigure(graphics);
        this.drawTheme(graphics);
    }

    protected void drawTheme(Graphics graphics) {
        if (this.theme == null) {
            return;
        }
        graphics.setAntialias(1);
        graphics.setTextAntialias(1);
        Rectangle r = this.getClientArea(RECT);
        this.drawTheme(graphics, this.theme, r);
    }

    protected void drawTheme(Graphics graphics, IStyle theme, Rectangle r) {
        IStyle sheetStyle = theme.getDefaultStyle("map");
        IStyle centralStyle = theme.getDefaultStyle("centralTopic");
        IStyle mainStyle = theme.getDefaultStyle("mainTopic");
        Rectangle centralBounds = ThemeFigure.centralBounds(r);
        Rectangle mainBounds1 = ThemeFigure.mainBounds1(r);
        Rectangle mainBounds2 = ThemeFigure.mainBounds2(r);
        StyleFigureUtils.drawSheetBackground(graphics, r, sheetStyle, StyleFigureUtils.defaultSheetStyle, false);
        boolean tapered = true;
        Color lineColor1 = StyleFigureUtils.getBranchConnectionColor(mainStyle, StyleFigureUtils.defaultMainStyle, centralStyle, StyleFigureUtils.defaultCentralStyle, 0, ColorConstants.gray);
        graphics.setForegroundColor(lineColor1);
        StyleFigureUtils.drawLine(graphics, centralBounds, centralStyle, StyleFigureUtils.defaultCentralStyle, false, mainBounds1, mainStyle, StyleFigureUtils.defaultMainStyle, true, tapered);
        StyleFigureUtils.drawTopic(graphics, mainBounds1, mainStyle, StyleFigureUtils.defaultMainStyle, true);
        Color lineColor2 = StyleFigureUtils.getBranchConnectionColor(mainStyle, StyleFigureUtils.defaultMainStyle, centralStyle, StyleFigureUtils.defaultCentralStyle, 1, ColorConstants.gray);
        graphics.setForegroundColor(lineColor2);
        StyleFigureUtils.drawLine(graphics, centralBounds, centralStyle, StyleFigureUtils.defaultCentralStyle, false, mainBounds2, mainStyle, StyleFigureUtils.defaultMainStyle, true, tapered);
        StyleFigureUtils.drawTopic(graphics, mainBounds2, mainStyle, StyleFigureUtils.defaultMainStyle, true);
        StyleFigureUtils.drawTopic(graphics, centralBounds, centralStyle, StyleFigureUtils.defaultCentralStyle, false);
    }

    public static Rectangle centralBounds(Rectangle r) {
        int x = r.x + r.width * 3 / 10;
        int y = r.y + r.height * 5 / 10;
        int w = r.width * 4 / 10;
        int h = r.height * 5 / 10;
        return new Rectangle(x -= w / 2, y -= h / 2, w, h);
    }

    public static Rectangle mainBounds1(Rectangle r) {
        float x = (float)r.x + (float)r.width * 7.5f / 10.0f;
        float y = (float)r.y + (float)r.height * 2.5f / 10.0f;
        float w = (float)r.width * 3.0f / 10.0f;
        float h = (float)r.height * 2.5f / 10.0f;
        return new Rectangle((int)(x -= w / 2.0f), (int)(y -= h / 2.0f), (int)w, (int)h);
    }

    public static Rectangle mainBounds2(Rectangle r) {
        float x = (float)r.x + (float)r.width * 7.5f / 10.0f;
        float y = (float)r.y + (float)r.height * 7.5f / 10.0f;
        float w = (float)r.width * 3.0f / 10.0f;
        float h = (float)r.height * 2.5f / 10.0f;
        return new Rectangle((int)(x -= w / 2.0f), (int)(y -= h / 2.0f), (int)w, (int)h);
    }
}

