/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.tools;

import org.eclipse.core.runtime.Assert;
import org.eclipse.draw2d.Cursors;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.Layer;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.xmind.gef.GEF;
import org.xmind.gef.Request;
import org.xmind.gef.event.MouseDragEvent;
import org.xmind.gef.event.MouseEvent;
import org.xmind.gef.part.IGraphicalEditPart;
import org.xmind.gef.part.IPart;
import org.xmind.gef.tool.ITool;
import org.xmind.ui.internal.MindMapMessages;
import org.xmind.ui.mindmap.ITopicPart;
import org.xmind.ui.resources.ColorUtils;
import org.xmind.ui.texteditor.FloatingTextEditor;
import org.xmind.ui.tools.TitleEditTool;

public class TopicTitleEditTool
extends TitleEditTool {
    private static final int HANDLE_WIDTH = 8;
    private IFigure widthHandle;
    private boolean locatingHandle = false;
    private boolean mouseDownOnHandle = false;
    private boolean draggingHandle = false;
    private boolean widthChanged = false;
    private int width = -1;

    public String getType() {
        return "org.xmind.ui.tool.editTopicTitle";
    }

    public void setSource(IGraphicalEditPart source) {
        Assert.isTrue((boolean)(source instanceof ITopicPart));
        super.setSource(source);
    }

    protected void hookEditorControl(FloatingTextEditor editor, ITextViewer textViewer) {
        super.hookEditorControl(editor, textViewer);
        this.widthHandle = this.createHandle();
        if (this.widthHandle != null) {
            editor.getControl().addControlListener(new ControlListener(){

                public void controlResized(ControlEvent e) {
                    TopicTitleEditTool.this.locateHandle((Control)e.widget);
                }

                public void controlMoved(ControlEvent e) {
                    TopicTitleEditTool.this.locateHandle((Control)e.widget);
                }
            });
            this.locateHandle(editor.getControl());
        }
    }

    private void locateHandle(final Control control) {
        if (this.widthHandle == null) {
            return;
        }
        if (this.locatingHandle) {
            return;
        }
        this.locatingHandle = true;
        Display.getCurrent().asyncExec(new Runnable(){

            public void run() {
                if (TopicTitleEditTool.this.widthHandle == null || TopicTitleEditTool.this.getTargetViewer() == null || TopicTitleEditTool.this.getTargetViewer().getControl() == null || TopicTitleEditTool.this.getTargetViewer().getControl().isDisposed()) {
                    return;
                }
                Rectangle bounds = new Rectangle(control.getBounds());
                Point loc = TopicTitleEditTool.this.getTargetViewer().computeToLayer(bounds.getLocation(), false);
                TopicTitleEditTool.this.widthHandle.setBounds(new Rectangle(loc.x + bounds.width, loc.y, 8, bounds.height));
                TopicTitleEditTool.this.locatingHandle = false;
            }
        });
    }

    private IFigure createHandle() {
        Layer layer = this.getTargetViewer().getLayer(GEF.LAYER_FEEDBACK);
        if (layer == null) {
            return null;
        }
        DragHandle handle = new DragHandle();
        layer.add((IFigure)handle);
        return handle;
    }

    private boolean isHandleContains(IFigure handle, Point p) {
        return handle.containsPoint(this.getScaled(p));
    }

    protected boolean shouldFinishOnMouseDown(MouseEvent me) {
        if (this.widthHandle != null && this.isHandleContains(this.widthHandle, me.cursorLocation)) {
            this.mouseDownOnHandle = true;
            return false;
        }
        this.mouseDownOnHandle = false;
        return super.shouldFinishOnMouseDown(me);
    }

    protected void hookEditor(FloatingTextEditor editor) {
        super.hookEditor(editor);
        this.width = ((ITopicPart)this.getSource()).getTopic().getTitleWidth();
        if (this.getHelper() != null) {
            this.getHelper().setPrefWidth(this.width);
        }
    }

    protected void unhookEditor(FloatingTextEditor editor) {
        super.unhookEditor(editor);
        if (this.widthHandle != null) {
            if (this.widthHandle.getParent() != null) {
                this.widthHandle.getParent().remove(this.widthHandle);
            }
            this.widthHandle = null;
        }
    }

    protected void onActivated(ITool prevTool) {
        this.mouseDownOnHandle = false;
        this.draggingHandle = false;
        this.widthChanged = false;
        super.onActivated(prevTool);
    }

    protected void onDeactivated(ITool nextTool) {
        this.mouseDownOnHandle = false;
        this.draggingHandle = false;
        this.widthChanged = false;
        super.onDeactivated(nextTool);
    }

    protected boolean handleMouseDrag(MouseDragEvent me) {
        if (this.mouseDownOnHandle) {
            this.draggingHandle = true;
        }
        if (this.draggingHandle) {
            Point p = this.getScaled(me.cursorLocation);
            Point leftTop = this.getTargetViewer().computeToLayer(new Point(this.getEditor().getControl().getLocation()), false);
            this.width = Math.max(20, (int)((double)(p.x - leftTop.x) / this.getScale()));
            this.getHelper().setPrefWidth(this.width);
            this.getHelper().refreshEditor();
            return true;
        }
        return super.handleMouseDrag(me);
    }

    protected boolean handleMouseEntered(MouseEvent me) {
        if (this.mouseDownOnHandle || this.draggingHandle) {
            return true;
        }
        return super.handleMouseEntered(me);
    }

    protected boolean handleMouseUp(MouseEvent me) {
        if (!this.widthChanged && this.draggingHandle) {
            this.widthChanged = true;
        }
        this.draggingHandle = false;
        this.mouseDownOnHandle = false;
        return super.handleMouseUp(me);
    }

    protected Request createTextRequest(IPart source, IDocument document) {
        Request request = super.createTextRequest(source, document);
        if (this.widthChanged) {
            request.setParameter("property.titleWidth", (Object)this.width);
        }
        return request;
    }

    protected boolean shouldIgnoreTextChange(IPart source, IDocument document, String oldText) {
        return !this.widthChanged && super.shouldIgnoreTextChange(source, document, oldText);
    }

    private double getScale() {
        return this.getTargetViewer().getZoomManager().getScale();
    }

    private Point getScaled(Point p) {
        return this.getTargetViewer().getZoomManager().getScaled(p);
    }

    public IFigure findToolTip(IPart source, Point position) {
        if (!this.mouseDownOnHandle && !this.draggingHandle && this.widthHandle != null && this.isHandleContains(this.widthHandle, position)) {
            return new Label(MindMapMessages.ModifyWrapWidth_toolTip0);
        }
        return super.getToolTip(source, position);
    }

    public Cursor getCurrentCursor(Point pos, IPart host) {
        if (this.mouseDownOnHandle || this.draggingHandle || this.widthHandle != null && this.isHandleContains(this.widthHandle, pos)) {
            return Cursors.SIZEWE;
        }
        return super.getCurrentCursor(pos, host);
    }

    private static class DragHandle
    extends Figure {
        private Color triangleColor = ColorUtils.getColor((String)"#606060");

        public DragHandle() {
            this.setForegroundColor(ColorUtils.getColor((String)"#009900"));
            this.setBackgroundColor(ColorUtils.getColor((String)"#33cc33"));
        }

        protected void paintFigure(Graphics graphics) {
            super.paintFigure(graphics);
            graphics.setAntialias(1);
            graphics.setAlpha(208);
            Rectangle r = this.getBounds();
            graphics.fillRectangle(r.x, r.y, r.width, r.height);
            int cy = r.y + r.height / 2;
            int cx = r.x + r.width / 2;
            graphics.setBackgroundColor(this.triangleColor);
            graphics.fillPolygon(new int[]{cx - 2, cy - 1, cx - 2, cy - 8, cx + 2, cy - 5});
            graphics.fillPolygon(new int[]{cx - 2, cy + 5, cx + 2, cy + 8, cx + 2, cy + 1});
            graphics.drawRectangle(r.x, r.y, r.width - 1, r.height - 1);
        }

        public boolean containsPoint(int x, int y) {
            Rectangle r = this.getBounds();
            return y >= r.y - 2 && y < r.y + r.height + 2 && x >= r.x - 2 && x < r.x + r.width + 2;
        }
    }
}

