/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.tools;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.Assert;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.swt.graphics.Cursor;
import org.xmind.core.ISummary;
import org.xmind.core.ITopic;
import org.xmind.core.ITopicRange;
import org.xmind.gef.GEF;
import org.xmind.gef.IViewer;
import org.xmind.gef.Request;
import org.xmind.gef.draw2d.IReferencedFigure;
import org.xmind.gef.event.MouseDragEvent;
import org.xmind.gef.graphicalpolicy.IStructure;
import org.xmind.gef.part.IGraphicalEditPart;
import org.xmind.gef.part.IPart;
import org.xmind.gef.status.IStatusListener;
import org.xmind.gef.status.StatusEvent;
import org.xmind.gef.tool.ITool;
import org.xmind.ui.branch.ILockableBranchStructureExtension;
import org.xmind.ui.branch.IMovableBranchStructureExtension;
import org.xmind.ui.internal.tools.BranchDummy;
import org.xmind.ui.internal.tools.TopicMoveToolHelper;
import org.xmind.ui.mindmap.IBranchPart;
import org.xmind.ui.mindmap.IMindMapImages;
import org.xmind.ui.mindmap.ITopicPart;
import org.xmind.ui.mindmap.MindMapUI;
import org.xmind.ui.tools.DummyMoveTool;
import org.xmind.ui.tools.ITopicMoveToolHelper;
import org.xmind.ui.tools.ParentSearchKey;
import org.xmind.ui.tools.ParentSearcher;
import org.xmind.ui.util.MindMapUtils;

public class TopicMoveTool
extends DummyMoveTool
implements IStatusListener {
    private static ITopicMoveToolHelper defaultHelper = null;
    private ParentSearcher parentSearcher = null;
    private boolean slightMove = false;
    private ITopicMoveToolHelper helper = null;
    private ParentSearchKey key = null;
    private BranchDummy branchDummy = null;
    private IBranchPart targetParent = null;
    private List<IFigure> disabledFigures = null;

    public TopicMoveTool() {
        this.getStatus().addStatusListener((IStatusListener)this);
    }

    public void setSource(IGraphicalEditPart source) {
        Assert.isTrue((boolean)(source instanceof ITopicPart));
        super.setSource(source);
    }

    protected ITopicPart getSourceTopic() {
        return (ITopicPart)super.getSource();
    }

    protected IBranchPart getSourceBranch() {
        return (IBranchPart)this.getSourceTopic().getParent();
    }

    protected void onActivated(ITool prevTool) {
        super.onActivated(prevTool);
        this.lockBranchStructures((IPart)this.getTargetViewer().getRootPart());
        this.collectDisabledBranches();
        if (!this.isCopyMove()) {
            this.disableFigures();
        }
    }

    private void lockBranchStructures(IPart part) {
        IBranchPart branch;
        IStructure sa;
        if (part instanceof IBranchPart && (sa = (branch = (IBranchPart)part).getBranchPolicy().getStructure(branch)) instanceof ILockableBranchStructureExtension) {
            ((ILockableBranchStructureExtension)sa).lock(branch);
        }
        for (IPart child : part.getChildren()) {
            this.lockBranchStructures(child);
        }
    }

    private void unlockBranchStructures(IPart part) {
        IBranchPart branch;
        IStructure sa;
        if (part instanceof IBranchPart && (sa = (branch = (IBranchPart)part).getBranchPolicy().getStructure(branch)) instanceof ILockableBranchStructureExtension) {
            ((ILockableBranchStructureExtension)sa).unlock(branch);
        }
        for (IPart child : part.getChildren()) {
            this.unlockBranchStructures(child);
        }
    }

    protected IFigure createDummy() {
        this.slightMove = true;
        if (this.branchDummy == null) {
            this.branchDummy = new BranchDummy(this.getTargetViewer(), this.getSourceBranch());
        }
        return this.branchDummy.getBranch().getFigure();
    }

    protected void destroyDummy(IFigure dummy) {
        if (this.branchDummy != null) {
            this.branchDummy.dispose();
            this.branchDummy = null;
        }
        super.destroyDummy(dummy);
    }

    private void collectDisabledBranches() {
        List selectedParts = this.getSelectedParts((IViewer)this.getTargetViewer());
        for (IPart part : selectedParts) {
            this.addDisabledPart(part);
        }
        List<ITopic> topics = MindMapUtils.getTopics(selectedParts);
        Set<ITopicRange> ranges = MindMapUtils.findContainedRanges(topics, true, false);
        if (!ranges.isEmpty()) {
            for (ITopicRange r : ranges) {
                ITopic st = ((ISummary)r).getTopic();
                if (st == null) continue;
                this.addDisabledPart(this.getTargetViewer().findPart((Object)st));
            }
        }
    }

    private void addDisabledPart(IPart part) {
        if (part instanceof ITopicPart) {
            ITopicPart topic = (ITopicPart)part;
            this.addDisabledFigure(topic.getFigure());
            IBranchPart branch = topic.getOwnerBranch();
            if (branch != null) {
                this.addDisabledFigure(branch.getFigure());
            }
        }
    }

    private void addDisabledFigure(IFigure figure) {
        if (this.disabledFigures == null) {
            this.disabledFigures = new ArrayList<IFigure>();
        }
        this.disabledFigures.add(figure);
    }

    private void clearDisabledFigures() {
        this.disabledFigures = null;
    }

    private void disableFigures() {
        if (this.disabledFigures != null) {
            for (IFigure figure : this.disabledFigures) {
                figure.setEnabled(false);
            }
        }
    }

    private void enableFigures() {
        if (this.disabledFigures != null) {
            for (IFigure figure : this.disabledFigures) {
                figure.setEnabled(true);
            }
        }
    }

    protected void onMoving(Point currentPos, MouseDragEvent me) {
        if (this.slightMove && !((IGraphicalEditPart)this.getSourceTopic()).containsPoint(currentPos)) {
            this.slightMove = false;
        }
        super.onMoving(currentPos, me);
        if (this.branchDummy != null) {
            this.key = new ParentSearchKey(this.getSourceTopic(), (IReferencedFigure)this.branchDummy.getBranch().getTopicPart().getFigure(), currentPos);
            this.key.setFeedback(this.branchDummy.getBranch());
            this.targetParent = this.updateTargetParent();
            this.updateWithParent(this.targetParent);
        }
    }

    private IBranchPart updateTargetParent() {
        if (this.isFloatMove()) {
            return null;
        }
        if (this.isFreeMove() || this.isSlightMove()) {
            IPart parent = this.getSourceBranch().getParent();
            return parent instanceof IBranchPart ? (IBranchPart)parent : null;
        }
        return this.getParentSearcher().searchTargetParent((IPart)this.getTargetViewer().getRootPart(), this.key);
    }

    private void updateWithParent(IBranchPart parent) {
        this.updateDummyWithParent(parent);
        this.updateHelperWithParent(parent);
    }

    private void updateDummyWithParent(IBranchPart parent) {
    }

    protected void updateDummyPosition(Point pos) {
        super.updateDummyPosition(pos);
    }

    private void updateHelperWithParent(IBranchPart parent) {
        ITopicMoveToolHelper oldHelper = this.helper;
        ITopicMoveToolHelper newHelper = this.getHelper(parent);
        if (newHelper != oldHelper) {
            if (oldHelper != null) {
                oldHelper.deactivate(this.getDomain(), (IViewer)this.getTargetViewer());
            }
            if (newHelper != null) {
                newHelper.activate(this.getDomain(), (IViewer)this.getTargetViewer());
            }
            this.helper = newHelper;
        }
        if (this.helper != null) {
            this.helper.update(parent, this.key);
        }
    }

    private ITopicMoveToolHelper getHelper(IBranchPart parent) {
        return TopicMoveTool.getDefaultHelper();
    }

    protected static ITopicMoveToolHelper getDefaultHelper() {
        if (defaultHelper == null) {
            defaultHelper = new TopicMoveToolHelper();
        }
        return defaultHelper;
    }

    private boolean isSlightMove() {
        if (this.isFloatMove() || this.isAlreadyFloat()) {
            return false;
        }
        if (this.isFreeable() && (this.isFreeMove() || this.isAlreadyFree())) {
            return false;
        }
        return this.slightMove;
    }

    private boolean isFloatMove() {
        return this.getStatus().isStatus(8);
    }

    private boolean isFreeMove() {
        if (GEF.IS_CARBON) {
            return this.getStatus().isStatus(4);
        }
        return this.getStatus().isStatus(2);
    }

    private boolean isCopyMove() {
        if (GEF.IS_CARBON) {
            return this.getStatus().isStatus(2);
        }
        return this.getStatus().isStatus(4);
    }

    protected ParentSearcher getParentSearcher() {
        if (this.parentSearcher == null) {
            this.parentSearcher = new ParentSearcher();
        }
        return this.parentSearcher;
    }

    protected void end() {
        if (this.helper != null) {
            this.helper.deactivate(this.getDomain(), (IViewer)this.getTargetViewer());
            this.helper = null;
        }
        super.end();
        this.targetParent = null;
        this.parentSearcher = null;
        this.key = null;
        this.enableFigures();
        this.clearDisabledFigures();
        this.unlockBranchStructures((IPart)this.getTargetViewer().getRootPart());
    }

    protected Request createRequest() {
        IStructure structure;
        IBranchPart sourceParent;
        if (this.isSlightMove()) {
            return null;
        }
        IBranchPart targetParentBranch = this.targetParent;
        ITopicPart targetParent = targetParentBranch == null ? null : targetParentBranch.getTopicPart();
        Point position = this.getRelativePosition();
        boolean copy = this.isCopyMove();
        int index = -1;
        boolean free = this.isFreeMove();
        if (!this.isFloatMove()) {
            index = this.getParentSearcher().getIndex(targetParentBranch, this.key);
            if (free) {
                if (!this.isFreeable() && !this.isAlreadyFloat()) {
                    free = false;
                }
            } else if (targetParent != null) {
                if (targetParent == this.getSourceParentTopic()) {
                    if (this.isFreeable()) {
                        free = this.isAlreadyFree();
                    }
                } else {
                    position = null;
                }
            }
            if (!free && targetParent != null) {
                position = null;
            }
        }
        String reqType = copy ? "copy to" : "move to";
        Request request = new Request(reqType);
        request.setDomain(this.getDomain());
        request.setViewer((IViewer)this.getTargetViewer());
        this.fillTargets(request, (IViewer)this.getTargetViewer(), false);
        request.setPrimaryTarget((IPart)this.getSourceTopic());
        request.setParameter("position", (Object)position);
        request.setParameter("positionRelative", (Object)Boolean.TRUE);
        request.setParameter("parent", (Object)targetParent);
        request.setParameter("index", (Object)index);
        request.setParameter("copy", (Object)copy);
        request.setParameter("free", (Object)free);
        IBranchPart sourceBranch = this.getSourceBranch();
        if (sourceBranch != null) {
            sourceParent = sourceBranch.getParentBranch();
            if (sourceParent != null && (structure = sourceParent.getBranchPolicy().getStructure(sourceParent)) instanceof IMovableBranchStructureExtension) {
                ((IMovableBranchStructureExtension)structure).decorateMoveOutRequest(sourceParent, this.key, targetParentBranch, request);
            }
        } else {
            sourceParent = null;
        }
        if (targetParentBranch != null && (structure = targetParentBranch.getBranchPolicy().getStructure(targetParentBranch)) instanceof IMovableBranchStructureExtension) {
            ((IMovableBranchStructureExtension)structure).decorateMoveInRequest(targetParentBranch, this.key, sourceParent, request);
        }
        return request;
    }

    private boolean isAlreadyFree() {
        return this.getSourceTopic().getTopic().getPosition() != null;
    }

    private boolean isAlreadyFloat() {
        return !this.getSourceTopic().getTopic().isAttached();
    }

    private boolean isFreeable() {
        if (!MindMapUI.isFreePositionMoveAllowed()) {
            return false;
        }
        IBranchPart branch = this.getSourceBranch();
        return branch != null && MindMapUtils.isSubBranchesFreeable(branch.getParentBranch());
    }

    private ITopicPart getSourceParentTopic() {
        IPart p;
        IBranchPart sourceBranch = this.getSourceBranch();
        if (sourceBranch != null && (p = sourceBranch.getParent()) instanceof IBranchPart) {
            return ((IBranchPart)p).getTopicPart();
        }
        return null;
    }

    private Point getRelativePosition() {
        Dimension off = this.getCursorPosition().getDifference(this.getStartingPosition());
        return new Point(off.width, off.height);
    }

    public void statusChanged(StatusEvent event) {
        int k = event.key;
        if (this.getStatus().isStatus(1) && (k == 8 || k == 4 || k == 2)) {
            this.updateDisabilities();
            this.updateDummyPosition(this.getCursorPosition());
            this.targetParent = this.updateTargetParent();
            this.updateWithParent(this.targetParent);
        }
    }

    private void updateDisabilities() {
        if (this.isCopyMove()) {
            this.enableFigures();
        } else {
            this.disableFigures();
        }
    }

    public Cursor getCurrentCursor(Point pos, IPart host) {
        if (this.isCopyMove()) {
            return MindMapUI.getImages().getCursor(IMindMapImages.CURSOR_ADD);
        }
        return super.getCurrentCursor(pos, host);
    }
}

