/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.tools;

import org.eclipse.core.runtime.Assert;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Layer;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.xmind.gef.GEF;
import org.xmind.gef.IViewer;
import org.xmind.gef.Request;
import org.xmind.gef.draw2d.SizeableImageFigure;
import org.xmind.gef.draw2d.geometry.Geometry;
import org.xmind.gef.part.IGraphicalEditPart;
import org.xmind.gef.part.IPart;
import org.xmind.gef.service.IBendPointsFeedback;
import org.xmind.gef.service.IFeedback;
import org.xmind.gef.status.IStatusListener;
import org.xmind.gef.status.StatusEvent;
import org.xmind.gef.tool.ISourceTool;
import org.xmind.ui.internal.tools.FeedbackResizeTool;
import org.xmind.ui.mindmap.IImagePart;

public class ImageResizeTool
extends FeedbackResizeTool
implements ISourceTool,
IStatusListener {
    private static final int MIN_IMAGE_WIDTH = 2;
    private SizeableImageFigure feedbackImageFigure;
    private IImagePart source;

    public ImageResizeTool() {
        this.getStatus().addStatusListener((IStatusListener)this);
    }

    public IGraphicalEditPart getSource() {
        return (IGraphicalEditPart)this.source;
    }

    public void setSource(IGraphicalEditPart source) {
        Assert.isTrue((boolean)(source instanceof IImagePart));
        this.source = (IImagePart)source;
    }

    protected Rectangle getSourceArea() {
        return this.getSource().getFigure().getBounds();
    }

    protected IFeedback getSourceFeedback() {
        return (IFeedback)this.getSource().getAdapter(IFeedback.class);
    }

    protected void initFeedback(IBendPointsFeedback feedback) {
        super.initFeedback(feedback);
        Layer layer = this.getTargetViewer().getLayer(GEF.LAYER_PRESENTATION);
        if (layer != null) {
            this.feedbackImageFigure = new SizeableImageFigure(((IImagePart)this.getSource()).getImage());
            this.feedbackImageFigure.setStretched(true);
            this.feedbackImageFigure.setConstrained(false);
            this.feedbackImageFigure.setBounds(this.getSource().getFigure().getBounds());
            layer.add((IFigure)this.feedbackImageFigure);
        }
    }

    protected void updateAreaBounds(Rectangle area, Point cursorPosition) {
        super.updateAreaBounds(area, cursorPosition);
        if (this.feedbackImageFigure != null) {
            this.feedbackImageFigure.setBounds(area);
        }
    }

    protected void removeFeedback(IBendPointsFeedback feedback) {
        if (this.feedbackImageFigure != null) {
            if (this.feedbackImageFigure.getParent() != null) {
                this.feedbackImageFigure.getParent().remove((IFigure)this.feedbackImageFigure);
            }
            this.feedbackImageFigure = null;
        }
        super.removeFeedback(feedback);
    }

    public void finish() {
        super.finish();
        Request request = new Request("resize");
        request.setDomain(this.getDomain());
        request.setViewer((IViewer)this.getTargetViewer());
        request.setPrimaryTarget((IPart)this.getSource());
        request.setParameter("size", (Object)this.getResultArea().getSize());
        this.internalHandleRequest(request);
    }

    protected int constrainWidth(int w) {
        return Math.max(w, 2);
    }

    protected int constrainHeight(int h) {
        return Math.max(h, 2);
    }

    public void statusChanged(StatusEvent event) {
        if (event.key == 8) {
            this.setKeepRatio(event.newValue);
            this.updateArea(this.getResultArea(), this.getCursorPosition(), null);
        }
    }

    protected void keepRatio(Dimension result, int w, int h, int initW, int initH) {
        result.setSize(Geometry.getScaledConstrainedSize2((double)w, (double)h, (double)initW, (double)initH, (double)2.0, (double)2.0, (double)2.147483647E9, (double)2.147483647E9));
    }
}

