/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.protocols;

import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.xmind.core.IIdentifiable;
import org.xmind.core.ISheet;
import org.xmind.core.ITopic;
import org.xmind.core.IWorkbook;
import org.xmind.ui.internal.MindMapMessages;
import org.xmind.ui.mindmap.IProtocol;
import org.xmind.ui.mindmap.MindMapUI;
import org.xmind.ui.util.MindMapUtils;

public class TopicProtocol
implements IProtocol {
    public IAction createOpenHyperlinkAction(final Object context, String uri) {
        final IWorkbook workbook = MindMapUtils.findWorkbook(context);
        if (workbook == null) {
            return null;
        }
        final Object element = TopicProtocol.findElement(uri, workbook);
        ImageDescriptor icon = this.getIcon(element);
        if (icon == null) {
            icon = MindMapUI.getImages().get("unknownfile.gif", true);
        }
        String title = this.getTitle(element);
        String sheetTitle = this.getSheetTitle(element);
        String name = sheetTitle != null ? String.format("%s (%s)", title, sheetTitle) : title;
        Action action = new Action(MindMapMessages.TopicProtocol_GoToTopic_text, icon){

            public void run() {
                if (element != null) {
                    TopicProtocol.navigateTo(context, element, workbook);
                }
            }
        };
        action.setToolTipText(name);
        return action;
    }

    private ImageDescriptor getIcon(Object element) {
        if (element instanceof ITopic) {
            ITopic topic = (ITopic)element;
            return MindMapUI.getImages().getTopicIcon(topic, true);
        }
        return null;
    }

    private String getSheetTitle(Object element) {
        ISheet sheet = this.getSheet(element);
        return sheet == null ? null : sheet.getTitleText();
    }

    private ISheet getSheet(Object element) {
        return MindMapUtils.findSheet(element);
    }

    private String getTitle(Object element) {
        return MindMapUtils.getText(element);
    }

    private static void navigateTo(Object context, Object element, IWorkbook workbook) {
        ISelectionProvider selectionProvider;
        if (context instanceof IAdaptable && (selectionProvider = (ISelectionProvider)((IAdaptable)context).getAdapter(ISelectionProvider.class)) != null) {
            selectionProvider.setSelection((ISelection)new StructuredSelection(element));
            return;
        }
    }

    public boolean isHyperlinkModifiable(Object source, String uri) {
        return true;
    }

    public static String toXmindURL(Object element) {
        return TopicProtocol.toXmindURL(element, null);
    }

    private static String toXmindURL(Object element, IWorkbook workbook) {
        if (element instanceof IIdentifiable) {
            String id = ((IIdentifiable)element).getId();
            String mainPath = TopicProtocol.getMainPath(element, workbook);
            return "xmind:" + mainPath + "#" + id;
        }
        return null;
    }

    private static String getMainPath(Object element, IWorkbook workbook) {
        String file;
        if (workbook != null && (file = workbook.getFile()) != null) {
            return file;
        }
        return "";
    }

    public static Object findElement(String uri, IWorkbook workbook) {
        String path;
        if (uri.startsWith("xmind:") && (path = uri.substring(6)).startsWith("#")) {
            String id = path.substring(1);
            Object element = workbook.getElementById(id);
            if (element instanceof ITopic && !TopicProtocol.isAttach((ITopic)element)) {
                element = null;
            }
            return element;
        }
        return null;
    }

    private static boolean isAttach(ITopic topic) {
        return topic.getPath().getWorkbook() == topic.getOwnedWorkbook();
    }
}

