/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.protocols;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.util.SafeRunnable;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.internal.registry.RegistryReader;
import org.xmind.core.util.HyperlinkUtils;
import org.xmind.ui.browser.BrowserSupport;
import org.xmind.ui.internal.MindMapMessages;
import org.xmind.ui.internal.mindmap.TopicContext;
import org.xmind.ui.internal.protocols.ProtocolDescriptor;
import org.xmind.ui.mindmap.IProtocol;
import org.xmind.ui.mindmap.IProtocolDescriptor;
import org.xmind.ui.mindmap.IProtocolManager;
import org.xmind.ui.mindmap.ITopicPart;
import org.xmind.ui.mindmap.MindMapUI;
import org.xmind.ui.util.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProtocolManager
extends RegistryReader
implements IProtocolManager {
    private static String DEFAULT_BROWSER_ID = "org.xmind.ui.defaultProtocol.browser";
    private IProtocol defaultProtocol = null;
    private List<ProtocolDescriptor> protocolDescriptors = null;
    private Map<String, IProtocol> protocols = null;

    private List<ProtocolDescriptor> getProtocolDescriptors() {
        this.ensureLoaded();
        return this.protocolDescriptors;
    }

    private void ensureLoaded() {
        if (this.protocolDescriptors != null) {
            return;
        }
        this.lazyLoad();
        if (this.protocolDescriptors == null) {
            this.protocolDescriptors = Collections.emptyList();
        }
    }

    private void lazyLoad() {
        this.readRegistry(Platform.getExtensionRegistry(), "org.xmind.ui", "protocols");
    }

    protected boolean readElement(IConfigurationElement element) {
        String name = element.getName();
        if ("protocol".equals(name)) {
            this.readProtocolDescriptor(element);
            return true;
        }
        return false;
    }

    private void readProtocolDescriptor(IConfigurationElement element) {
        try {
            this.registerProtocolDescriptor(new ProtocolDescriptor(element));
        }
        catch (CoreException e) {
            Logger.log(e);
        }
    }

    private void registerProtocolDescriptor(ProtocolDescriptor protocolDescriptor) {
        if (this.protocolDescriptors == null) {
            this.protocolDescriptors = new ArrayList<ProtocolDescriptor>();
        }
        this.protocolDescriptors.add(protocolDescriptor);
    }

    private IProtocol getDefaultProtocol() {
        if (this.defaultProtocol == null) {
            this.defaultProtocol = this.createDefaultProtocol();
        }
        return this.defaultProtocol;
    }

    private IProtocol createDefaultProtocol() {
        return new DefaultProtocol();
    }

    @Override
    public IProtocolDescriptor findProtocolDescriptor(String uri) {
        String name = HyperlinkUtils.getProtocolName((String)uri);
        if (name != null) {
            for (ProtocolDescriptor p : this.getProtocolDescriptors()) {
                if (!p.hasProtocolName(name)) continue;
                return p;
            }
        }
        return null;
    }

    @Override
    public IProtocol findProtocol(String uri) {
        return this.getProtocol(this.findProtocolDescriptor(uri));
    }

    private IProtocol getProtocol(IProtocolDescriptor desc) {
        IProtocol p;
        if (desc != null && (p = this.getCreatedProtocol((ProtocolDescriptor)desc)) != null) {
            return p;
        }
        return this.getDefaultProtocol();
    }

    private IProtocol getCreatedProtocol(IProtocolDescriptor desc) {
        String id;
        IProtocol protocol;
        if (this.protocols == null) {
            this.protocols = new HashMap<String, IProtocol>();
        }
        if ((protocol = this.getExistingProtocol(id = desc.getId())) == null) {
            protocol = this.createProtocol((ProtocolDescriptor)desc);
            this.registerProtocol(id, protocol);
        }
        return protocol;
    }

    private IProtocol registerProtocol(String id, IProtocol protocol) {
        return this.protocols.put(id, protocol);
    }

    private IProtocol getExistingProtocol(String id) {
        return this.protocols.get(id);
    }

    private IProtocol createProtocol(ProtocolDescriptor p) {
        try {
            return p.createProtocol();
        }
        catch (CoreException e) {
            Logger.log(e, "Failed to create protocol: " + p.getId());
            return this.getDefaultProtocol();
        }
    }

    @Override
    public IAction createOpenHyperlinkAction(Object context, String uri) {
        if (context instanceof ITopicPart) {
            context = new TopicContext((ITopicPart)context);
        }
        IProtocolDescriptor desc = this.findProtocolDescriptor(uri);
        return this.adaptAction(this.getProtocol(desc).createOpenHyperlinkAction(context, uri), desc, uri);
    }

    private IAction adaptAction(IAction action, IProtocolDescriptor desc, String uri) {
        if (action == null) {
            return null;
        }
        if (action.getText() == null) {
            String text = desc == null ? MindMapMessages.OpenHyperlink_text : NLS.bind((String)MindMapMessages.ProtocolManager_OpenHyperlink_pattern, (Object)desc.getName());
            action.setText(text);
        }
        if (action.getImageDescriptor() == null) {
            action.setImageDescriptor(MindMapUI.getImages().get("discovery.gif", true));
        }
        if (action.getToolTipText() == null) {
            action.setToolTipText(uri);
        }
        return action;
    }

    @Override
    public boolean isHyperlinkModifiable(Object context, String uri) {
        if (context instanceof ITopicPart) {
            context = new TopicContext((ITopicPart)context);
        }
        return this.findProtocol(uri).isHyperlinkModifiable(context, uri);
    }

    private static class DefaultOpenURLAction
    extends Action {
        private String url;

        public DefaultOpenURLAction(String url) {
            super(MindMapMessages.OpenHyperlink_text, MindMapUI.getImages().get("discovery.gif", true));
            this.url = url;
            this.setDisabledImageDescriptor(MindMapUI.getImages().get("discovery.gif", false));
            this.setToolTipText(url);
        }

        public void run() {
            SafeRunner.run((ISafeRunnable)new SafeRunnable(){

                public void run() throws Exception {
                    BrowserSupport.getInstance().createBrowser(DEFAULT_BROWSER_ID).openURL(DefaultOpenURLAction.this.url);
                }
            });
        }
    }

    private static class DefaultProtocol
    implements IProtocol {
        private DefaultProtocol() {
        }

        public String getProtocolName() {
            return null;
        }

        public IAction createOpenHyperlinkAction(Object source, String uri) {
            return new DefaultOpenURLAction(uri);
        }

        public boolean isHyperlinkModifiable(Object source, String uri) {
            return true;
        }
    }
}

