/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.protocols;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.util.SafeRunnable;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.program.Program;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.PreferencesUtil;
import org.xmind.core.util.FileUtils;
import org.xmind.ui.internal.MarkerImpExpUtils;
import org.xmind.ui.internal.MindMapMessages;
import org.xmind.ui.internal.dialogs.DialogMessages;
import org.xmind.ui.internal.editor.MME;
import org.xmind.ui.mindmap.IProtocol;
import org.xmind.ui.mindmap.MindMapUI;

public class FileProtocol
implements IProtocol {
    public IAction createOpenHyperlinkAction(Object context, String uri) {
        String path = FileProtocol.toFilePath(uri);
        File file = new File(path);
        ImageDescriptor image = MindMapUI.getImages().getFileIcon(path, true);
        if (image == null) {
            image = file.isDirectory() ? MindMapUI.getImages().get("fldr_obj.gif", true) : MindMapUI.getImages().get("unknownfile.gif", true);
        }
        String text = file.isDirectory() ? MindMapMessages.FileProtocol_OpenFolder_text : MindMapMessages.FileProtocol_OpenFile_text;
        OpenFileAction action = new OpenFileAction(FileProtocol.getWindow(context), path);
        action.setText(text);
        action.setImageDescriptor(image);
        action.setToolTipText(path);
        return action;
    }

    /*
     * Unable to fully structure code
     */
    public static String toFilePath(String uri) {
        block3: {
            block4: {
                try {
                    file = new File(new URI(uri));
                    break block3;
                }
                catch (URISyntaxException v0) {
                    if (!uri.startsWith("file:")) break block4;
                    uri = uri.substring(5);
                    ** while (uri.startsWith((String)"/"))
                }
lbl-1000:
                // 1 sources

                {
                    uri = uri.substring(1);
                    continue;
                }
            }
            file = new File(uri);
        }
        return file.getAbsolutePath();
    }

    private static IWorkbenchWindow getWindow(Object context) {
        if (context instanceof IAdaptable) {
            Object adapter = ((IAdaptable)context).getAdapter(IWorkbenchWindow.class);
            if (adapter == null) {
                adapter = ((IAdaptable)context).getAdapter(IEditorPart.class);
                if (adapter == null) {
                    adapter = ((IAdaptable)context).getAdapter(IWorkbenchPart.class);
                }
                if (adapter instanceof IWorkbenchPart) {
                    adapter = ((IWorkbenchPart)adapter).getSite().getWorkbenchWindow();
                }
            }
            if (adapter instanceof IWorkbenchWindow) {
                return (IWorkbenchWindow)adapter;
            }
        }
        if (context instanceof IWorkbenchWindow) {
            return (IWorkbenchWindow)context;
        }
        return PlatformUI.getWorkbench().getActiveWorkbenchWindow();
    }

    public boolean isHyperlinkModifiable(Object source, String uri) {
        return true;
    }

    private static class OpenFileAction
    extends Action {
        private IWorkbenchWindow window;
        private String path;

        public OpenFileAction(IWorkbenchWindow window, String path) {
            this.window = window;
            this.path = path;
        }

        public void run() {
            this.open(this.path);
        }

        private void open(String path) {
            String extension = FileUtils.getExtension((String)path);
            if (".xmt".equalsIgnoreCase(extension) ? this.window != null && this.openTemplate(this.window, path) : (".xmind".equalsIgnoreCase(extension) ? this.window != null && this.openMindMap(this.window, path) : ".xmp".equalsIgnoreCase(extension) && this.importMarkers(path))) {
                return;
            }
            Program.launch((String)path);
        }

        private boolean openTemplate(IWorkbenchWindow window, String path) {
            return this.openMindMap(window, path);
        }

        private boolean openMindMap(final IWorkbenchWindow window, final String path) {
            String errMessage = NLS.bind((String)DialogMessages.FailedToLoadWorkbook_message, (Object)path);
            final boolean[] ret = new boolean[1];
            SafeRunner.run((ISafeRunnable)new SafeRunnable(errMessage){

                public void run() throws Exception {
                    IEditorInput input = MME.createFileEditorInput(path);
                    window.getActivePage().openEditor(input, "org.xmind.ui.MindMapEditor");
                    ret[0] = true;
                }
            });
            return ret[0];
        }

        private boolean importMarkers(String path) {
            try {
                MarkerImpExpUtils.importMarkerPackage(path);
                Display.getCurrent().asyncExec(new Runnable(){

                    public void run() {
                        PreferencesUtil.createPreferenceDialogOn(null, (String)"org.xmind.ui.MarkersPrefPage", null, null).open();
                    }
                });
                return true;
            }
            catch (IOException iOException) {
                return false;
            }
        }
    }
}

