/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.properties;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.draw2d.Layer;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.PopupDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IOpenListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.OpenEvent;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.SWTError;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.osgi.framework.Bundle;
import org.xmind.core.util.FileUtils;
import org.xmind.gef.EditDomain;
import org.xmind.gef.GEF;
import org.xmind.gef.IGraphicalViewer;
import org.xmind.gef.IViewer;
import org.xmind.gef.Request;
import org.xmind.gef.draw2d.IUseTransparency;
import org.xmind.gef.tool.ITool;
import org.xmind.gef.util.Properties;
import org.xmind.ui.commands.CommandMessages;
import org.xmind.ui.gallery.GalleryLayout;
import org.xmind.ui.gallery.GallerySelectTool;
import org.xmind.ui.gallery.GalleryViewer;
import org.xmind.ui.internal.MindMapUIPlugin;
import org.xmind.ui.internal.dialogs.DialogUtils;
import org.xmind.ui.internal.properties.PropertyMessages;
import org.xmind.ui.internal.properties.Utils;
import org.xmind.ui.mindmap.MindMapUI;
import org.xmind.ui.properties.StyledPropertySectionPart;
import org.xmind.ui.util.ImageFormat;
import org.xmind.ui.viewers.MButton;
import org.xmind.ui.viewers.SWTUtils;
import org.xmind.ui.viewers.SliderViewer;

public class WallpaperPropertySectionPart
extends StyledPropertySectionPart {
    private static final Dimension FRAME_IMAGE_SIZE = new Dimension(64, 64);
    private static String WallpapersPath = null;
    private MButton selectWallpaperWidget;
    private IAction removeWallpaperAction;
    private Composite opacityGroup;
    private Text opacityInput;
    private SliderViewer opacityScale;
    private Image selectWallpaperImage;
    private Image opacityImage;
    private Map<Object, Image> wallpaperPreviewImages;
    private Job imageLoader;
    private List<String> allImageFiles;
    private List<String> loadedImageFiles;

    protected void createContent(Composite parent) {
        Composite line1 = new Composite(parent, 0);
        line1.setLayoutData((Object)new GridData(4, 4, true, false));
        GridLayout layout1 = new GridLayout(2, false);
        layout1.marginWidth = 0;
        layout1.marginHeight = 0;
        layout1.horizontalSpacing = 3;
        line1.setLayout((Layout)layout1);
        this.createLineContent1(line1);
        this.opacityGroup = new Composite(parent, 0);
        this.opacityGroup.setLayoutData((Object)new GridData(4, 4, true, false));
        GridLayout layout2 = new GridLayout(4, false);
        layout2.marginWidth = 0;
        layout2.marginHeight = 0;
        layout2.horizontalSpacing = 3;
        this.opacityGroup.setLayout((Layout)layout2);
        this.createLineContent2(this.opacityGroup);
        parent.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                WallpaperPropertySectionPart.this.releaseImages();
            }
        });
    }

    private void createLineContent1(Composite parent) {
        this.selectWallpaperWidget = new MButton(parent, 0);
        this.selectWallpaperWidget.getControl().setLayoutData((Object)new GridData(4, 4, true, false));
        this.selectWallpaperWidget.setImage(this.getSelectWallpaperImage());
        this.selectWallpaperWidget.setText(PropertyMessages.SelectWallpaper_text);
        this.selectWallpaperWidget.getControl().setToolTipText(PropertyMessages.SelectWallpaper_toolTip);
        this.selectWallpaperWidget.addOpenListener(new IOpenListener(){

            public void open(OpenEvent event) {
                WallpaperPropertySectionPart.this.openSelectWallpaperDialog();
            }
        });
        this.removeWallpaperAction = new RemoveWallpaperAction();
        ToolBarManager removeWallpaperBar = new ToolBarManager(0x800000);
        removeWallpaperBar.add(this.removeWallpaperAction);
        removeWallpaperBar.createControl(parent);
        removeWallpaperBar.getControl().setLayoutData((Object)new GridData(3, 2, false, false));
    }

    private void createLineContent2(Composite parent) {
        Label opacityLabel = new Label(parent, 0);
        opacityLabel.setImage(this.getOpacityImage());
        opacityLabel.setLayoutData((Object)new GridData(1, 2, false, false));
        this.opacityInput = new Text(parent, 133124);
        SWTUtils.makeNumeralInput((Control)opacityLabel, (boolean)false, (boolean)false);
        GridData inputData = new GridData(4, 2, false, false);
        inputData.widthHint = 25;
        this.opacityInput.setLayoutData((Object)inputData);
        this.opacityInput.setTextLimit(3);
        this.opacityInput.setToolTipText(PropertyMessages.WallpaperOpacity_toolTip);
        Listener inputEventHandler = new Listener(){

            public void handleEvent(Event event) {
                if (event.type == 14) {
                    int value = WallpaperPropertySectionPart.this.getOpacityValueFromTextWidget();
                    if (value >= 0) {
                        WallpaperPropertySectionPart.this.changeOpacity(value);
                        WallpaperPropertySectionPart.this.selectAllOpacityText(false);
                    }
                } else if (event.type == 1) {
                    if (event.character == '\u001b') {
                        WallpaperPropertySectionPart.this.updateOpacityToWidget();
                    }
                } else if (event.type == 15) {
                    WallpaperPropertySectionPart.this.selectAllOpacityText(false);
                }
            }
        };
        this.opacityInput.addListener(14, inputEventHandler);
        this.opacityInput.addListener(1, inputEventHandler);
        this.opacityInput.addListener(15, inputEventHandler);
        Label percentageLabel = new Label(parent, 0);
        percentageLabel.setText("%");
        percentageLabel.setLayoutData((Object)new GridData(4, 2, false, false));
        this.opacityScale = new SliderViewer(parent, 256);
        this.opacityScale.setLabelProvider((IBaseLabelProvider)new OpacityLabelProvider());
        this.opacityScale.getControl().setLayoutData((Object)new GridData(4, 2, true, false));
        this.opacityScale.getControl().setBackground(parent.getBackground());
        this.opacityScale.addSelectionChangedListener((ISelectionChangedListener)new OpacitySelectionChangedListener());
        this.opacityScale.addPostSelectionChangedListener((ISelectionChangedListener)new OpacityPostSelectionChangedListener());
    }

    private void selectAllOpacityText(final boolean takeFocus) {
        if (this.opacityInput != null && !this.opacityInput.isDisposed()) {
            this.opacityInput.getDisplay().asyncExec(new Runnable(){

                public void run() {
                    if (WallpaperPropertySectionPart.this.opacityInput != null && !WallpaperPropertySectionPart.this.opacityInput.isDisposed()) {
                        if (takeFocus) {
                            WallpaperPropertySectionPart.this.opacityInput.setFocus();
                        }
                        WallpaperPropertySectionPart.this.opacityInput.selectAll();
                    }
                }
            });
        }
    }

    private int getOpacityValueFromTextWidget() {
        if (this.opacityInput != null && !this.opacityInput.isDisposed()) {
            try {
                return Math.min(100, Integer.parseInt(this.opacityInput.getText()));
            }
            catch (NumberFormatException numberFormatException) {}
        }
        return -1;
    }

    private int getOpacityValueFromScaleSelection(ISelection selection) {
        Object o = ((IStructuredSelection)selection).getFirstElement();
        return this.getOpacityValueFromScaleElement(o);
    }

    private int getOpacityValueFromScaleElement(Object o) {
        if (o instanceof Double) {
            double value = (Double)o;
            return (int)Math.round(value * 100.0);
        }
        return -1;
    }

    private Image getSelectWallpaperImage() {
        ImageDescriptor icon;
        if ((this.selectWallpaperImage == null || this.selectWallpaperImage.isDisposed()) && (icon = MindMapUI.getImages().get("insertimage.gif", true)) != null) {
            this.selectWallpaperImage = icon.createImage(false);
        }
        return this.selectWallpaperImage;
    }

    private Image getOpacityImage() {
        ImageDescriptor icon;
        if (this.opacityImage == null && (icon = MindMapUI.getImages().get("icons/prop/opaque.gif")) != null) {
            this.opacityImage = icon.createImage(false);
        }
        return this.opacityImage;
    }

    private Image getWallpaperPreviewImage(Object element) {
        return this.getWallpaperPreviewImage(Display.getCurrent(), element);
    }

    private Image getWallpaperPreviewImage(Display display, Object element) {
        Image image = null;
        if (this.wallpaperPreviewImages != null) {
            image = this.wallpaperPreviewImages.get(element);
        }
        if (image == null) {
            if (element instanceof String) {
                Image filled;
                String path = (String)element;
                try {
                    image = new Image((Device)display, path);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                }
                catch (SWTException sWTException) {
                }
                catch (SWTError sWTError) {}
                if (image != null && (filled = WallpaperPropertySectionPart.createFilledImage(display, image, FRAME_IMAGE_SIZE)) != null) {
                    image.dispose();
                    image = filled;
                }
            }
            if (image != null) {
                this.cacheWallpaperPreviewImage(element, image);
            }
        }
        return image;
    }

    private void cacheWallpaperPreviewImage(Object element, Image image) {
        if (this.wallpaperPreviewImages == null) {
            this.wallpaperPreviewImages = new HashMap<Object, Image>();
        }
        this.wallpaperPreviewImages.put(element, image);
    }

    private void releaseImages() {
        if (this.selectWallpaperImage != null) {
            this.selectWallpaperImage.dispose();
            this.selectWallpaperImage = null;
        }
        if (this.opacityImage != null) {
            this.opacityImage.dispose();
            this.opacityImage = null;
        }
        this.releaseWallpaperPreviewImages();
    }

    private void releaseWallpaperPreviewImages() {
        if (this.wallpaperPreviewImages != null) {
            for (Image image : this.wallpaperPreviewImages.values()) {
                image.dispose();
            }
            this.wallpaperPreviewImages = null;
        }
    }

    public void setFocus() {
        if (this.selectWallpaperWidget != null && !this.selectWallpaperWidget.getControl().isDisposed()) {
            this.selectWallpaperWidget.getControl().setFocus();
        }
    }

    public void dispose() {
        super.dispose();
        this.selectWallpaperWidget = null;
        this.removeWallpaperAction = null;
        this.opacityGroup = null;
        this.opacityInput = null;
        this.opacityScale = null;
    }

    protected void doRefresh() {
        boolean hasWallpaper;
        String value = this.getStyleValue("background", null);
        boolean bl = hasWallpaper = value != null;
        if (this.removeWallpaperAction != null) {
            this.removeWallpaperAction.setEnabled(hasWallpaper);
        }
        if (this.opacityGroup != null && !this.opacityGroup.isDisposed()) {
            Utils.setAllEnabled((Control)this.opacityGroup, hasWallpaper);
        }
        this.updateOpacityToWidget();
    }

    private void updateOpacityToWidget() {
        String value = this.getStyleValue("svg:opacity", null);
        double doubleValue = this.parseOpacityValue(value);
        doubleValue = Math.max(0.0, Math.min(1.0, doubleValue));
        if (this.opacityInput != null && !this.opacityInput.isDisposed()) {
            this.opacityInput.setText(String.valueOf((int)Math.round(doubleValue * 100.0)));
        }
        if (this.opacityScale != null && !this.opacityScale.getControl().isDisposed()) {
            this.opacityScale.setSelection((ISelection)new StructuredSelection((Object)doubleValue));
        }
    }

    private double parseOpacityValue(String value) {
        if (value != null) {
            try {
                return Double.parseDouble(value);
            }
            catch (NumberFormatException numberFormatException) {}
        }
        return 1.0;
    }

    private void openSelectWallpaperDialog() {
        if (this.selectWallpaperWidget != null && this.selectWallpaperWidget.getControl() != null && !this.selectWallpaperWidget.getControl().isDisposed()) {
            Control handle = this.selectWallpaperWidget.getControl();
            new SelectWallpaperDialog(handle.getShell(), handle).open();
        }
    }

    private void openLocalImageFileDialog() {
        if (this.selectWallpaperWidget == null || this.selectWallpaperWidget.getControl() == null || this.selectWallpaperWidget.getControl().isDisposed()) {
            return;
        }
        FileDialog dialog = new FileDialog(this.selectWallpaperWidget.getControl().getShell(), 4100);
        DialogUtils.makeDefaultImageSelectorDialog(dialog, true);
        dialog.setFilterPath(WallpaperPropertySectionPart.getWallpapersPath());
        dialog.setText(PropertyMessages.WallpaperDialog_title);
        String path = dialog.open();
        if (path != null) {
            this.changeWallpaper(path);
        }
    }

    private void changeWallpaper(String path) {
        Request request = this.createStyleRequest(CommandMessages.Command_ModifyWallpaper);
        this.addStyle(request, "background", path);
        this.sendRequest(request);
    }

    private void removeWallpaper() {
        Request request = this.createStyleRequest(CommandMessages.Command_ModifyWallpaper);
        this.addStyle(request, "background", null);
        this.sendRequest(request);
    }

    private void changeOpacity(int opacityValue) {
        Request request = this.createStyleRequest(CommandMessages.Command_ModifyWallpaperOpacity);
        String value = String.valueOf((double)opacityValue * 1.0 / 100.0);
        this.addStyle(request, "svg:opacity", value);
        this.sendRequest(request);
    }

    private void previewOpacity(int value) {
        Layer layer;
        IGraphicalViewer viewer = this.getActiveViewer();
        if (viewer != null && (layer = viewer.getLayer(GEF.LAYER_BACKGROUND)) != null && layer instanceof IUseTransparency) {
            int alpha = value * 255 / 100;
            ((IUseTransparency)layer).setSubAlpha(alpha);
        }
    }

    private static String getWallpapersPath() {
        if (WallpapersPath == null) {
            WallpapersPath = WallpaperPropertySectionPart.createWallpapersPath();
        }
        return WallpapersPath;
    }

    private static String createWallpapersPath() {
        URL url = FileLocator.find((Bundle)Platform.getBundle((String)"org.xmind.ui"), (IPath)new Path("wallpaper"), null);
        try {
            url = FileLocator.toFileURL((URL)url);
        }
        catch (IOException iOException) {}
        String path = url.getFile();
        if ("".equals(path)) {
            path = new File(System.getProperty("user.home"), "Pictures").getAbsolutePath();
        }
        return path;
    }

    private static Image createFilledImage(Display display, Image src, Dimension size) {
        int y;
        int x;
        int height = size.height;
        int width = size.width;
        ImageData srcData = src.getImageData();
        int srcWidth = srcData.width;
        int srcHeight = srcData.height;
        if (srcWidth == width && srcHeight == height) {
            return null;
        }
        ImageData destData = new ImageData(width, height, srcData.depth, srcData.palette);
        destData.type = srcData.type;
        destData.transparentPixel = srcData.transparentPixel;
        destData.alpha = srcData.alpha;
        if (srcData.transparentPixel != -1) {
            x = 0;
            while (x < width) {
                y = 0;
                while (y < height) {
                    destData.setPixel(x, y, srcData.transparentPixel);
                    ++y;
                }
                ++x;
            }
        } else {
            x = 0;
            while (x < width) {
                y = 0;
                while (y < height) {
                    destData.setAlpha(x, y, 0);
                    ++y;
                }
                ++x;
            }
        }
        int[] pixels = new int[srcWidth];
        byte[] alphas = null;
        int startX = 0;
        while (startX < width) {
            int length = Math.min(srcWidth, width - startX);
            if (length > 0) {
                int startY = 0;
                while (startY < height) {
                    int y2 = 0;
                    while (y2 < srcHeight && startY + y2 < height) {
                        int i;
                        srcData.getPixels(0, y2, srcWidth, pixels, 0);
                        destData.setPixels(startX, startY + y2, length, pixels, 0);
                        if (srcData.alpha == -1 && srcData.alphaData != null) {
                            if (alphas == null) {
                                alphas = new byte[srcWidth];
                            }
                            srcData.getAlphas(0, y2, srcWidth, alphas, 0);
                        } else if (srcData.alpha != -1 && alphas == null) {
                            alphas = new byte[srcWidth];
                            i = 0;
                            while (i < alphas.length) {
                                alphas[i] = (byte)srcData.alpha;
                                ++i;
                            }
                        } else if (alphas == null) {
                            alphas = new byte[srcWidth];
                            i = 0;
                            while (i < alphas.length) {
                                alphas[i] = -1;
                                ++i;
                            }
                        }
                        destData.setAlphas(startX, startY + y2, length, alphas, 0);
                        ++y2;
                    }
                    startY += srcHeight;
                }
            }
            startX += srcWidth;
        }
        Image image = new Image((Device)display, destData);
        return image;
    }

    private class OpacityLabelProvider
    extends LabelProvider {
        private OpacityLabelProvider() {
        }

        public String getText(Object element) {
            int value = WallpaperPropertySectionPart.this.getOpacityValueFromScaleElement(element);
            if (value >= 0) {
                return NLS.bind((String)PropertyMessages.WallpaperOpacity_pattern, (Object)value);
            }
            return super.getText(element);
        }
    }

    private class OpacityPostSelectionChangedListener
    implements ISelectionChangedListener {
        private OpacityPostSelectionChangedListener() {
        }

        public void selectionChanged(SelectionChangedEvent event) {
            int value = WallpaperPropertySectionPart.this.getOpacityValueFromScaleSelection(event.getSelection());
            if (value >= 0) {
                WallpaperPropertySectionPart.this.changeOpacity(value);
                WallpaperPropertySectionPart.this.selectAllOpacityText(true);
            }
        }
    }

    private class OpacitySelectionChangedListener
    implements ISelectionChangedListener {
        private OpacitySelectionChangedListener() {
        }

        public void selectionChanged(SelectionChangedEvent event) {
            int value = WallpaperPropertySectionPart.this.getOpacityValueFromScaleSelection(event.getSelection());
            if (value >= 0) {
                WallpaperPropertySectionPart.this.opacityInput.setText(String.valueOf(value));
                WallpaperPropertySectionPart.this.previewOpacity(value);
            }
        }
    }

    private class RemoveWallpaperAction
    extends Action {
        public RemoveWallpaperAction() {
            super(null, 1);
            this.setImageDescriptor(MindMapUI.getImages().get("trash.gif", true));
            this.setDisabledImageDescriptor(MindMapUI.getImages().get("trash.gif", false));
            this.setToolTipText(PropertyMessages.RemoveWallpaper_toolTip);
        }

        public void run() {
            WallpaperPropertySectionPart.this.removeWallpaper();
        }
    }

    private class SelectWallpaperDialog
    extends PopupDialog
    implements IOpenListener {
        private Control handle;
        private GalleryViewer viewer;

        public SelectWallpaperDialog(Shell parent, Control handle) {
            super(parent, 16, true, true, true, false, false, null, null);
            this.handle = handle;
        }

        protected Control createDialogArea(Composite parent) {
            Composite composite = (Composite)super.createDialogArea(parent);
            this.viewer = new GalleryViewer();
            Properties properties = this.viewer.getProperties();
            properties.set("org.xmind.ui.gallery.horizontal", (Object)Boolean.TRUE);
            properties.set("org.xmind.ui.gallery.wrap", (Object)Boolean.TRUE);
            properties.set("org.xmind.ui.gallery.flatFrames", (Object)Boolean.TRUE);
            properties.set("constrained", (Object)Boolean.TRUE);
            properties.set("org.xmind.ui.gallery.layout", (Object)new GalleryLayout(1, 3, 1, 1, new Insets(5)));
            properties.set("org.xmind.ui.gallery.frameContentSize", (Object)new Dimension(48, 48));
            properties.set("org.xmind.ui.gallery.titlePlacement", (Object)GalleryViewer.TITLE_BOTTOM);
            properties.set("org.xmind.ui.gallery.singleClickToOpen", (Object)Boolean.TRUE);
            properties.set("org.xmind.ui.gallery.hideTitle", (Object)Boolean.TRUE);
            properties.set("org.xmind.ui.gallery.solidFrames", (Object)Boolean.FALSE);
            this.viewer.setLabelProvider((IBaseLabelProvider)new WallpaperLabelProvider());
            this.viewer.addOpenListener((IOpenListener)this);
            EditDomain editDomain = new EditDomain();
            editDomain.installTool("select tool", (ITool)new GallerySelectTool());
            editDomain.setViewer((IViewer)this.viewer);
            this.viewer.createControl(composite);
            GridData galleryData = new GridData(4, 4, true, true);
            galleryData.widthHint = 360;
            galleryData.heightHint = 300;
            this.viewer.getControl().setLayoutData((Object)galleryData);
            final Display display = parent.getDisplay();
            this.viewer.getControl().setBackground(display.getSystemColor(25));
            if (WallpaperPropertySectionPart.this.allImageFiles != null && WallpaperPropertySectionPart.this.loadedImageFiles != null && WallpaperPropertySectionPart.this.loadedImageFiles.containsAll(WallpaperPropertySectionPart.this.allImageFiles)) {
                this.viewer.setInput((Object)WallpaperPropertySectionPart.this.loadedImageFiles.toArray());
            } else {
                this.viewer.setInput((Object)new Object[0]);
                display.asyncExec(new Runnable(){

                    public void run() {
                        if (SelectWallpaperDialog.this.viewer.getControl() != null && !SelectWallpaperDialog.this.viewer.getControl().isDisposed()) {
                            SelectWallpaperDialog.this.startLoadingImages(display);
                        }
                    }
                });
            }
            Composite bottom = new Composite(composite, 0);
            GridLayout bottomLayout = new GridLayout();
            bottomLayout.marginWidth = 0;
            bottomLayout.marginHeight = 0;
            bottom.setLayout((Layout)bottomLayout);
            bottom.setLayoutData((Object)new GridData(4, 4, true, false));
            Button chooseFromLocalButton = new Button(bottom, 8);
            chooseFromLocalButton.setText(PropertyMessages.LocalImage_text);
            chooseFromLocalButton.setLayoutData((Object)new GridData(2, 2, true, false));
            chooseFromLocalButton.addListener(13, new Listener(){

                public void handleEvent(Event event) {
                    SelectWallpaperDialog.this.close();
                    WallpaperPropertySectionPart.this.openLocalImageFileDialog();
                }
            });
            return composite;
        }

        private void startLoadingImages(final Display display) {
            if (WallpaperPropertySectionPart.this.imageLoader != null) {
                WallpaperPropertySectionPart.this.imageLoader.cancel();
                WallpaperPropertySectionPart.this.imageLoader = null;
            }
            WallpaperPropertySectionPart.this.imageLoader = new Job(PropertyMessages.LoadWallpapers_jobName){
                private Runnable refreshJob;
                {
                    super($anonymous0);
                    this.refreshJob = null;
                }

                protected IStatus run(IProgressMonitor monitor) {
                    if (WallpaperPropertySectionPart.this.allImageFiles == null) {
                        this.collectImageFiles(WallpaperPropertySectionPart.getWallpapersPath());
                        if (WallpaperPropertySectionPart.this.allImageFiles == null) {
                            WallpaperPropertySectionPart.this.allImageFiles = Collections.emptyList();
                        }
                    }
                    if (WallpaperPropertySectionPart.this.allImageFiles.isEmpty()) {
                        if (WallpaperPropertySectionPart.this.loadedImageFiles == null || !WallpaperPropertySectionPart.this.loadedImageFiles.isEmpty()) {
                            WallpaperPropertySectionPart.this.loadedImageFiles = Collections.emptyList();
                        }
                        this.refreshViewer(display);
                    } else if (WallpaperPropertySectionPart.this.loadedImageFiles != null && WallpaperPropertySectionPart.this.loadedImageFiles.containsAll(WallpaperPropertySectionPart.this.allImageFiles)) {
                        this.refreshViewer(display);
                    } else {
                        monitor.beginTask(null, WallpaperPropertySectionPart.this.allImageFiles.size());
                        if (WallpaperPropertySectionPart.this.loadedImageFiles == null) {
                            WallpaperPropertySectionPart.this.loadedImageFiles = new ArrayList(WallpaperPropertySectionPart.this.allImageFiles.size());
                        }
                        long lastRefresh = System.currentTimeMillis();
                        Object[] objectArray = WallpaperPropertySectionPart.this.allImageFiles.toArray();
                        int n = objectArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            Object o = objectArray[n2];
                            if (monitor.isCanceled()) break;
                            if (!WallpaperPropertySectionPart.this.loadedImageFiles.contains(o)) {
                                String path = (String)o;
                                monitor.subTask(new File(path).getName());
                                Image image = WallpaperPropertySectionPart.this.getWallpaperPreviewImage(display, path);
                                if (image != null) {
                                    WallpaperPropertySectionPart.this.loadedImageFiles.add(path);
                                } else {
                                    WallpaperPropertySectionPart.this.allImageFiles.remove(path);
                                }
                            }
                            monitor.worked(1);
                            if (System.currentTimeMillis() - lastRefresh > 50L) {
                                this.refreshViewer(display);
                                lastRefresh = System.currentTimeMillis();
                            }
                            try {
                                Thread.sleep(1L);
                            }
                            catch (InterruptedException interruptedException) {
                                break;
                            }
                            ++n2;
                        }
                    }
                    if (!monitor.isCanceled()) {
                        monitor.done();
                    }
                    WallpaperPropertySectionPart.this.imageLoader = null;
                    this.refreshViewer(display);
                    return new Status(0, "org.xmind.ui.mindmap", 0, "Wallpaper images loaded.", null);
                }

                private void refreshViewer(Display display2) {
                    if (this.refreshJob != null) {
                        return;
                    }
                    this.refreshJob = new Runnable(){

                        public void run() {
                            if (SelectWallpaperDialog.this.viewer != null && SelectWallpaperDialog.this.viewer.getControl() != null && !SelectWallpaperDialog.this.viewer.getControl().isDisposed() && WallpaperPropertySectionPart.this.loadedImageFiles != null) {
                                SelectWallpaperDialog.this.viewer.setInput((Object)WallpaperPropertySectionPart.this.loadedImageFiles.toArray());
                                SelectWallpaperDialog.this.viewer.getControl().getParent().layout();
                            }
                            refreshJob = null;
                        }
                    };
                    display2.asyncExec(this.refreshJob);
                }

                private void collectImageFiles(String path) {
                    String ext;
                    ImageFormat format;
                    File file = new File(path);
                    if (file.isDirectory() && path.equals(WallpaperPropertySectionPart.getWallpapersPath())) {
                        String[] stringArray = file.list();
                        int n = stringArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            String name = stringArray[n2];
                            this.collectImageFiles(new File(file, name).getAbsolutePath());
                            ++n2;
                        }
                    } else if (file.isFile() && (format = ImageFormat.findByExtension((String)(ext = FileUtils.getExtension((String)path)), null)) != null) {
                        if (WallpaperPropertySectionPart.this.allImageFiles == null) {
                            WallpaperPropertySectionPart.this.allImageFiles = new ArrayList();
                        }
                        WallpaperPropertySectionPart.this.allImageFiles.add(path);
                    }
                }
            };
            WallpaperPropertySectionPart.this.imageLoader.schedule();
        }

        protected void configureShell(Shell shell) {
            super.configureShell(shell);
            shell.addListener(27, new Listener(){

                public void handleEvent(Event event) {
                    event.display.asyncExec(new Runnable(){

                        public void run() {
                            SelectWallpaperDialog.this.close();
                        }
                    });
                }
            });
            shell.addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent e) {
                    if (WallpaperPropertySectionPart.this.imageLoader != null) {
                        WallpaperPropertySectionPart.this.imageLoader.cancel();
                        WallpaperPropertySectionPart.this.imageLoader = null;
                    }
                }
            });
        }

        protected List getBackgroundColorExclusions() {
            List list = super.getBackgroundColorExclusions();
            if (this.viewer != null) {
                list.add(this.viewer.getControl());
            }
            return list;
        }

        protected Point getInitialLocation(Point initialSize) {
            if (this.handle != null && !this.handle.isDisposed()) {
                Point loc = this.handle.toDisplay(this.handle.getLocation());
                return new Point(loc.x, loc.y + this.handle.getBounds().height);
            }
            return super.getInitialLocation(initialSize);
        }

        protected IDialogSettings getDialogSettings() {
            return MindMapUIPlugin.getDefault().getDialogSettings("org.xmind.ui.popupDialog");
        }

        public void open(OpenEvent event) {
            Object o = ((IStructuredSelection)event.getSelection()).getFirstElement();
            if (o instanceof String) {
                String path = (String)o;
                this.close();
                WallpaperPropertySectionPart.this.changeWallpaper(path);
            }
        }

        private class WallpaperLabelProvider
        extends LabelProvider {
            private WallpaperLabelProvider() {
            }

            public Image getImage(Object element) {
                return WallpaperPropertySectionPart.this.getWallpaperPreviewImage(element);
            }
        }
    }
}

