/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.properties;

import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.xmind.gef.Request;
import org.xmind.ui.commands.CommandMessages;
import org.xmind.ui.internal.properties.PropertyMessages;
import org.xmind.ui.properties.StyledPropertySectionPart;

public class SheetAdvancedStylePropertySectionPart
extends StyledPropertySectionPart {
    private Button multiLineColorsCheck;
    private Button taperedLinesCheck;

    protected void createContent(Composite parent) {
        this.multiLineColorsCheck = new Button(parent, 32);
        this.multiLineColorsCheck.setText(PropertyMessages.MultiLineColors_text);
        this.multiLineColorsCheck.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                SheetAdvancedStylePropertySectionPart.this.changeRainbowColor();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.taperedLinesCheck = new Button(parent, 32);
        this.taperedLinesCheck.setText(PropertyMessages.TaperedLines_text);
        this.taperedLinesCheck.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                SheetAdvancedStylePropertySectionPart.this.changeTaperedLines();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
    }

    private void changeRainbowColor() {
        Request request = this.createStyleRequest(CommandMessages.Command_ToggleMultiLineColors);
        if (this.multiLineColorsCheck.getSelection()) {
            this.addStyle(request, "multi-line-colors", "#ac6060 #acac60 #60ac60 #60acac #6060ac #ac60ac");
        } else {
            this.addStyle(request, "multi-line-colors", null);
        }
        this.sendRequest(request);
    }

    private void changeTaperedLines() {
        Request request = this.createStyleRequest(CommandMessages.Command_ToggleTaperedLines);
        if (this.taperedLinesCheck.getSelection()) {
            this.addStyle(request, "line-tapered", "tapered");
        } else {
            this.addStyle(request, "line-tapered", null);
        }
        this.sendRequest(request);
    }

    protected void doRefresh() {
        String value;
        if (this.multiLineColorsCheck != null && !this.multiLineColorsCheck.isDisposed()) {
            value = this.getStyleValue("multi-line-colors", null);
            this.multiLineColorsCheck.setSelection(value != null);
        }
        if (this.taperedLinesCheck != null && !this.taperedLinesCheck.isDisposed()) {
            value = this.getStyleValue("line-tapered", null);
            this.taperedLinesCheck.setSelection(value != null);
        }
    }

    public void dispose() {
        super.dispose();
        this.multiLineColorsCheck = null;
        this.taperedLinesCheck = null;
    }

    public void setFocus() {
        this.multiLineColorsCheck.setFocus();
    }
}

