/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.properties;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.ui.internal.registry.RegistryReader;
import org.xmind.gef.ui.properties.IPropertySectionPart;
import org.xmind.ui.internal.properties.PropertySectionFactory;
import org.xmind.ui.util.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PropertySectionContributorManager
extends RegistryReader {
    private static PropertySectionContributorManager instance = null;
    private static final List<String> NO_SECTION_IDS = Collections.emptyList();
    private Map<String, PropertySectionFactory> sectionFactories = null;
    private List<String> sectionIds = null;

    private PropertySectionContributorManager() {
    }

    protected boolean readElement(IConfigurationElement element) {
        String name = element.getName();
        if ("section".equals(name)) {
            this.readSection(element);
            return true;
        }
        return "enablement".equals(name);
    }

    private void readSection(IConfigurationElement element) {
        PropertySectionFactory sectionFactory;
        try {
            sectionFactory = new PropertySectionFactory(element);
        }
        catch (CoreException e) {
            Logger.log(e, "Failed to create PropertySection: " + element.toString());
            return;
        }
        String sectionId = sectionFactory.getId();
        if (this.sectionFactories == null) {
            this.sectionFactories = new HashMap<String, PropertySectionFactory>();
        }
        this.sectionFactories.put(sectionId, sectionFactory);
        if (this.sectionIds == null) {
            this.sectionIds = new ArrayList<String>();
        }
        this.sectionIds.add(sectionId);
    }

    private void ensureLoaded() {
        if (this.sectionFactories != null) {
            return;
        }
        this.lazyLoad();
        if (this.sectionFactories == null) {
            this.sectionFactories = Collections.emptyMap();
        }
        if (this.sectionIds == null) {
            this.sectionIds = Collections.emptyList();
        }
    }

    private void lazyLoad() {
        this.readRegistry(Platform.getExtensionRegistry(), "org.xmind.ui", "propertySections");
    }

    public List<String> getApplicableSectionIds(Object[] objects) {
        if (objects == null || objects.length == 0) {
            return NO_SECTION_IDS;
        }
        this.ensureLoaded();
        ArrayList<String> ids = new ArrayList<String>(this.sectionIds);
        Iterator it = ids.iterator();
        while (it.hasNext()) {
            PropertySectionFactory factory = this.sectionFactories.get(it.next());
            if (factory != null && factory.isEnabledOn(objects)) continue;
            it.remove();
        }
        return ids;
    }

    public IPropertySectionPart createSection(String id) {
        if (id == null || "".equals(id)) {
            return null;
        }
        this.ensureLoaded();
        PropertySectionFactory factory = this.sectionFactories.get(id);
        return factory == null ? null : factory.createSection();
    }

    public static PropertySectionContributorManager getInstance() {
        if (instance == null) {
            instance = new PropertySectionContributorManager();
        }
        return instance;
    }
}

