/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.properties;

import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.xmind.gef.Request;
import org.xmind.ui.commands.CommandMessages;
import org.xmind.ui.internal.properties.LinePattern;
import org.xmind.ui.internal.properties.LinePatternLabelProvider;
import org.xmind.ui.internal.properties.LinePropertySectionPartBase;
import org.xmind.ui.internal.properties.PropertyMessages;
import org.xmind.ui.viewers.MComboViewer;

public class LinePropertySectionPart
extends LinePropertySectionPartBase {
    private MComboViewer linePatternViewer;

    protected void refreshWithShapeId(String lineShapeId) {
        if (this.linePatternViewer != null && !this.linePatternViewer.getControl().isDisposed()) {
            String lineWidth = this.getStyleValue("line-pattern", lineShapeId);
            LinePattern element = LinePattern.findByValue(lineWidth);
            if (element == null) {
                element = LinePattern.Solid;
            }
            this.linePatternViewer.setSelection((ISelection)new StructuredSelection((Object)element));
        }
        super.refreshWithShapeId(lineShapeId);
    }

    protected void createContent(Composite parent) {
        Composite line1 = new Composite(parent, 0);
        line1.setLayoutData((Object)new GridData(4, 4, true, false));
        GridLayout layout = new GridLayout(2, false);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.horizontalSpacing = 3;
        layout.verticalSpacing = 3;
        line1.setLayout((Layout)layout);
        this.createLineContent1(line1);
        super.createContent(parent);
    }

    private void createLineContent1(Composite parent) {
        this.linePatternViewer = new MComboViewer(parent, 0);
        this.linePatternViewer.getControl().setLayoutData((Object)new GridData(4, 4, true, false));
        this.linePatternViewer.getControl().setToolTipText(PropertyMessages.LinePattern_toolTip);
        this.linePatternViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.linePatternViewer.setLabelProvider((IBaseLabelProvider)new LinePatternLabelProvider());
        this.linePatternViewer.setInput((Object)LinePattern.values());
        this.linePatternViewer.addSelectionChangedListener((ISelectionChangedListener)new LinePatternSelectionChangedListener());
    }

    public void setFocus() {
        if (this.linePatternViewer != null && !this.linePatternViewer.getControl().isDisposed()) {
            this.linePatternViewer.getControl().setFocus();
        } else {
            super.setFocus();
        }
    }

    public void dispose() {
        super.dispose();
        this.linePatternViewer = null;
    }

    private void changeLinePattern(LinePattern linePattern) {
        Request request = this.createStyleRequest(CommandMessages.Command_ModifyLineShape);
        String value = linePattern == null ? null : linePattern.getValue();
        this.addStyle(request, "line-pattern", value);
        this.sendRequest(request);
    }

    private class LinePatternSelectionChangedListener
    implements ISelectionChangedListener {
        private LinePatternSelectionChangedListener() {
        }

        public void selectionChanged(SelectionChangedEvent event) {
            if (LinePropertySectionPart.this.isRefreshing()) {
                return;
            }
            Object o = ((IStructuredSelection)event.getSelection()).getFirstElement();
            if (o instanceof LinePattern) {
                LinePropertySectionPart.this.changeLinePattern((LinePattern)((Object)o));
            }
        }
    }
}

