/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.properties;

import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.xmind.core.ILegend;
import org.xmind.core.ISheet;
import org.xmind.core.event.ICoreEventRegister;
import org.xmind.core.event.ICoreEventSource;
import org.xmind.gef.Request;
import org.xmind.ui.internal.properties.PropertyMessages;
import org.xmind.ui.properties.MindMapPropertySectionPartBase;

public class LegendPropertySectionPart
extends MindMapPropertySectionPartBase {
    private Button visibilityCheck;

    protected void createContent(Composite parent) {
        this.visibilityCheck = new Button(parent, 32);
        this.visibilityCheck.setLayoutData((Object)new GridData(4, 2, true, false));
        this.visibilityCheck.setText(PropertyMessages.ShowLegend_text);
        this.visibilityCheck.setToolTipText(PropertyMessages.ShowLegend_toolTip);
        this.visibilityCheck.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                LegendPropertySectionPart.this.changeLegendVisibility(LegendPropertySectionPart.this.visibilityCheck.getSelection());
            }
        });
    }

    protected void registerEventListener(ICoreEventSource source, ICoreEventRegister register) {
        ILegend legend;
        if (source instanceof ISheet && (legend = ((ISheet)source).getLegend()) instanceof ICoreEventSource) {
            source = (ICoreEventSource)legend;
            register.setNextSource(source);
            register.register("visibility");
        }
    }

    protected void doRefresh() {
        if (this.visibilityCheck != null && !this.visibilityCheck.isDisposed()) {
            this.visibilityCheck.setSelection(this.isLegendVisible());
        }
    }

    private boolean isLegendVisible() {
        Object[] objectArray = this.getSelectedElements();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            ILegend legend;
            Object o = objectArray[n2];
            if (o instanceof ISheet && !(legend = ((ISheet)o).getLegend()).isVisible()) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    public void setFocus() {
        if (this.visibilityCheck != null && !this.visibilityCheck.isDisposed()) {
            this.visibilityCheck.setFocus();
        }
    }

    public void dispose() {
        super.dispose();
        this.visibilityCheck = null;
    }

    protected void changeLegendVisibility(boolean visible) {
        Request request = new Request(visible ? "show legend" : "hide legend");
        this.sendRequest(this.fillTargets(request));
    }
}

