/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.properties;

import java.util.List;
import org.eclipse.draw2d.IFigure;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IOpenListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.OpenEvent;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolBar;
import org.xmind.gef.IGraphicalViewer;
import org.xmind.gef.Request;
import org.xmind.gef.draw2d.IDecoratedFigure;
import org.xmind.gef.draw2d.decoration.IDecoration;
import org.xmind.gef.draw2d.decoration.IShapeDecoration;
import org.xmind.gef.part.IGraphicalPart;
import org.xmind.gef.part.IPart;
import org.xmind.ui.color.ColorPicker;
import org.xmind.ui.color.IColorSelection;
import org.xmind.ui.color.PaletteContents;
import org.xmind.ui.commands.CommandMessages;
import org.xmind.ui.decorations.IDecorationDescriptor;
import org.xmind.ui.internal.properties.DecorationLabelProvider;
import org.xmind.ui.internal.properties.PropertyMessages;
import org.xmind.ui.mindmap.MindMapUI;
import org.xmind.ui.properties.StyledPropertySectionPart;
import org.xmind.ui.viewers.MComboViewer;
import org.xmind.ui.viewers.SWTUtils;
import org.xmind.ui.viewers.SliderViewer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BoundaryShapePropertySectionPart
extends StyledPropertySectionPart {
    private static List<IDecorationDescriptor> BoundaryShapes;
    private MComboViewer shapeViewer;
    private ColorPicker fillColorPicker;
    private Text opacityInput;
    private SliderViewer opacityScale;
    private Image opacityImage;

    @Override
    protected void createContent(Composite parent) {
        Composite line1 = new Composite(parent, 0);
        line1.setLayoutData((Object)new GridData(4, 4, true, false));
        GridLayout layout1 = new GridLayout(2, false);
        layout1.marginWidth = 0;
        layout1.marginHeight = 0;
        layout1.horizontalSpacing = 3;
        layout1.verticalSpacing = 3;
        line1.setLayout((Layout)layout1);
        this.createLineContent1(line1);
        Composite line2 = new Composite(parent, 0);
        line2.setLayoutData((Object)new GridData(4, 4, true, false));
        GridLayout layout2 = new GridLayout(4, false);
        layout2.marginWidth = 0;
        layout2.marginHeight = 0;
        layout2.horizontalSpacing = 3;
        layout2.verticalSpacing = 3;
        line2.setLayout((Layout)layout2);
        this.createLineContent2(line2);
    }

    private void createLineContent1(Composite parent) {
        this.shapeViewer = new MComboViewer(parent, 0);
        this.shapeViewer.getControl().setLayoutData((Object)new GridData(4, 4, true, false));
        this.shapeViewer.getControl().setToolTipText(PropertyMessages.BoundaryShape_toolTip);
        this.shapeViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.shapeViewer.setLabelProvider((IBaseLabelProvider)new DecorationLabelProvider());
        this.shapeViewer.setInput(BoundaryShapePropertySectionPart.getBoundaryShapes());
        this.shapeViewer.addSelectionChangedListener((ISelectionChangedListener)new ShapeSelectionChangedListener());
        this.fillColorPicker = new ColorPicker(7, PaletteContents.getDefault());
        this.fillColorPicker.getAction().setToolTipText(PropertyMessages.BoundaryFillColor_toolTip);
        this.fillColorPicker.addOpenListener((IOpenListener)new FillColorOpenListener());
        ToolBarManager colorBar = new ToolBarManager(0x800000);
        colorBar.add((IContributionItem)this.fillColorPicker);
        ToolBar barControl = colorBar.createControl(parent);
        barControl.setLayoutData((Object)new GridData(3, 2, false, false));
    }

    private void createLineContent2(Composite parent) {
        Label opacityLabel = new Label(parent, 0);
        opacityLabel.setImage(this.getOpacityImage());
        opacityLabel.setLayoutData((Object)new GridData(1, 2, false, false));
        opacityLabel.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                BoundaryShapePropertySectionPart.this.releaseImages();
            }
        });
        this.opacityInput = new Text(parent, 133124);
        SWTUtils.makeNumeralInput((Control)opacityLabel, (boolean)false, (boolean)false);
        GridData inputData = new GridData(4, 2, false, false);
        inputData.widthHint = 25;
        this.opacityInput.setLayoutData((Object)inputData);
        this.opacityInput.setTextLimit(3);
        this.opacityInput.setToolTipText(PropertyMessages.BoundaryOpacity_toolTip);
        Listener inputEventHandler = new Listener(){

            public void handleEvent(Event event) {
                if (event.type == 14) {
                    int value = BoundaryShapePropertySectionPart.this.getOpacityValueFromTextWidget();
                    if (value >= 0) {
                        BoundaryShapePropertySectionPart.this.changeOpacity(value);
                        BoundaryShapePropertySectionPart.this.selectAllOpacityText(false);
                    }
                } else if (event.type == 1) {
                    if (event.character == '\u001b') {
                        BoundaryShapePropertySectionPart.this.updateOpacityToWidget();
                    }
                } else if (event.type == 15) {
                    BoundaryShapePropertySectionPart.this.selectAllOpacityText(false);
                }
            }
        };
        this.opacityInput.addListener(14, inputEventHandler);
        this.opacityInput.addListener(1, inputEventHandler);
        this.opacityInput.addListener(15, inputEventHandler);
        Label percentageLabel = new Label(parent, 0);
        percentageLabel.setText("%");
        percentageLabel.setLayoutData((Object)new GridData(4, 2, false, false));
        this.opacityScale = new SliderViewer(parent, 256);
        this.opacityScale.setLabelProvider((IBaseLabelProvider)new OpacityLabelProvider());
        this.opacityScale.getControl().setLayoutData((Object)new GridData(4, 2, true, false));
        this.opacityScale.getControl().setBackground(parent.getBackground());
        this.opacityScale.addSelectionChangedListener((ISelectionChangedListener)new OpacitySelectionChangedListener());
        this.opacityScale.addPostSelectionChangedListener((ISelectionChangedListener)new OpacityPostSelectionChangedListener());
    }

    private Image getOpacityImage() {
        ImageDescriptor icon;
        if (this.opacityImage == null && (icon = MindMapUI.getImages().get("icons/prop/opaque.gif")) != null) {
            this.opacityImage = icon.createImage(false);
        }
        return this.opacityImage;
    }

    private void releaseImages() {
        if (this.opacityImage != null) {
            this.opacityImage.dispose();
            this.opacityImage = null;
        }
    }

    private void selectAllOpacityText(final boolean takeFocus) {
        if (this.opacityInput != null && !this.opacityInput.isDisposed()) {
            this.opacityInput.getDisplay().asyncExec(new Runnable(){

                public void run() {
                    if (BoundaryShapePropertySectionPart.this.opacityInput != null && !BoundaryShapePropertySectionPart.this.opacityInput.isDisposed()) {
                        if (takeFocus) {
                            BoundaryShapePropertySectionPart.this.opacityInput.setFocus();
                        }
                        BoundaryShapePropertySectionPart.this.opacityInput.selectAll();
                    }
                }
            });
        }
    }

    private int getOpacityValueFromTextWidget() {
        if (this.opacityInput != null && !this.opacityInput.isDisposed()) {
            try {
                return Math.min(100, Integer.parseInt(this.opacityInput.getText()));
            }
            catch (NumberFormatException numberFormatException) {}
        }
        return -1;
    }

    private int getOpacityValueFromScaleSelection(ISelection selection) {
        Object o = ((IStructuredSelection)selection).getFirstElement();
        return this.getOpacityValueFromScaleElement(o);
    }

    private int getOpacityValueFromScaleElement(Object o) {
        if (o instanceof Double) {
            double value = (Double)o;
            return (int)Math.round(value * 100.0);
        }
        return -1;
    }

    public void setFocus() {
        if (this.shapeViewer != null && !this.shapeViewer.getControl().isDisposed()) {
            this.shapeViewer.getControl().setFocus();
        }
    }

    public void dispose() {
        super.dispose();
        this.shapeViewer = null;
        this.fillColorPicker = null;
        this.opacityInput = null;
        this.opacityScale = null;
    }

    @Override
    protected void doRefresh() {
        String shapeId = null;
        if (this.shapeViewer != null && !this.shapeViewer.getControl().isDisposed()) {
            shapeId = this.getStyleValue("shape-class", null);
            IDecorationDescriptor element = this.getSelectableShape(shapeId);
            if (element == null) {
                this.shapeViewer.setSelection((ISelection)StructuredSelection.EMPTY);
            } else {
                this.shapeViewer.setSelection((ISelection)new StructuredSelection((Object)element));
            }
        }
        if (this.fillColorPicker != null) {
            if (shapeId == null) {
                shapeId = this.getStyleValue("shape-class", null);
            }
            this.updateColorPicker(this.fillColorPicker, "svg:fill", shapeId);
        }
        this.updateOpacityToWidget();
    }

    private void updateOpacityToWidget() {
        String value = this.getStyleValue("svg:opacity", null);
        double doubleValue = this.parseOpacityValue(value);
        doubleValue = Math.max(0.0, Math.min(1.0, doubleValue));
        if (this.opacityInput != null && !this.opacityInput.isDisposed()) {
            this.opacityInput.setText(String.valueOf((int)Math.round(doubleValue * 100.0)));
        }
        if (this.opacityScale != null && !this.opacityScale.getControl().isDisposed()) {
            this.opacityScale.setSelection((ISelection)new StructuredSelection((Object)doubleValue));
        }
    }

    private double parseOpacityValue(String value) {
        if (value != null) {
            try {
                return Double.parseDouble(value);
            }
            catch (NumberFormatException numberFormatException) {}
        }
        return 1.0;
    }

    private IDecorationDescriptor getSelectableShape(String shapeId) {
        if (shapeId == null) {
            return null;
        }
        IDecorationDescriptor descriptor = MindMapUI.getDecorationManager().getDecorationDescriptor(shapeId);
        if (!BoundaryShapePropertySectionPart.getBoundaryShapes().contains(descriptor)) {
            return null;
        }
        return descriptor;
    }

    private void changeShape(String newShape) {
        Request request = this.createStyleRequest(CommandMessages.Command_ModifyBoundaryShape);
        this.addStyle(request, "shape-class", newShape);
        this.sendRequest(request);
    }

    protected void changeFillColor(IColorSelection selection) {
        this.changeColor(selection, "svg:fill", CommandMessages.Command_ModifyFillColor);
    }

    private void changeOpacity(int opacityValue) {
        Request request = this.createStyleRequest(CommandMessages.Command_ModifyWallpaperOpacity);
        String value = String.valueOf((double)opacityValue * 1.0 / 100.0);
        this.addStyle(request, "svg:opacity", value);
        this.sendRequest(request);
    }

    private void previewOpacity(int value) {
        IGraphicalViewer viewer = this.getActiveViewer();
        if (viewer != null) {
            int alpha = -1;
            Object[] objectArray = this.getSelectedElements();
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                IDecoration decoration;
                IFigure figure;
                Object o = objectArray[n2];
                IPart p = viewer.findPart(o);
                if (p instanceof IGraphicalPart && (figure = ((IGraphicalPart)p).getFigure()) instanceof IDecoratedFigure && (decoration = ((IDecoratedFigure)figure).getDecoration()) instanceof IShapeDecoration) {
                    if (alpha < 0) {
                        alpha = value * 255 / 100;
                    }
                    ((IShapeDecoration)decoration).setFillAlpha(figure, alpha);
                }
                ++n2;
            }
        }
    }

    private static List<IDecorationDescriptor> getBoundaryShapes() {
        if (BoundaryShapes == null) {
            BoundaryShapes = MindMapUI.getDecorationManager().getDescriptors("org.xmind.ui.boundaryDecorations");
        }
        return BoundaryShapes;
    }

    private class FillColorOpenListener
    implements IOpenListener {
        private FillColorOpenListener() {
        }

        public void open(OpenEvent event) {
            BoundaryShapePropertySectionPart.this.changeFillColor((IColorSelection)event.getSelection());
        }
    }

    private class OpacityLabelProvider
    extends LabelProvider {
        private OpacityLabelProvider() {
        }

        public String getText(Object element) {
            int value = BoundaryShapePropertySectionPart.this.getOpacityValueFromScaleElement(element);
            if (value >= 0) {
                return NLS.bind((String)PropertyMessages.BoundaryOpacity_pattern, (Object)value);
            }
            return super.getText(element);
        }
    }

    private class OpacityPostSelectionChangedListener
    implements ISelectionChangedListener {
        private OpacityPostSelectionChangedListener() {
        }

        public void selectionChanged(SelectionChangedEvent event) {
            int value = BoundaryShapePropertySectionPart.this.getOpacityValueFromScaleSelection(event.getSelection());
            if (value >= 0) {
                BoundaryShapePropertySectionPart.this.changeOpacity(value);
                BoundaryShapePropertySectionPart.this.selectAllOpacityText(true);
            }
        }
    }

    private class OpacitySelectionChangedListener
    implements ISelectionChangedListener {
        private OpacitySelectionChangedListener() {
        }

        public void selectionChanged(SelectionChangedEvent event) {
            int value = BoundaryShapePropertySectionPart.this.getOpacityValueFromScaleSelection(event.getSelection());
            if (value >= 0) {
                BoundaryShapePropertySectionPart.this.opacityInput.setText(String.valueOf(value));
                BoundaryShapePropertySectionPart.this.previewOpacity(value);
            }
        }
    }

    private class ShapeSelectionChangedListener
    implements ISelectionChangedListener {
        private ShapeSelectionChangedListener() {
        }

        public void selectionChanged(SelectionChangedEvent event) {
            if (BoundaryShapePropertySectionPart.this.isRefreshing()) {
                return;
            }
            Object o = ((IStructuredSelection)event.getSelection()).getFirstElement();
            if (o instanceof IDecorationDescriptor) {
                BoundaryShapePropertySectionPart.this.changeShape(((IDecorationDescriptor)o).getId());
            }
        }
    }
}

