/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.notes;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.TextViewer;
import org.eclipse.jface.text.hyperlink.DefaultHyperlinkPresenter;
import org.eclipse.jface.text.hyperlink.IHyperlinkDetector;
import org.eclipse.jface.text.hyperlink.IHyperlinkPresenter;
import org.eclipse.jface.viewers.IInputSelectionProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.xmind.ui.internal.notes.NotesHyperlinkDetector;
import org.xmind.ui.internal.spellsupport.SpellingSupport;
import org.xmind.ui.richtext.IRichDocument;
import org.xmind.ui.richtext.IRichTextActionBarContributor;
import org.xmind.ui.richtext.IRichTextEditViewer;
import org.xmind.ui.richtext.RichTextEditViewer;
import org.xmind.ui.texteditor.IControlContentAdapter2;
import org.xmind.ui.texteditor.StyledTextContentAdapter;

public class NotesViewer
implements IInputSelectionProvider {
    private IRichTextEditViewer implementation;
    private Object input;
    private SelectionSynchronizer selectionProvider;
    private IRichTextActionBarContributor contributor;

    public void setContributor(IRichTextActionBarContributor contributor) {
        this.contributor = contributor;
    }

    public void createControl(Composite parent) {
        this.createControl(parent, 834);
    }

    public void createControl(Composite parent, int textControlStyle) {
        this.implementation = new RichTextEditViewer(parent, textControlStyle, this.contributor);
        TextViewer viewer = this.implementation.getTextViewer();
        RGB red = new RGB(183, 0, 91);
        viewer.setHyperlinkPresenter((IHyperlinkPresenter)new DefaultHyperlinkPresenter(red));
        viewer.setHyperlinkDetectors(new IHyperlinkDetector[]{new NotesHyperlinkDetector()}, SWT.MOD1);
        this.implementation.setInput((Object)this.getDocument());
        this.addSpellCheck(viewer);
    }

    public void addSpellCheck(TextViewer viewer) {
        StyledTextContentAdapter styleAdapter = new StyledTextContentAdapter();
        SpellingSupport.getInstance().install((ITextViewer)viewer, (IControlContentAdapter2)styleAdapter);
    }

    private IRichDocument getDocument() {
        if (this.input instanceof IRichDocument) {
            return (IRichDocument)this.input;
        }
        if (this.input instanceof IAdaptable) {
            return (IRichDocument)((IAdaptable)this.input).getAdapter(IRichDocument.class);
        }
        return null;
    }

    public Control getControl() {
        return this.implementation == null ? null : this.implementation.getControl();
    }

    public IRichTextEditViewer getImplementation() {
        return this.implementation;
    }

    public void setInput(Object input) {
        this.input = input;
        if (this.implementation != null) {
            this.implementation.setInput((Object)this.getDocument());
        }
    }

    public Object getInput() {
        return this.input;
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        this.getSelectionProvider().addSelectionChangedListener(listener);
    }

    private SelectionSynchronizer getSelectionProvider() {
        if (this.selectionProvider != null) {
            this.selectionProvider = new SelectionSynchronizer();
        }
        return this.selectionProvider;
    }

    public ISelection getSelection() {
        return this.getSelectionProvider().getSelection();
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        if (this.selectionProvider != null) {
            this.selectionProvider.removeSelectionChangedListener(listener);
        }
    }

    public void setSelection(ISelection selection) {
        this.getSelectionProvider().setSelection(selection);
    }

    public boolean hasModified() {
        if (this.implementation != null) {
            return this.implementation.getTextViewer().getUndoManager().undoable();
        }
        return false;
    }

    private class SelectionSynchronizer
    implements ISelectionProvider,
    ISelectionChangedListener {
        private List<ISelectionChangedListener> selectionChangedListeners = null;
        private ISelection selection;
        private boolean synchronizingSelection = false;

        private SelectionSynchronizer() {
        }

        public void addSelectionChangedListener(ISelectionChangedListener listener) {
            if (this.selectionChangedListeners == null) {
                this.selectionChangedListeners = new ArrayList<ISelectionChangedListener>();
            }
            this.selectionChangedListeners.add(listener);
        }

        public ISelection getSelection() {
            return this.selection == null ? StructuredSelection.EMPTY : this.selection;
        }

        public void removeSelectionChangedListener(ISelectionChangedListener listener) {
            if (this.selectionChangedListeners == null) {
                return;
            }
            this.selectionChangedListeners.remove(listener);
        }

        public void setSelection(ISelection selection) {
            this.selection = selection;
            if (NotesViewer.this.implementation != null) {
                this.synchronizingSelection = true;
                NotesViewer.this.implementation.setSelection(selection);
                this.synchronizingSelection = false;
            }
        }

        public void selectionChanged(SelectionChangedEvent event) {
            if (this.synchronizingSelection) {
                return;
            }
            this.fireSelectionChanged(event);
        }

        private void fireSelectionChanged(SelectionChangedEvent event) {
            if (this.selectionChangedListeners == null) {
                return;
            }
            Object[] objectArray = this.selectionChangedListeners.toArray();
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object o = objectArray[n2];
                ((ISelectionChangedListener)o).selectionChanged(event);
                ++n2;
            }
        }
    }
}

