/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.notes;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.bindings.Trigger;
import org.eclipse.jface.bindings.TriggerSequence;
import org.eclipse.jface.bindings.keys.KeyStroke;
import org.eclipse.jface.bindings.keys.SWTKeySupport;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.PopupDialog;
import org.eclipse.jface.text.TextViewer;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.contexts.IContextActivation;
import org.eclipse.ui.contexts.IContextService;
import org.eclipse.ui.keys.IBindingService;
import org.xmind.core.INotes;
import org.xmind.core.INotesContent;
import org.xmind.core.ITopic;
import org.xmind.gef.EditDomain;
import org.xmind.gef.IGraphicalViewer;
import org.xmind.gef.IViewer;
import org.xmind.gef.ZoomManager;
import org.xmind.gef.command.Command;
import org.xmind.gef.command.CompoundCommand;
import org.xmind.gef.command.ICommandStack;
import org.xmind.ui.commands.CommandMessages;
import org.xmind.ui.commands.ModifyNotesCommand;
import org.xmind.ui.internal.MindMapMessages;
import org.xmind.ui.internal.MindMapUIPlugin;
import org.xmind.ui.internal.dialogs.DialogMessages;
import org.xmind.ui.internal.notes.NotesViewer;
import org.xmind.ui.internal.notes.RichDocumentNotesAdapter;
import org.xmind.ui.mindmap.ITopicPart;
import org.xmind.ui.mindmap.MindMapUI;
import org.xmind.ui.richtext.IRichTextActionBarContributor;
import org.xmind.ui.richtext.SimpleRichTextActionBarContributor;
import org.xmind.ui.util.Logger;

public class NotesPopup
extends PopupDialog {
    private static final String CONTEXT_ID = "org.xmind.ui.context.notesPopup";
    private static final String CMD_GOTO_NOTES_VIEW = "org.xmind.ui.command.gotoNotesView";
    private static final String CMD_COMMIT_NOTES = "org.xmind.ui.command.commitNotes";
    private static final String CMD_UNDO = "org.eclipse.ui.edit.undo";
    private static final String CMD_REDO = "org.eclipse.ui.edit.redo";
    private static final String CMD_SAVE = "org.eclipse.ui.file.save";
    private IWorkbenchWindow window;
    private ITopicPart topicPart;
    private NotesViewer notesViewer;
    private RichDocumentNotesAdapter notesAdapter;
    private Map<TriggerSequence, String> triggerableCommands = new HashMap<TriggerSequence, String>(3);
    private IContextActivation contextActivation;
    private IContextService contextService;
    private IBindingService bindingService;
    private boolean showGotoNotesView;
    private boolean editable;

    public NotesPopup(IWorkbenchWindow window, ITopicPart topicPart, boolean editable, boolean showGotoNotesView) {
        super(window.getShell(), 16, true, true, true, false, false, null, showGotoNotesView ? "" : null);
        this.window = window;
        this.topicPart = topicPart;
        this.showGotoNotesView = showGotoNotesView;
        this.editable = editable;
    }

    public NotesPopup(Shell parentShell, ITopicPart topicPart, boolean editable) {
        super(parentShell, 11, true, true, true, false, false, null, null);
        this.topicPart = topicPart;
        this.window = null;
        this.showGotoNotesView = false;
        this.editable = editable;
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        this.notesViewer = new NotesViewer();
        if (this.editable) {
            this.notesViewer.setContributor((IRichTextActionBarContributor)new NotesPopupActionBarContributor());
        }
        int style = 834;
        if (!this.editable) {
            style |= 8;
        }
        this.notesViewer.createControl(composite, style);
        GridData gridData = new GridData(1808);
        gridData.widthHint = 400;
        this.notesViewer.getControl().setLayoutData((Object)gridData);
        ITopic topic = this.topicPart.getTopic();
        this.notesAdapter = new RichDocumentNotesAdapter(topic);
        this.notesViewer.setInput(this.notesAdapter);
        this.notesViewer.getControl().addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                if (NotesPopup.this.notesAdapter != null) {
                    NotesPopup.this.notesAdapter.dispose();
                    NotesPopup.this.notesAdapter = null;
                }
            }
        });
        new PopupKeyboardListener().hook(this.notesViewer.getImplementation().getFocusControl());
        return composite;
    }

    public NotesViewer getNotesViewer() {
        return this.notesViewer;
    }

    public RichDocumentNotesAdapter getNotesAdapter() {
        return this.notesAdapter;
    }

    public ITopicPart getTopicPart() {
        return this.topicPart;
    }

    protected Control getFocusControl() {
        return this.notesViewer.getImplementation().getFocusControl();
    }

    protected Point getInitialLocation(Point initialSize) {
        IViewer viewer = this.topicPart.getSite().getViewer();
        Rectangle bounds = this.topicPart.getFigure().getBounds().getCopy();
        return this.calcInitialLocation((IGraphicalViewer)viewer, bounds);
    }

    private Point calcInitialLocation(IGraphicalViewer viewer, Rectangle bounds) {
        ZoomManager zoom = viewer.getZoomManager();
        bounds = bounds.scale(zoom.getScale()).expand(1, 1).translate(viewer.getScrollPosition().getNegated());
        return viewer.getControl().toDisplay(bounds.x, bounds.y + bounds.height);
    }

    protected List getBackgroundColorExclusions() {
        List list = super.getBackgroundColorExclusions();
        this.collectBackgroundColorExclusions(this.notesViewer.getControl(), list);
        return list;
    }

    private void collectBackgroundColorExclusions(Control control, List list) {
        list.add(control);
        if (control instanceof Composite) {
            Control[] controlArray = ((Composite)control).getChildren();
            int n = controlArray.length;
            int n2 = 0;
            while (n2 < n) {
                Control child = controlArray[n2];
                this.collectBackgroundColorExclusions(child, list);
                ++n2;
            }
        }
    }

    protected IDialogSettings getDialogSettings() {
        return MindMapUIPlugin.getDefault().getDialogSettings("org.xmind.ui.popupDialog");
    }

    public int open() {
        int ret;
        this.bindingService = (IBindingService)PlatformUI.getWorkbench().getAdapter(IBindingService.class);
        this.contextService = (IContextService)PlatformUI.getWorkbench().getAdapter(IContextService.class);
        if (this.bindingService != null) {
            this.registerWorkbenchCommands();
        }
        if ((ret = super.open()) == 0) {
            if (this.contextService != null) {
                this.contextActivation = this.contextService.activateContext(CONTEXT_ID);
            }
            if (this.bindingService != null) {
                this.registerDialogCommands();
            }
        }
        return ret;
    }

    protected void registerDialogCommands() {
        TriggerSequence key;
        if (this.showGotoNotesView && (key = this.registerCommand(CMD_GOTO_NOTES_VIEW)) != null) {
            this.setInfoText(NLS.bind((String)DialogMessages.NotesPopup_GotoNotesView_text, (Object)key.format()));
        }
        this.registerCommand(CMD_COMMIT_NOTES);
    }

    protected void registerWorkbenchCommands() {
        this.registerCommand(CMD_UNDO);
        this.registerCommand(CMD_REDO);
        this.registerCommand(CMD_SAVE);
    }

    protected TriggerSequence registerCommand(String commandId) {
        if (this.bindingService == null) {
            return null;
        }
        TriggerSequence key = this.bindingService.getBestActiveBindingFor(commandId);
        if (key != null) {
            this.triggerableCommands.put(key, commandId);
        }
        return key;
    }

    protected boolean handleCommand(String commandId) {
        if (CMD_GOTO_NOTES_VIEW.equals(commandId)) {
            if (this.showGotoNotesView) {
                this.gotoNotesView();
            }
            return true;
        }
        if (CMD_UNDO.equals(commandId)) {
            TextViewer textViewer = this.notesViewer.getImplementation().getTextViewer();
            if (textViewer.canDoOperation(1)) {
                textViewer.doOperation(1);
            }
            return true;
        }
        if (CMD_REDO.equals(commandId)) {
            TextViewer textViewer = this.notesViewer.getImplementation().getTextViewer();
            if (textViewer.canDoOperation(2)) {
                textViewer.doOperation(2);
            }
            return true;
        }
        if (CMD_COMMIT_NOTES.equals(commandId)) {
            this.setReturnCode(0);
            this.close();
            return true;
        }
        if (CMD_SAVE.equals(commandId)) {
            this.saveNotes();
            return true;
        }
        return false;
    }

    public boolean close() {
        if (this.contextActivation != null && this.contextService != null) {
            this.contextService.deactivateContext(this.contextActivation);
            this.contextActivation = null;
        }
        if (this.getReturnCode() == 0) {
            this.saveNotes();
        }
        return super.close();
    }

    private void saveNotes() {
        ICommandStack cs;
        if (this.notesAdapter == null || this.notesViewer == null || this.notesViewer.getControl().isDisposed() || !this.notesViewer.hasModified()) {
            return;
        }
        INotesContent html = this.notesAdapter.makeNewHtmlContent();
        INotesContent plain = this.notesAdapter.makeNewPlainContent();
        ITopic topic = this.topicPart.getTopic();
        EditDomain domain = this.topicPart.getSite().getViewer().getEditDomain();
        if (domain != null && (cs = domain.getCommandStack()) != null) {
            ModifyNotesCommand modifyHtml = new ModifyNotesCommand(topic, html, "html");
            ModifyNotesCommand modifyPlain = new ModifyNotesCommand(topic, plain, "plain");
            CompoundCommand cmd = new CompoundCommand(new Command[]{modifyHtml, modifyPlain});
            cmd.setLabel(CommandMessages.Command_ModifyNotes);
            cs.execute((Command)cmd);
            return;
        }
        INotes notes = topic.getNotes();
        notes.setContent("html", html);
        notes.setContent("plain", plain);
    }

    private void gotoNotesView() {
        if (this.window == null) {
            return;
        }
        IWorkbenchPage workbenchPage = this.window.getActivePage();
        if (workbenchPage == null) {
            return;
        }
        this.close();
        try {
            workbenchPage.showView("org.xmind.ui.NotesView", null, 1);
        }
        catch (PartInitException e) {
            Logger.log(e, "GotoNotesViewAction failed to show Notes View.");
        }
    }

    private class NotesPopupActionBarContributor
    extends SimpleRichTextActionBarContributor {
        private NotesPopupActionBarContributor() {
        }

        public void fillToolBar(IToolBarManager toolbar) {
            super.fillToolBar(toolbar);
            if (NotesPopup.this.showGotoNotesView) {
                toolbar.add((IContributionItem)new Separator());
                toolbar.add((IAction)new GotoNotesViewAction());
            }
        }

        private class GotoNotesViewAction
        extends Action {
            public GotoNotesViewAction() {
                super(MindMapMessages.EditInNotesView_text);
                this.setToolTipText(MindMapMessages.EditInNotesView_toolTip);
                this.setImageDescriptor(MindMapUI.getImages().get("notes.gif", true));
                this.setDisabledImageDescriptor(MindMapUI.getImages().get("notes.gif", false));
            }

            public void run() {
                NotesPopup.this.gotoNotesView();
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class PopupKeyboardListener
    implements Listener {
        private List<TriggerSequence> currentSequences = null;
        private int nextKeyIndex = -1;

        private PopupKeyboardListener() {
        }

        public void hook(Control control) {
            control.getDisplay().addFilter(1, (Listener)this);
            control.getShell().addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent e) {
                    if (!e.display.isDisposed()) {
                        e.display.removeFilter(1, (Listener)PopupKeyboardListener.this);
                    }
                }
            });
        }

        public void handleEvent(Event event) {
            if (event.type == 1) {
                this.handleKeyDown(event);
            }
        }

        private void handleKeyDown(Event event) {
            if (NotesPopup.this.triggerableCommands.isEmpty()) {
                return;
            }
            List<KeyStroke> keys = this.generateKeyStrokes(event);
            if (this.currentSequences == null) {
                this.nextKeyIndex = -1;
                for (TriggerSequence ts : NotesPopup.this.triggerableCommands.keySet()) {
                    if (!this.matches(keys, ts.getTriggers()[0])) continue;
                    if (this.currentSequences == null) {
                        this.currentSequences = new ArrayList<TriggerSequence>(NotesPopup.this.triggerableCommands.size());
                    }
                    this.currentSequences.add(ts);
                }
                if (this.currentSequences == null) {
                    return;
                }
            }
            if (this.nextKeyIndex < 0) {
                this.nextKeyIndex = 0;
            }
            Iterator<TriggerSequence> it = this.currentSequences.iterator();
            while (it.hasNext()) {
                TriggerSequence ts = it.next();
                Trigger[] triggers = ts.getTriggers();
                if (this.nextKeyIndex >= triggers.length) {
                    it.remove();
                    continue;
                }
                if (this.matches(keys, triggers[this.nextKeyIndex])) {
                    if (this.nextKeyIndex != triggers.length - 1) continue;
                    if (this.triggerFound(ts)) {
                        event.doit = false;
                    }
                    return;
                }
                it.remove();
            }
            if (this.currentSequences != null && this.currentSequences.isEmpty()) {
                ++this.nextKeyIndex;
            } else {
                this.currentSequences = null;
                this.nextKeyIndex = -1;
            }
        }

        private boolean triggerFound(TriggerSequence triggerSequence) {
            this.currentSequences = null;
            this.nextKeyIndex = -1;
            String commandId = (String)NotesPopup.this.triggerableCommands.get(triggerSequence);
            if (commandId != null) {
                return NotesPopup.this.handleCommand(commandId);
            }
            return false;
        }

        private boolean matches(List<KeyStroke> keys, Trigger expected) {
            for (KeyStroke key : keys) {
                if (!key.equals((Object)expected)) continue;
                return true;
            }
            return false;
        }

        private List<KeyStroke> generateKeyStrokes(Event event) {
            int thirdAccelerator;
            ArrayList<KeyStroke> keyStrokes = new ArrayList<KeyStroke>(3);
            if (event.stateMask == 0 && event.keyCode == 0 && event.character == '\u0000') {
                return keyStrokes;
            }
            int firstAccelerator = SWTKeySupport.convertEventToUnmodifiedAccelerator((Event)event);
            keyStrokes.add(SWTKeySupport.convertAcceleratorToKeyStroke((int)firstAccelerator));
            if (event.character == '\u007f') {
                return keyStrokes;
            }
            int secondAccelerator = SWTKeySupport.convertEventToUnshiftedModifiedAccelerator((Event)event);
            if (secondAccelerator != firstAccelerator) {
                keyStrokes.add(SWTKeySupport.convertAcceleratorToKeyStroke((int)secondAccelerator));
            }
            if ((thirdAccelerator = SWTKeySupport.convertEventToModifiedAccelerator((Event)event)) != secondAccelerator && thirdAccelerator != firstAccelerator) {
                keyStrokes.add(SWTKeySupport.convertAcceleratorToKeyStroke((int)thirdAccelerator));
            }
            return keyStrokes;
        }
    }
}

