/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.mindmap;

import org.eclipse.draw2d.Cursors;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.swt.graphics.Cursor;
import org.xmind.core.IControlPoint;
import org.xmind.core.IRelationship;
import org.xmind.core.IRelationshipEnd;
import org.xmind.core.event.CoreEvent;
import org.xmind.core.event.ICoreEventRegister;
import org.xmind.core.event.ICoreEventSource;
import org.xmind.gef.IDecorator;
import org.xmind.gef.graphicalpolicy.IGraphicalPolicy;
import org.xmind.gef.part.IGraphicalEditPart;
import org.xmind.gef.part.IPart;
import org.xmind.gef.part.IRequestHandler;
import org.xmind.gef.policy.IEditPolicy;
import org.xmind.gef.policy.NullEditPolicy;
import org.xmind.gef.service.IFeedback;
import org.xmind.ui.internal.decorators.RelationshipDecorator;
import org.xmind.ui.internal.figures.RelationshipFigure;
import org.xmind.ui.internal.graphicalpolicies.RelationshipGraphicalPolicy;
import org.xmind.ui.internal.mindmap.ConnectionPart;
import org.xmind.ui.internal.mindmap.DecoratedRelFeedback;
import org.xmind.ui.internal.mindmap.RelTitleTextPart;
import org.xmind.ui.internal.mindmap.RelationshipFeedback;
import org.xmind.ui.internal.mindmap.RelationshipSelectionHelper;
import org.xmind.ui.internal.mindmap.SheetPart;
import org.xmind.ui.internal.mindmap.TitleTextPart;
import org.xmind.ui.internal.mindmap.ViewerModel;
import org.xmind.ui.mindmap.INodePart;
import org.xmind.ui.mindmap.IRelationshipPart;
import org.xmind.ui.mindmap.ISelectionFeedbackHelper;
import org.xmind.ui.mindmap.ISheetPart;
import org.xmind.ui.mindmap.ITitleTextPart;

public class RelationshipPart
extends ConnectionPart
implements IRelationshipPart {
    private ITitleTextPart title = null;

    public RelationshipPart() {
        this.setDecorator((IDecorator)RelationshipDecorator.getInstance());
        this.setGraphicalPolicy((IGraphicalPolicy)RelationshipGraphicalPolicy.getInstance());
    }

    protected IFeedback createFeedback() {
        RelationshipFeedback feedback = new RelationshipFeedback(this);
        feedback.addFeedback((IFeedback)new DecoratedRelFeedback(this));
        return feedback;
    }

    protected ISelectionFeedbackHelper createSelectionFeedbackHelper() {
        return new RelationshipSelectionHelper();
    }

    public IRelationship getRelationship() {
        return (IRelationship)super.getRealModel();
    }

    public ISheetPart getOwnerSheet() {
        if (this.getParent() instanceof ISheetPart) {
            return (ISheetPart)this.getParent();
        }
        return null;
    }

    public void setParent(IPart parent) {
        if (this.getParent() instanceof SheetPart) {
            ((SheetPart)this.getParent()).removeRelationship(this);
        }
        super.setParent(parent);
        if (this.getParent() instanceof SheetPart) {
            ((SheetPart)this.getParent()).addRelationship(this);
        }
    }

    public ITitleTextPart getTitle() {
        return this.title;
    }

    public void setTitle(ITitleTextPart title) {
        this.title = title;
        ((RelationshipFigure)this.getFigure()).setTitle(title == null ? null : title.getTextFigure());
    }

    protected void register() {
        this.registerModel(this.getRelationship());
        super.register();
    }

    protected void unregister() {
        super.unregister();
        this.unregisterModel(this.getRelationship());
    }

    private boolean hasTitle() {
        IRelationship titled = this.getRelationship();
        return titled.hasTitle() && !"".equals(titled.getTitleText());
    }

    protected Object[] getModelChildren(Object model) {
        return new Object[]{new ViewerModel(RelTitleTextPart.class, this.getRelationship())};
    }

    protected void declareEditPolicies(IRequestHandler reqHandler) {
        super.declareEditPolicies(reqHandler);
        reqHandler.installEditPolicy("selectable role", (IEditPolicy)NullEditPolicy.getInstance());
        reqHandler.installEditPolicy("movable role", "org.xmind.ui.editPolicy.relationshipMovable");
        reqHandler.installEditPolicy("editable role", "org.xmind.ui.editPolicy.editable");
        reqHandler.installEditPolicy("modifiable role", "org.xmind.ui.editPolicy.modifiable");
        reqHandler.installEditPolicy("deletable role", "org.xmind.ui.editPolicy.deletable");
        reqHandler.installEditPolicy("creatable role", "org.xmind.ui.editPolicy.relationshipCreatable");
        reqHandler.installEditPolicy("traversable role", "org.xmind.ui.editPolicy.relationshipTraversable");
        reqHandler.installEditPolicy("navigable role", "org.xmind.ui.editPolicy.topicNavigable");
    }

    public Object getAdapter(Class adapter) {
        if (adapter.isAssignableFrom(IRelationship.class)) {
            return this.getRelationship();
        }
        if (adapter == TitleTextPart.class || adapter == ITitleTextPart.class) {
            return this.getTitle();
        }
        return super.getAdapter(adapter);
    }

    public int getPointId(Point position) {
        return ((RelationshipFeedback)this.getFeedback()).getPointId(position);
    }

    public boolean containsPoint(Point position) {
        return super.containsPoint(position) || (this.getStatus().isSelected() || this.getStatus().isPreSelected()) && this.getPointId(position) != 0;
    }

    public IPart findAt(Point position) {
        IPart ret;
        ITitleTextPart title = this.getTitle();
        if (title != null && (ret = ((IGraphicalEditPart)title).findAt(position)) != null) {
            return this;
        }
        ret = super.findAt(position);
        return ret;
    }

    public Cursor getCursor(Point pos) {
        int pointId = this.getPointId(pos);
        if (pointId == 1 || pointId == 2) {
            return Cursors.HAND;
        }
        if (pointId == 3 || pointId == 4) {
            return Cursors.CROSS;
        }
        return super.getCursor(pos);
    }

    public void refresh() {
        super.refresh();
        ITitleTextPart title = this.getTitle();
        if (title != null) {
            title.refresh();
        }
    }

    public void update() {
        super.update();
        ITitleTextPart title = this.getTitle();
        if (title != null) {
            title.update();
        }
    }

    protected IFigure createFigure() {
        RelationshipFigure fig = new RelationshipFigure();
        fig.setTitleVisible(this.hasTitle());
        return fig;
    }

    protected INodePart findSourceNode() {
        return this.findNode(this.getRelationship().getEnd1());
    }

    protected INodePart findTargetNode() {
        return this.findNode(this.getRelationship().getEnd2());
    }

    private INodePart findNode(IRelationshipEnd end) {
        IPart p;
        if (end != null && (p = this.getSite().getViewer().findPart((Object)end)) instanceof INodePart) {
            return (INodePart)p;
        }
        return null;
    }

    protected void registerCoreEvents(ICoreEventSource source, ICoreEventRegister register) {
        super.registerCoreEvents(source, register);
        register.register("relationshipEnd1");
        register.register("relationshipEnd2");
        register.register("style");
        if (source instanceof IRelationship) {
            IControlPoint cp2;
            IControlPoint cp1 = ((IRelationship)source).getControlPoint(0);
            if (cp1 instanceof ICoreEventSource) {
                register.setNextSource((ICoreEventSource)cp1);
                register.register("position");
            }
            if ((cp2 = ((IRelationship)source).getControlPoint(1)) instanceof ICoreEventSource) {
                register.setNextSource((ICoreEventSource)cp2);
                register.register("position");
            }
        }
    }

    public void handleCoreEvent(CoreEvent event) {
        String type = event.getType();
        if ("position".equals(type)) {
            this.update();
        } else if ("relationshipEnd1".equals(type) || "relationshipEnd2".equals(type)) {
            this.refresh();
        } else if ("style".equals(type)) {
            this.update();
        } else {
            super.handleCoreEvent(event);
        }
    }
}

