/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.mindmap;

import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Layer;
import org.eclipse.draw2d.LayoutListener;
import org.eclipse.draw2d.Viewport;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.xmind.gef.GEF;
import org.xmind.gef.IGraphicalViewer;
import org.xmind.gef.ILayerManager;
import org.xmind.gef.IViewer;
import org.xmind.gef.IZoomListener;
import org.xmind.gef.ZoomObject;
import org.xmind.gef.part.GraphicalRootEditPart;
import org.xmind.gef.part.IGraphicalPart;
import org.xmind.gef.part.IPart;
import org.xmind.gef.service.IAnimationService;
import org.xmind.gef.util.Properties;
import org.xmind.ui.internal.layers.ContentsLayer;
import org.xmind.ui.internal.layers.FeedbackLayer;
import org.xmind.ui.internal.layers.MindMapLayeredPane;
import org.xmind.ui.internal.layers.MindMapViewport;
import org.xmind.ui.mindmap.MindMapUI;

public class MindMapRootPart
extends GraphicalRootEditPart
implements IZoomListener,
ILayerManager,
ControlListener,
LayoutListener {
    public void setViewer(IViewer viewer) {
        if (this.getViewer() instanceof IGraphicalViewer) {
            ((IGraphicalViewer)this.getViewer()).setLayerManager(null);
        }
        super.setViewer(viewer);
        if (this.getViewer() instanceof IGraphicalViewer) {
            ((IGraphicalViewer)this.getViewer()).setLayerManager((ILayerManager)this);
        }
    }

    protected IFigure createFigure() {
        Object margin;
        MindMapViewport viewport = new MindMapViewport();
        viewport.setBackgroundColor(ColorConstants.white);
        MindMapLayeredPane layeredPane = new MindMapLayeredPane();
        viewport.setContents((IFigure)layeredPane);
        ContentsLayer contentsLayer = (ContentsLayer)layeredPane.getLayer(GEF.LAYER_CONTENTS);
        Properties properties = this.getViewer().getProperties();
        contentsLayer.setCentered(properties.getBoolean("centered", false));
        boolean constrained = properties.getBoolean("constrained", false);
        contentsLayer.setConstrained(constrained);
        if (properties.getBoolean("cornered", false)) {
            contentsLayer.addCorners();
        }
        if ((margin = properties.get("margin")) != null && margin instanceof Integer) {
            contentsLayer.setMargin((Integer)margin);
        }
        if (!constrained) {
            layeredPane.getScalableLayeredPane().setScale(((IGraphicalViewer)this.getViewer()).getZoomManager().getScale());
        }
        viewport.addLayoutListener(this);
        return viewport;
    }

    public Viewport getViewport() {
        return (Viewport)super.getFigure();
    }

    public MindMapLayeredPane getLayeredPane() {
        return (MindMapLayeredPane)this.getViewport().getContents();
    }

    public ContentsLayer getContentsLayer() {
        return (ContentsLayer)this.getLayer(GEF.LAYER_CONTENTS);
    }

    public FeedbackLayer getFeedbackLayer() {
        return (FeedbackLayer)this.getLayer(GEF.LAYER_FEEDBACK);
    }

    public IFigure getContentPane() {
        return this.getContentsLayer();
    }

    public void setContents(IPart part) {
        boolean contentsChanged = part != this.getContents();
        super.setContents(part);
        MindMapLayeredPane layeredPane = this.getLayeredPane();
        if (contentsChanged && MindMapUI.isAnimationEnabled() && this.getSite().getViewer().hasService(IAnimationService.class)) {
            layeredPane.setAlpha(0);
            layeredPane.setTargetAlpha(255);
        } else {
            layeredPane.setAlpha(255);
            layeredPane.setTargetAlpha(255);
        }
    }

    protected void addChildView(IPart child, int index) {
        this.getContentsLayer().setContents(((IGraphicalPart)child).getFigure());
    }

    protected void removeChildView(IPart child) {
        this.getContentsLayer().setContents(null);
    }

    protected void onActivated() {
        ((IGraphicalViewer)this.getViewer()).getZoomManager().addZoomListener((IZoomListener)this);
        this.getViewer().getControl().addControlListener((ControlListener)this);
        super.onActivated();
    }

    protected void onDeactivated() {
        super.onDeactivated();
        this.getViewer().getControl().removeControlListener((ControlListener)this);
        ((IGraphicalViewer)this.getViewer()).getZoomManager().removeZoomListener((IZoomListener)this);
    }

    public void scaleChanged(ZoomObject source, double oldValue, double newValue) {
        this.getLayeredPane().getScalableLayeredPane().setScale(newValue);
    }

    public void insertLayer(Object key, Layer layer, Object before, boolean scalable) {
        MindMapLayeredPane pane = scalable ? this.getLayeredPane().getScalableLayeredPane() : this.getLayeredPane();
        if (before == null) {
            pane.add((IFigure)layer, before);
        } else {
            pane.addLayerBefore(layer, key, before);
        }
    }

    public void removeLayer(Object key) {
        this.getLayeredPane().removeLayer(key);
    }

    public Layer getLayer(Object key) {
        return this.getLayeredPane().getLayer(key);
    }

    public void controlMoved(ControlEvent e) {
    }

    public void controlResized(ControlEvent e) {
        if (this.getViewer().getProperties().getBoolean("constrained", false)) {
            ((IGraphicalViewer)this.getViewer()).getZoomManager().setScale(this.calculateConstrainedScale());
        }
    }

    private double calculateConstrainedScale() {
        Rectangle maxSize = ((Composite)this.getViewer().getControl()).getClientArea();
        ContentsLayer layer = (ContentsLayer)this.getLayer(GEF.LAYER_CONTENTS);
        IFigure contents = layer.getContents();
        Dimension size = contents.getPreferredSize();
        double scale = Math.min((double)(maxSize.width - layer.getMargin()) * 1.0 / (double)size.width, (double)(maxSize.height - layer.getMargin()) * 1.0 / (double)size.height);
        return scale;
    }

    public void invalidate(IFigure container) {
    }

    public boolean layout(IFigure container) {
        if (this.getViewer().getProperties().getBoolean("constrained", false)) {
            ((IGraphicalViewer)this.getViewer()).getZoomManager().setScale(this.calculateConstrainedScale());
        }
        return false;
    }

    public void postLayout(IFigure container) {
    }

    public void remove(IFigure child) {
    }

    public void setConstraint(IFigure child, Object constraint) {
    }
}

