/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.mindmap;

import java.util.List;
import org.eclipse.draw2d.geometry.Rectangle;
import org.xmind.gef.IGraphicalViewer;
import org.xmind.gef.draw2d.geometry.PrecisionPoint;
import org.xmind.gef.part.IGraphicalPart;
import org.xmind.ui.internal.mindmap.CenteredRevealService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MindMapRevealService
extends CenteredRevealService {
    private boolean centered = false;

    public MindMapRevealService(IGraphicalViewer viewer) {
        super(viewer, false);
    }

    public void startCenteredReveal() {
        this.centered = true;
    }

    public boolean isCentered() {
        return this.centered;
    }

    protected void revealJobCanceled(List<IGraphicalPart> toReveal) {
        super.revealJobCanceled(toReveal);
        this.centered = false;
    }

    protected void revealJobFinished(List<IGraphicalPart> toReveal) {
        super.revealJobFinished(toReveal);
        this.centered = false;
    }

    @Override
    protected double calcTargetScale(List<IGraphicalPart> toReveal, Rectangle revealBounds) {
        return -1.0;
    }

    @Override
    protected PrecisionPoint calcTargetCenter(List<IGraphicalPart> toReveal, Rectangle revealBounds, double targetScale) {
        if (this.isCentered()) {
            return super.calcTargetCenter(toReveal, revealBounds, targetScale);
        }
        revealBounds.expand(20, 20);
        Rectangle clientArea = this.getViewerClientArea();
        if (!clientArea.contains(revealBounds) && !revealBounds.contains(clientArea)) {
            int dx = 0;
            int dy = 0;
            int margin = 20;
            if (revealBounds.width > clientArea.width) {
                dx = revealBounds.getCenter().x - clientArea.getCenter().x;
            } else if (revealBounds.x < clientArea.x) {
                dx = revealBounds.x - clientArea.x - margin;
            } else if (revealBounds.right() > clientArea.right()) {
                dx = revealBounds.right() - clientArea.right() + margin;
            }
            if (revealBounds.height > clientArea.height) {
                dy = revealBounds.getCenter().y - clientArea.getCenter().y;
            } else if (revealBounds.y < clientArea.y) {
                dy = revealBounds.y - clientArea.y - margin;
            } else if (revealBounds.bottom() > clientArea.bottom()) {
                dy = revealBounds.bottom() - clientArea.bottom() + margin;
            }
            return this.getViewerCenterPoint(this.getViewerScale()).translate((double)dx, (double)dy);
        }
        return null;
    }

    protected Rectangle getViewerClientArea() {
        Rectangle clientArea = this.getViewer().getClientArea();
        return this.getViewer().getZoomManager().getAntiScaled(clientArea);
    }
}

