/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.mindmap;

import java.util.ArrayList;
import java.util.List;
import org.xmind.core.ISheet;
import org.xmind.core.ITopic;
import org.xmind.gef.IGraphicalViewer;
import org.xmind.gef.service.GraphicalViewerService;
import org.xmind.ui.mindmap.IDrillDownTraceListener;
import org.xmind.ui.mindmap.IDrillDownTraceService;
import org.xmind.ui.mindmap.IMindMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DrillDownTraceService
extends GraphicalViewerService
implements IDrillDownTraceService {
    private List<ITopic> centralTopics = new ArrayList<ITopic>();
    private List<IDrillDownTraceListener> listeners = null;

    public DrillDownTraceService(IGraphicalViewer viewer) {
        super(viewer);
    }

    protected void activate() {
    }

    protected void deactivate() {
    }

    @Override
    public List<ITopic> getCentralTopics() {
        this.checkEmpty();
        return this.centralTopics;
    }

    @Override
    public ITopic getCurrentCentralTopic() {
        this.checkEmpty();
        if (this.centralTopics.isEmpty()) {
            return (ITopic)this.getViewer().getAdapter(ITopic.class);
        }
        return this.centralTopics.get(this.centralTopics.size() - 1);
    }

    @Override
    public boolean canDrillUp() {
        this.checkEmpty();
        return this.centralTopics.size() >= 2;
    }

    @Override
    public ITopic getPreviousCentralTopic() {
        this.checkEmpty();
        int size = this.centralTopics.size();
        if (size >= 2) {
            return this.centralTopics.get(size - 2);
        }
        return null;
    }

    @Override
    public void setCentralTopic(ITopic topic) {
        if (topic == null) {
            this.centralTopics.clear();
            this.checkEmpty();
            this.fireHistoryChanged();
        } else {
            boolean changed = this.checkEmpty();
            int i = 0;
            while (i < this.centralTopics.size()) {
                ITopic t = this.centralTopics.get(i);
                if (t.equals(topic)) {
                    while (this.centralTopics.size() > i + 1) {
                        ITopic removed = this.centralTopics.remove(this.centralTopics.size() - 1);
                        changed |= removed != null;
                    }
                    if (changed) {
                        this.fireHistoryChanged();
                    }
                    return;
                }
                ++i;
            }
            this.centralTopics.add(topic);
            this.fireHistoryChanged();
        }
    }

    private boolean checkEmpty() {
        ITopic rootTopic;
        if (this.centralTopics.isEmpty() && (rootTopic = (ITopic)this.getViewer().getAdapter(ITopic.class)) != null) {
            this.centralTopics.add(rootTopic);
            return true;
        }
        return false;
    }

    @Override
    public void addTraceListener(IDrillDownTraceListener listener) {
        if (listener == null) {
            return;
        }
        if (this.listeners == null) {
            this.listeners = new ArrayList<IDrillDownTraceListener>();
        }
        this.listeners.add(listener);
    }

    @Override
    public void removeTraceListener(IDrillDownTraceListener listener) {
        if (listener == null || this.listeners == null) {
            return;
        }
        this.listeners.remove(listener);
        if (this.listeners.isEmpty()) {
            this.listeners = null;
        }
    }

    protected void fireHistoryChanged() {
        if (this.listeners == null || this.listeners.isEmpty()) {
            return;
        }
        Object[] objectArray = this.listeners.toArray();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object o = objectArray[n2];
            ((IDrillDownTraceListener)o).traceChanged(this);
            ++n2;
        }
    }

    public void inputChanged(Object oldInput, Object newInput) {
        if (newInput instanceof IMindMap) {
            this.setCentralTopic(((IMindMap)newInput).getCentralTopic());
        } else if (newInput instanceof ISheet) {
            this.setCentralTopic(((ISheet)newInput).getRootTopic());
        } else if (newInput instanceof ITopic) {
            this.setCentralTopic((ITopic)newInput);
        } else {
            this.setCentralTopic(null);
        }
    }
}

