/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.layouts;

import java.util.List;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.xmind.core.IImage;
import org.xmind.gef.draw2d.IMinimizable;
import org.xmind.gef.draw2d.IRotatableFigure;
import org.xmind.gef.draw2d.IRotatableReferenceDescriptor;
import org.xmind.gef.draw2d.IRotatableReferencedLayout;
import org.xmind.gef.draw2d.ReferencedLayoutData;
import org.xmind.gef.draw2d.geometry.PrecisionDimension;
import org.xmind.gef.draw2d.geometry.PrecisionInsets;
import org.xmind.gef.draw2d.geometry.PrecisionRectangle;
import org.xmind.gef.draw2d.geometry.PrecisionRotator;
import org.xmind.ui.internal.layouts.MindMapLayoutBase;
import org.xmind.ui.mindmap.IIconTipPart;
import org.xmind.ui.mindmap.IImagePart;
import org.xmind.ui.mindmap.IMarkerPart;
import org.xmind.ui.mindmap.INumberingPart;
import org.xmind.ui.mindmap.ITitleTextPart;
import org.xmind.ui.mindmap.ITopicPart;

public class TopicLayout
extends MindMapLayoutBase
implements IRotatableReferenceDescriptor,
IRotatableReferencedLayout {
    private int spacing = 2;
    private PrecisionInsets normalRefDesc = null;
    private PrecisionDimension normalSize = null;
    private PrecisionRectangle normalClientArea = null;
    private Insets rotatedRefDesc = null;
    private Dimension rotatedSize = null;
    private Rectangle rotatedClientArea = null;
    private PrecisionRotator rotator = null;

    public TopicLayout(ITopicPart topic) {
        super(topic);
    }

    protected ITopicPart getTopic() {
        return (ITopicPart)super.getPart();
    }

    public int getSpacing() {
        return this.spacing;
    }

    public void setSpacing(int spacing) {
        this.spacing = spacing;
    }

    protected void fillLayoutData(IFigure container, ReferencedLayoutData data) {
        INumberingPart numbering;
        List<IMarkerPart> markers;
        boolean minimized = this.isMinimized(container);
        ITopicPart topic = this.getTopic();
        ITitleTextPart title = topic.getTitle();
        IImagePart image = topic.getImagePart();
        if ((topic.getTopic().hasTitle() && !"".equals(topic.getTopic().getTitleText()) || image == null) && title != null) {
            if (minimized) {
                data.put(title.getFigure(), this.createMinArea(data));
            } else {
                this.fillText(title, data);
            }
        }
        if (!(markers = topic.getMarkers()).isEmpty()) {
            data.translate(5, 0);
            int i = markers.size() - 1;
            while (i >= 0) {
                IMarkerPart marker = markers.get(i);
                this.fillMarker(marker, data);
                --i;
            }
        }
        if ((numbering = topic.getNumberingPart()) != null) {
            if (minimized) {
                data.put(numbering.getFigure(), this.createMinArea(data));
            } else {
                this.fillNumbering(numbering, data);
            }
        }
        List<IIconTipPart> iconTips = topic.getIconTips();
        for (IIconTipPart iconTip : iconTips) {
            if (minimized) {
                data.put(iconTip.getFigure(), this.createMinArea(data));
                continue;
            }
            this.fillIconTip(iconTip, data);
        }
        if (image != null) {
            if (minimized) {
                data.put(image.getFigure(), this.createMinArea(data));
            } else {
                this.fillImage(image, data);
            }
        }
        if (title != null && data.get((Object)title.getFigure()) == null) {
            data.put(title.getFigure(), this.createMinArea(data));
        }
    }

    private void fillImage(IImagePart image, ReferencedLayoutData data) {
        Rectangle r;
        IImage imageModel = image.getImageModel();
        String alignment = imageModel.getAlignment();
        IFigure imageFigure = image.getFigure();
        Dimension size = imageFigure.getPreferredSize();
        Point ref = data.getReference();
        Rectangle area = data.getClientArea();
        if (area == null) {
            r = TopicLayout.createBounds(ref, size);
        } else if ("left".equals(alignment)) {
            data.translate((size.width + this.spacing) / 2, 0);
            area = data.getClientArea();
            r = new Rectangle(area.x - size.width - this.spacing, ref.y - size.height / 2, size.width, size.height);
        } else if ("right".equals(alignment)) {
            data.translate(-(size.width + this.spacing) / 2, 0);
            area = data.getClientArea();
            r = new Rectangle(area.x + area.width + this.spacing, ref.y - size.height / 2, size.width, size.height);
        } else if ("bottom".equals(alignment)) {
            data.translate(0, -(size.height + this.spacing) / 2);
            area = data.getClientArea();
            r = new Rectangle(ref.x - size.width / 2, area.y + area.height + this.spacing, size.width, size.height);
        } else {
            data.translate(0, (size.height + this.spacing) / 2);
            area = data.getClientArea();
            r = new Rectangle(ref.x - size.width / 2, area.y - size.height - this.spacing, size.width, size.height);
        }
        data.put(imageFigure, r);
    }

    private void fillMarker(IMarkerPart marker, ReferencedLayoutData data) {
        Rectangle r;
        Point ref = data.getReference();
        IFigure fig = marker.getFigure();
        Dimension size = this.getChildPreferredSize(fig);
        Rectangle area = data.getClientArea();
        if (area == null) {
            r = TopicLayout.createBounds(ref, size);
        } else {
            int dx = (size.width + this.spacing) / 2;
            data.translate(dx, 0);
            area = data.getClientArea();
            r = new Rectangle(area.x - size.width - this.spacing, ref.y - size.height / 2, size.width, size.height);
        }
        data.put(fig, r);
    }

    private void fillIconTip(IIconTipPart iconTip, ReferencedLayoutData data) {
        Rectangle r;
        Point ref = data.getReference();
        IFigure fig = iconTip.getFigure();
        Dimension size = this.getChildPreferredSize(fig);
        Rectangle area = data.getClientArea();
        if (area == null) {
            r = TopicLayout.createBounds(ref, size);
        } else {
            int dx = (size.width + this.spacing) / 2;
            data.translate(-dx, 0);
            area = data.getClientArea();
            r = new Rectangle(area.right() + this.spacing, ref.y - size.height / 2, size.width, size.height);
        }
        data.put(fig, r);
    }

    private void fillNumbering(INumberingPart numbering, ReferencedLayoutData data) {
        Rectangle r;
        Point ref = data.getReference();
        IFigure fig = numbering.getFigure();
        Dimension size = this.getChildPreferredSize(fig);
        Rectangle area = data.getClientArea();
        if (area == null) {
            r = TopicLayout.createBounds(ref, size);
        } else {
            int dx = (size.width + this.spacing) / 2;
            data.translate(dx, 0);
            area = data.getClientArea();
            r = new Rectangle(area.x - size.width - this.spacing, ref.y - size.height / 2, size.width, size.height);
        }
        data.put(fig, r);
    }

    protected void fillText(ITitleTextPart text, ReferencedLayoutData data) {
        Point ref = data.getReference();
        IFigure textFigure = text.getFigure();
        Dimension size = this.getChildPreferredSize(textFigure);
        Rectangle r = TopicLayout.createBounds(ref, size);
        data.put(textFigure, r);
    }

    private Rectangle createMinArea(ReferencedLayoutData data) {
        return data.createInitBounds();
    }

    private boolean isMinimized(IFigure container) {
        if (container instanceof IMinimizable) {
            return ((IMinimizable)container).isMinimized();
        }
        return false;
    }

    private static Rectangle createBounds(Point ref, Dimension size) {
        return new Rectangle(ref.x - size.width / 2, ref.y - size.height / 2, size.width, size.height);
    }

    protected Dimension getChildPreferredSize(IFigure child) {
        if (child instanceof IRotatableFigure) {
            return ((IRotatableFigure)child).getNormalPreferredSize(-1, -1).toDraw2DDimension();
        }
        return child.getPreferredSize();
    }

    protected void layoutChild(IFigure child, Rectangle bounds, Point offset) {
        if (this.getRotationDegrees() != 0.0) {
            this.r().setOrigin((double)offset.x, (double)offset.y);
            bounds = this.r().t(new PrecisionRectangle(bounds)).toDraw2DRectangle();
        }
        super.layoutChild(child, bounds, offset);
    }

    public void invalidate() {
        super.invalidate();
        this.normalClientArea = null;
        this.normalRefDesc = null;
        this.normalSize = null;
        this.rotatedClientArea = null;
        this.rotatedRefDesc = null;
        this.rotatedSize = null;
    }

    public Insets getReferenceDescription(IFigure figure) {
        if (this.rotatedRefDesc == null) {
            PrecisionInsets ins = this.getNormalReferenceDescription(figure);
            if (this.getRotationDegrees() != 0.0) {
                ins = this.r().ti(ins);
            }
            this.rotatedRefDesc = ins.toDraw2DInsets();
        }
        return this.rotatedRefDesc;
    }

    public Rectangle getPreferredClientArea(IFigure container) {
        if (this.rotatedClientArea == null) {
            PrecisionRectangle rect = this.getNormalPreferredClientArea(container);
            if (this.getRotationDegrees() != 0.0) {
                Point ref = this.getLayoutData(container).getReference();
                this.r().setOrigin((double)ref.x, (double)ref.y);
                rect = this.r().tr(rect);
            }
            this.rotatedClientArea = rect.toDraw2DRectangle();
        }
        return this.rotatedClientArea;
    }

    public Dimension getPreferredSize(IFigure container, int wHint, int hHint) {
        if (this.rotatedSize == null) {
            PrecisionDimension d = this.getNormalPreferredSize(container, wHint, hHint);
            if (this.getRotationDegrees() != 0.0) {
                d = this.r().td(d);
            }
            this.rotatedSize = d.toDraw2DDimension();
        }
        return this.rotatedSize;
    }

    public PrecisionInsets getNormalReferenceDescription(IFigure figure) {
        if (this.normalRefDesc == null) {
            Point reference = this.getLayoutData(figure).getReference();
            PrecisionInsets description = this.getNormalPreferredClientArea(figure).getInsets((double)reference.x, (double)reference.y);
            this.normalRefDesc = description.add(figure.getInsets());
        }
        return this.normalRefDesc;
    }

    public PrecisionRectangle getNormalPreferredClientArea(IFigure container) {
        if (this.normalClientArea == null) {
            this.normalClientArea = new PrecisionRectangle(super.getPreferredClientArea(container));
        }
        return this.normalClientArea;
    }

    public PrecisionDimension getNormalPreferredSize(IFigure container, int wHint, int hHint) {
        if (this.normalSize == null) {
            Insets ins = container.getInsets();
            this.normalSize = this.getNormalPreferredClientArea(container).getSize().expand((double)ins.getWidth(), (double)ins.getHeight());
        }
        return this.normalSize;
    }

    public double getRotationDegrees() {
        return this.r().getAngle();
    }

    public void setRotationDegrees(double angle) {
        this.r().setAngle(angle);
        this.invalidate();
    }

    public PrecisionRotator r() {
        if (this.rotator == null) {
            this.rotator = new PrecisionRotator();
        }
        return this.rotator;
    }
}

