/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.figures;

import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.TextStyle;
import org.xmind.gef.draw2d.ITextFigure;
import org.xmind.gef.draw2d.ITitledFigure;
import org.xmind.gef.draw2d.RotatableWrapLabel;
import org.xmind.gef.draw2d.SizeableImageFigure;

public class LegendItemFigure
extends Figure
implements ITitledFigure {
    private static final int SPACING = 7;
    private SizeableImageFigure icon = new SizeableImageFigure();
    private ITextFigure caption;
    private Dimension cachedPrefSize = null;

    public LegendItemFigure() {
        this.icon.setConstrained(true);
        this.caption = new RotatableWrapLabel(0);
        this.add((IFigure)this.icon);
        this.add((IFigure)this.caption);
    }

    public ITextFigure getTitle() {
        return this.caption;
    }

    public void setTitle(ITextFigure title) {
    }

    public SizeableImageFigure getIcon() {
        return this.icon;
    }

    public ITextFigure getCaption() {
        return this.caption;
    }

    public Dimension getPreferredSize(int wHint, int hHint) {
        if (this.prefSize != null) {
            return this.prefSize;
        }
        if (this.cachedPrefSize != null) {
            return this.cachedPrefSize;
        }
        Dimension s1 = this.icon.getPreferredSize();
        Dimension s2 = this.caption.getPreferredSize();
        this.cachedPrefSize = new Dimension(s1.width + 7 + s2.width, Math.max(s1.height, s2.height));
        return this.cachedPrefSize;
    }

    public void invalidate() {
        super.invalidate();
        this.cachedPrefSize = null;
    }

    protected void layout() {
        Rectangle r = this.getBounds();
        Dimension s1 = this.icon.getPreferredSize();
        Dimension s2 = this.caption.getPreferredSize();
        this.icon.setBounds(new Rectangle(r.x, r.y + (r.height - s1.height) / 2, s1.width, s1.height));
        this.caption.setBounds(new Rectangle(r.x + s1.width + 7, r.y + (r.height - s2.height) / 2, s2.width, s2.height));
    }

    public int getLineSpacing() {
        return this.caption.getLineSpacing();
    }

    public TextStyle getStyle() {
        return this.caption.getStyle();
    }

    public String getText() {
        return this.caption.getText();
    }

    public int getTextAlignment() {
        return this.caption.getTextAlignment();
    }

    public void setLineSpacing(int spacing) {
        this.caption.setLineSpacing(spacing);
    }

    public void setStyle(TextStyle style) {
        this.caption.setStyle(style);
    }

    public void setText(String text) {
        this.caption.setText(text);
    }

    public void setTextAlignment(int align) {
        this.caption.setTextAlignment(align);
    }

    public Image getIconImage() {
        return this.icon.getImage();
    }

    public void setIconImage(Image image) {
        this.icon.setImage(image);
    }

    public void setFont(Font f) {
        super.setFont(f);
        this.caption.setFont(f);
    }

    public void setForegroundColor(Color fg) {
        super.setForegroundColor(fg);
        this.caption.setForegroundColor(fg);
    }

    public void setBackgroundColor(Color bg) {
        super.setBackgroundColor(bg);
        this.caption.setBackgroundColor(bg);
    }
}

