/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.editor;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.xmind.core.Core;
import org.xmind.core.IEncryptionHandler;
import org.xmind.core.IWorkbook;
import org.xmind.core.event.ICoreEventListener;
import org.xmind.core.event.ICoreEventRegistration;
import org.xmind.core.event.ICoreEventSource;
import org.xmind.core.event.ICoreEventSource2;
import org.xmind.core.event.ICoreEventSupport;
import org.xmind.core.io.DirectoryStorage;
import org.xmind.core.io.IStorage;
import org.xmind.core.marker.IMarkerSheet;
import org.xmind.gef.command.ICommandStack;
import org.xmind.ui.internal.MindMapUIPlugin;
import org.xmind.ui.internal.editor.IWorkbookLoader;
import org.xmind.ui.internal.editor.IWorkbookSaver;
import org.xmind.ui.mindmap.IWorkbookRef;
import org.xmind.ui.mindmap.MindMapUI;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WorkbookRef
implements IWorkbookRef,
IPropertyChangeListener,
IPartListener {
    private static final List<IEditorPart> EMPTY_LIST = Collections.emptyList();
    private static final String SUBDIR_WORKBOOK = "workbooks";
    private Object key;
    private List<IEditorPart> referrers;
    private IWorkbook workbook;
    private ICommandStack commandStack;
    private IWorkbookLoader workbookLoader;
    private IWorkbookSaver workbookSaver;
    private ICoreEventRegistration forceDirtyReg;
    private Set<IWorkbenchPage> hookedPages;

    public WorkbookRef() {
        MindMapUIPlugin.getDefault().getPreferenceStore().addPropertyChangeListener((IPropertyChangeListener)this);
    }

    public void setKey(Object key) {
        this.key = key;
    }

    public IWorkbookLoader getWorkbookLoader() {
        return this.workbookLoader;
    }

    public IWorkbookSaver getWorkbookSaver() {
        return this.workbookSaver;
    }

    public WorkbookRef setWorkbookLoader(IWorkbookLoader workbookLoader) {
        this.workbookLoader = workbookLoader;
        return this;
    }

    public WorkbookRef setWorkbookSaver(IWorkbookSaver workbookSaver) {
        this.workbookSaver = workbookSaver;
        return this;
    }

    public boolean isReady() {
        return this.workbook != null || this.workbookLoader != null;
    }

    public void setWorkbook(IWorkbook workbook) {
        IMarkerSheet markerSheet;
        if (workbook == this.workbook) {
            return;
        }
        this.workbook = workbook;
        if (workbook != null && (markerSheet = workbook.getMarkerSheet()) != null) {
            markerSheet.setParentSheet(MindMapUI.getResourceManager().getUserMarkerSheet());
        }
    }

    public void setCommandStack(ICommandStack commandStack) {
        this.commandStack = commandStack;
        if (commandStack != null) {
            commandStack.setUndoLimit(Math.max(MindMapUIPlugin.getDefault().getPreferenceStore().getInt("undoLimit"), 1));
        }
    }

    public Object getKey() {
        return this.key;
    }

    @Override
    public ICommandStack getCommandStack() {
        return this.commandStack;
    }

    @Override
    public IWorkbook getWorkbook() {
        return this.workbook;
    }

    @Override
    public void setSelection(ISelection selection, boolean reveal, boolean forceFocus) {
        IEditorPart editor;
        if (this.referrers != null && !this.referrers.isEmpty() && (editor = this.referrers.get(0)) != null) {
            ISelectionProvider selectionProvider = editor.getSite().getSelectionProvider();
            if (selectionProvider != null) {
                selectionProvider.setSelection(selection);
            }
            if (forceFocus) {
                editor.getSite().getPage().activate((IWorkbenchPart)editor);
                Shell shell = editor.getSite().getShell();
                if (shell != null && !shell.isDisposed()) {
                    shell.setActive();
                }
            } else if (reveal) {
                editor.getSite().getPage().bringToTop((IWorkbenchPart)editor);
            }
        }
    }

    public void refresh() {
    }

    public Object getAdapter(Class adapter) {
        if (adapter == IWorkbook.class) {
            return this.getWorkbook();
        }
        if (adapter == ICommandStack.class) {
            return this.getCommandStack();
        }
        return null;
    }

    public void dispose(boolean closeWorkbook) {
        MindMapUIPlugin.getDefault().getPreferenceStore().removePropertyChangeListener((IPropertyChangeListener)this);
        if (this.commandStack != null) {
            this.commandStack.dispose();
            this.commandStack = null;
        }
        this.key = null;
        this.referrers = null;
        if (this.workbook != null && closeWorkbook) {
            this.closeWorkbook(this.workbook);
        }
        this.workbook = null;
    }

    private void closeWorkbook(IWorkbook workbook) {
        IStorage storage;
        ICoreEventSupport support = (ICoreEventSupport)workbook.getAdapter(ICoreEventSupport.class);
        if (support != null) {
            support.dispatchTargetChange((ICoreEventSource)workbook, "workbookClose", (Object)this);
        }
        if ((storage = workbook.getTempStorage()) != null) {
            storage.clear();
        }
    }

    public void addReferrer(IEditorPart referrer) {
        if (this.referrers == null) {
            this.referrers = new ArrayList<IEditorPart>(2);
        }
        this.referrers.add(0, referrer);
        this.addPartListener(referrer);
    }

    private void addPartListener(IEditorPart editor) {
        IWorkbenchPage page = editor.getSite().getPage();
        if (this.hookedPages == null) {
            this.hookedPages = new HashSet<IWorkbenchPage>(2);
        }
        if (!this.hookedPages.contains(page)) {
            this.hookedPages.add(page);
            page.addPartListener((IPartListener)this);
        }
    }

    public List<IEditorPart> getReferrers() {
        return this.referrers == null ? EMPTY_LIST : this.referrers;
    }

    public int getNumReferrers() {
        return this.referrers == null ? 0 : this.referrers.size();
    }

    public boolean isReferred() {
        return this.referrers != null && !this.referrers.isEmpty();
    }

    public void removeReferrer(IEditorPart referrer) {
        if (this.referrers == null) {
            return;
        }
        this.referrers.remove(referrer);
        this.removePartListener(referrer);
        if (this.referrers.isEmpty()) {
            this.referrers = null;
        }
    }

    private void removePartListener(IEditorPart editor) {
        if (this.hookedPages == null) {
            return;
        }
        IWorkbenchPage page = editor.getSite().getPage();
        if (this.hookedPages.remove(page)) {
            page.removePartListener((IPartListener)this);
        }
        if (this.hookedPages.isEmpty()) {
            this.hookedPages = null;
        }
    }

    @Override
    public List<IEditorPart> getOpenedEditors() {
        if (this.referrers == null) {
            return EMPTY_LIST;
        }
        return this.referrers;
    }

    @Override
    public void forceDirty() {
        if (this.forceDirtyReg == null || !this.forceDirtyReg.isValid()) {
            this.forceDirtyReg = this.workbook instanceof ICoreEventSource2 ? ((ICoreEventSource2)this.workbook).registerOnceCoreEventListener("workbookPreSaveOnce", ICoreEventListener.NULL) : null;
        }
    }

    @Override
    public boolean isForceDirty() {
        return this.forceDirtyReg != null && this.forceDirtyReg.isValid();
    }

    public void loadWorkbook(IEncryptionHandler encryptionHandler, IProgressMonitor monitor) throws IOException, org.xmind.core.CoreException, CoreException {
        this.loadWorkbook(this.createStorage(), encryptionHandler, monitor);
    }

    public void loadWorkbook(IStorage storage, IEncryptionHandler encryptionHandler, IProgressMonitor monitor) throws IOException, org.xmind.core.CoreException, CoreException {
        if (this.workbook != null) {
            return;
        }
        if (this.workbookLoader == null) {
            throw new CoreException((IStatus)new Status(4, "org.xmind.ui.mindmap", "No workbook loader is set."));
        }
        this.setWorkbook(this.workbookLoader.loadWorkbook(storage, encryptionHandler, monitor));
    }

    IStorage createStorage() {
        String tempFile = String.valueOf(Core.getIdFactory().createId()) + ".xmind.temp";
        String tempLocation = Core.getWorkspace().getTempDir("workbooks/" + tempFile);
        File tempDir = new File(tempLocation);
        DirectoryStorage storage = new DirectoryStorage(tempDir);
        return storage;
    }

    public boolean isSaveable() {
        return this.workbook != null && this.workbookSaver != null;
    }

    public void saveWorkbook(IProgressMonitor monitor) throws IOException, org.xmind.core.CoreException, CoreException {
        if (this.workbook == null) {
            throw new CoreException((IStatus)new Status(4, "org.xmind.ui.mindmap", "No workbook to save."));
        }
        if (this.workbookSaver == null) {
            throw new CoreException((IStatus)new Status(4, "org.xmind.ui.mindmap", "No workbook saver is set."));
        }
        this.workbookSaver.save(monitor, this.workbook);
    }

    public void propertyChange(PropertyChangeEvent event) {
        if (this.commandStack != null && "undoLimit".equals(event.getProperty())) {
            this.commandStack.setUndoLimit(Math.max((Integer)event.getNewValue(), 1));
        }
    }

    public void partActivated(IWorkbenchPart part) {
        if (this.referrers != null && this.referrers.remove(part)) {
            this.referrers.add(0, (IEditorPart)part);
        }
    }

    public void partBroughtToTop(IWorkbenchPart part) {
    }

    public void partClosed(IWorkbenchPart part) {
    }

    public void partDeactivated(IWorkbenchPart part) {
    }

    public void partOpened(IWorkbenchPart part) {
    }
}

