/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.editor;

import java.io.IOException;
import java.io.InputStream;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.xmind.core.Core;
import org.xmind.core.IEncryptionHandler;
import org.xmind.core.IWorkbook;
import org.xmind.core.io.IStorage;
import org.xmind.ui.internal.WorkbookFactory;
import org.xmind.ui.internal.editor.IWorkbookLoader;

public class TemplatedWorkbookLoader
implements IWorkbookLoader {
    private InputStream templateStream;

    public TemplatedWorkbookLoader(InputStream templateStream) {
        this.templateStream = templateStream;
    }

    public IWorkbook loadWorkbook(IStorage storage, IEncryptionHandler encryptionHandler, IProgressMonitor monitor) throws IOException, org.xmind.core.CoreException, CoreException {
        if (this.templateStream == null) {
            return WorkbookFactory.createEmptyWorkbook();
        }
        try {
            IWorkbook iWorkbook = Core.getWorkbookBuilder().loadFromStream(this.templateStream, storage, encryptionHandler);
            return iWorkbook;
        }
        finally {
            this.templateStream = null;
        }
    }
}

