/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.editor;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.xmind.core.Core;
import org.xmind.core.util.FileUtils;

public class ResourceFileOutputStream
extends FilterOutputStream {
    private IFile file;
    private String tempFile = ResourceFileOutputStream.createTempFile();
    private IProgressMonitor monitor;

    public ResourceFileOutputStream(IFile file, IProgressMonitor monitor) throws IOException {
        super(null);
        this.file = file;
        this.out = new FileOutputStream(this.tempFile);
        this.monitor = monitor;
    }

    public void write(byte[] b) throws IOException {
        this.out.write(b);
    }

    public void write(byte[] b, int off, int len) throws IOException {
        this.out.write(b, off, len);
    }

    public void write(int b) throws IOException {
        this.out.write(b);
    }

    public void close() throws IOException {
        try {
            super.close();
            try {
                this.transferContents();
            }
            catch (CoreException e) {
                IOException ex = new IOException(e.getMessage());
                ex.initCause(e);
                throw ex;
            }
        }
        finally {
            this.deleteTempFile();
        }
    }

    private void transferContents() throws IOException, CoreException {
        this.file.setContents((InputStream)new FileInputStream(this.tempFile), 2, this.monitor);
    }

    private void deleteTempFile() {
        FileUtils.delete((File)new File(this.tempFile));
    }

    private static String createTempFile() throws IOException {
        String path = Core.getWorkspace().getTempFile(Core.getIdFactory().createId());
        return path;
    }
}

