/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.editor;

import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Layer;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.IColorProvider;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.contexts.IContextActivation;
import org.eclipse.ui.contexts.IContextService;
import org.xmind.core.ISheet;
import org.xmind.core.event.CoreEvent;
import org.xmind.core.event.CoreEventRegister;
import org.xmind.core.event.ICoreEventListener;
import org.xmind.core.event.ICoreEventRegister;
import org.xmind.core.event.ICoreEventSource;
import org.xmind.gef.EditDomain;
import org.xmind.gef.GEF;
import org.xmind.gef.IEditDomainListener;
import org.xmind.gef.IGraphicalViewer;
import org.xmind.gef.ISelectionStack;
import org.xmind.gef.IViewer;
import org.xmind.gef.SelectionStack;
import org.xmind.gef.draw2d.IRelayeredPane;
import org.xmind.gef.draw2d.ISkylightLayer;
import org.xmind.gef.service.FeedbackService;
import org.xmind.gef.service.IAnimationService;
import org.xmind.gef.service.IFeedbackService;
import org.xmind.gef.service.IImageRegistryService;
import org.xmind.gef.service.IRevealService;
import org.xmind.gef.service.IShadowService;
import org.xmind.gef.service.IViewerService;
import org.xmind.gef.service.ImageRegistryService;
import org.xmind.gef.service.ShadowService;
import org.xmind.gef.tool.ITool;
import org.xmind.gef.ui.actions.ActionRegistry;
import org.xmind.gef.ui.actions.CopyAction;
import org.xmind.gef.ui.actions.IActionRegistry;
import org.xmind.gef.ui.actions.ISelectionAction;
import org.xmind.gef.ui.actions.PasteAction;
import org.xmind.gef.ui.actions.RequestAction;
import org.xmind.gef.ui.actions.SelectAllAction;
import org.xmind.gef.ui.editor.GraphicalEditorPage;
import org.xmind.gef.ui.editor.IGraphicalEditor;
import org.xmind.gef.ui.editor.IGraphicalEditorPage;
import org.xmind.gef.ui.editor.IPanelContributor;
import org.xmind.gef.util.Properties;
import org.xmind.ui.actions.MindMapActionFactory;
import org.xmind.ui.animation.AnimationService;
import org.xmind.ui.internal.MindMapUIPlugin;
import org.xmind.ui.internal.TopicContextService;
import org.xmind.ui.internal.actions.ActualSizeAction;
import org.xmind.ui.internal.actions.AddMarkerAction;
import org.xmind.ui.internal.actions.AlignmentRequestAction;
import org.xmind.ui.internal.actions.CancelHyperlinkAction;
import org.xmind.ui.internal.actions.CollapseAction;
import org.xmind.ui.internal.actions.CollapseAllAction;
import org.xmind.ui.internal.actions.CreateBoundaryAction;
import org.xmind.ui.internal.actions.CreateRelationshipAction;
import org.xmind.ui.internal.actions.CreateSummaryAction;
import org.xmind.ui.internal.actions.CutAction;
import org.xmind.ui.internal.actions.DeleteAction;
import org.xmind.ui.internal.actions.DrillDownAction;
import org.xmind.ui.internal.actions.DrillUpAction;
import org.xmind.ui.internal.actions.EditLabelAction;
import org.xmind.ui.internal.actions.EditNotesAction;
import org.xmind.ui.internal.actions.EditTitleAction;
import org.xmind.ui.internal.actions.ExtendAction;
import org.xmind.ui.internal.actions.ExtendAllAction;
import org.xmind.ui.internal.actions.FinishAction;
import org.xmind.ui.internal.actions.InsertAttachmentAction;
import org.xmind.ui.internal.actions.InsertFloatingTopicAction;
import org.xmind.ui.internal.actions.InsertImageAction;
import org.xmind.ui.internal.actions.InsertParentTopicAction;
import org.xmind.ui.internal.actions.InsertSheetAction;
import org.xmind.ui.internal.actions.InsertSubtopicAction;
import org.xmind.ui.internal.actions.InsertTopicAction;
import org.xmind.ui.internal.actions.InsertTopicBeforeAction;
import org.xmind.ui.internal.actions.ModifyHyperlinkAction;
import org.xmind.ui.internal.actions.OpenHyperlinkAction;
import org.xmind.ui.internal.actions.PrintMapAction;
import org.xmind.ui.internal.actions.ResetPositionAction;
import org.xmind.ui.internal.actions.SaveAttachmentAsAction;
import org.xmind.ui.internal.actions.SelectBrothersAction;
import org.xmind.ui.internal.actions.SelectChildrenAction;
import org.xmind.ui.internal.actions.TileAction;
import org.xmind.ui.internal.actions.TraverseAction;
import org.xmind.ui.internal.actions.ZoomInAction;
import org.xmind.ui.internal.actions.ZoomOutAction;
import org.xmind.ui.internal.editor.MindMapEditorPagePanelContributor;
import org.xmind.ui.internal.layers.SkylightLayer;
import org.xmind.ui.internal.mindmap.DrillDownTraceService;
import org.xmind.ui.internal.mindmap.HighlightService;
import org.xmind.ui.internal.mindmap.MindMapRevealService;
import org.xmind.ui.internal.mindmap.MindMapTopicContextService;
import org.xmind.ui.internal.mindmap.MindMapViewer;
import org.xmind.ui.internal.mindmap.UndoRedoTipsService;
import org.xmind.ui.mindmap.IBranchPart;
import org.xmind.ui.mindmap.IDrillDownTraceService;
import org.xmind.ui.mindmap.IHighlightService;
import org.xmind.ui.mindmap.IMindMap;
import org.xmind.ui.mindmap.IMindMapViewer;
import org.xmind.ui.mindmap.ISheetPart;
import org.xmind.ui.mindmap.MindMap;
import org.xmind.ui.mindmap.MindMapUI;
import org.xmind.ui.resources.ColorUtils;
import org.xmind.ui.util.MindMapUtils;

public class MindMapEditorPage
extends GraphicalEditorPage
implements ICoreEventListener,
IColorProvider,
IEditDomainListener,
IPropertyChangeListener,
FocusListener {
    private ISelectionStack selectionStack = null;
    private ICoreEventRegister eventRegister = null;
    private IContextActivation contextActivation = null;
    private IContextService contextService = null;
    private IPreferenceStore prefStore = null;
    private IShadowService shadowService = null;
    private UndoRedoTipsService undoService = null;

    public void init(IGraphicalEditor parent, Object input) {
        super.init(parent, input);
        this.setPanelContributor((IPanelContributor)new MindMapEditorPagePanelContributor());
    }

    protected IGraphicalViewer createViewer() {
        return new MindMapViewer();
    }

    protected void createViewerControl(IGraphicalViewer viewer, Composite parent) {
        Control control = ((MindMapViewer)viewer).createControl(parent);
        control.addFocusListener((FocusListener)this);
    }

    public void updatePageTitle() {
        ISheet sheet = this.getCastedInput();
        String name = sheet.hasTitle() ? sheet.getTitleText() : sheet.getRootTopic().getTitleText();
        this.setPageTitle(MindMapUtils.trimSingleLine(name));
    }

    protected void installModelListeners(Object input) {
        super.installModelListeners(input);
        if (input instanceof ICoreEventSource) {
            this.eventRegister = new CoreEventRegister((ICoreEventSource)input, (ICoreEventListener)this);
            this.eventRegister.register("titleText");
        }
        this.prefStore = MindMapUIPlugin.getDefault().getPreferenceStore();
        if (this.prefStore != null) {
            this.prefStore.addPropertyChangeListener((IPropertyChangeListener)this);
        }
    }

    protected void uninstallModelListeners(Object input) {
        if (this.prefStore != null) {
            this.prefStore.removePropertyChangeListener((IPropertyChangeListener)this);
            this.prefStore = null;
        }
        if (this.eventRegister != null) {
            this.eventRegister.unregisterAll();
            this.eventRegister = null;
        }
        super.uninstallModelListeners(input);
    }

    public void propertyChange(PropertyChangeEvent event) {
        if ("overlapsAllowed".equals(event.getProperty())) {
            ISheetPart sheet = ((IMindMapViewer)this.getViewer()).getSheetPart();
            if (sheet != null) {
                sheet.getFigure().revalidate();
            }
        } else if ("shadowEnabled".equals(event.getProperty())) {
            if (this.shadowService != null) {
                Object value = event.getNewValue();
                if (value instanceof String) {
                    value = Boolean.parseBoolean((String)value);
                }
                if (value instanceof Boolean) {
                    this.shadowService.setActive(((Boolean)value).booleanValue());
                } else {
                    this.shadowService.setActive(false);
                }
            }
        } else if ("gradientColor".equals(event.getProperty())) {
            IBranchPart part = ((IMindMapViewer)this.getViewer()).getCentralBranchPart();
            if (part != null) {
                part.treeUpdate(false);
            }
        } else if ("undoRedoTipsEnabled".equals(event.getProperty())) {
            if (this.undoService != null) {
                Object value = event.getNewValue();
                if (value instanceof String) {
                    value = Boolean.parseBoolean((String)value);
                }
                if (value instanceof Boolean) {
                    this.undoService.setActive((Boolean)value);
                } else {
                    this.undoService.setActive(false);
                }
            }
        } else if ("undoRedoTipsFadeDelay".equals(event.getProperty()) && this.undoService != null) {
            Object value = event.getNewValue();
            if (value instanceof String) {
                value = Integer.parseInt((String)value);
            }
            if (value instanceof Integer) {
                this.undoService.setDuration((Integer)value);
            } else {
                this.undoService.setDuration(800);
            }
        }
    }

    public ISheet getCastedInput() {
        return (ISheet)super.getInput();
    }

    protected Object createViewerInput() {
        return new MindMap(this.getCastedInput());
    }

    protected void initViewer(IGraphicalViewer viewer) {
        super.initViewer(viewer);
        viewer.getZoomManager().setConstraints(0.1, 5.0);
        Properties properties = viewer.getProperties();
        properties.set("centered", (Object)Boolean.TRUE);
        properties.set("cornered", (Object)Boolean.TRUE);
        properties.set("actions", (Object)new ActionRegistry(this.getActionRegistry()));
        properties.set("margin", (Object)500);
        this.initViewerServices((MindMapViewer)viewer);
    }

    protected void configureViewer(IGraphicalViewer viewer) {
        super.configureViewer(viewer);
        if (this.selectionStack == null) {
            this.selectionStack = this.createSelectionStack();
        }
        this.selectionStack.setSelectionProvider((ISelectionProvider)this.getViewer());
        this.selectionStack.setCommandStack(this.getEditDomain().getCommandStack());
        this.getEditDomain().handleRequest("select central", (IViewer)viewer);
    }

    protected ISelectionStack createSelectionStack() {
        return new SelectionStack();
    }

    protected void initViewerServices(MindMapViewer viewer) {
        Layer undoLayer;
        Layer shadowLayer;
        Layer feedbackLayer;
        ImageRegistryService imageCacheService = new ImageRegistryService((IViewer)viewer);
        viewer.installService(IImageRegistryService.class, (IViewerService)imageCacheService);
        imageCacheService.setActive(true);
        MindMapRevealService revealService = new MindMapRevealService(viewer);
        viewer.installService(IRevealService.class, (IViewerService)revealService);
        revealService.setActive(true);
        AnimationService animationService = new AnimationService((IGraphicalViewer)viewer);
        animationService.setPlaybackProvider(MindMapUI.getPlaybackProvider());
        viewer.installService(IAnimationService.class, (IViewerService)animationService);
        animationService.setActive(true);
        Layer coverLayer = viewer.getLayer(MindMapUI.LAYER_COVER);
        Layer skylightLayer = viewer.getLayer(MindMapUI.LAYER_SKYLIGHT);
        if (coverLayer instanceof IRelayeredPane || skylightLayer instanceof ISkylightLayer) {
            HighlightService highlightService = new HighlightService(viewer, false);
            if (coverLayer instanceof IRelayeredPane) {
                highlightService.setRelayeredPane((IRelayeredPane)coverLayer);
            }
            if (skylightLayer instanceof ISkylightLayer) {
                highlightService.setHighlightLayer((SkylightLayer)skylightLayer);
            }
            viewer.installService(IHighlightService.class, highlightService);
            highlightService.setActive(true);
        }
        if ((feedbackLayer = viewer.getLayer(GEF.LAYER_FEEDBACK)) != null) {
            FeedbackService feedbackService = new FeedbackService((IGraphicalViewer)viewer);
            viewer.installService(IFeedbackService.class, (IViewerService)feedbackService);
            feedbackService.setLayer((IFigure)feedbackLayer);
            feedbackService.setSelectionColorProvider((IColorProvider)this);
            feedbackService.setSelectionLineWidth(4);
            feedbackService.setSelectionCorner(5);
            feedbackService.setActive(true);
        }
        DrillDownTraceService traceService = new DrillDownTraceService(viewer);
        viewer.installService(IDrillDownTraceService.class, traceService);
        traceService.setActive(true);
        IAction action = this.getActionRegistry().getAction(MindMapActionFactory.DRILL_UP.getId());
        if (action instanceof DrillUpAction) {
            ((DrillUpAction)action).setTraceService(traceService);
        }
        if ((shadowLayer = viewer.getLayer(GEF.LAYER_SHADOW)) != null) {
            this.shadowService = new ShadowService((IGraphicalViewer)viewer);
            viewer.installService(IShadowService.class, (IViewerService)this.shadowService);
            this.shadowService.setLayer((IFigure)shadowLayer);
            this.shadowService.setActive(this.prefStore != null && this.prefStore.getBoolean("shadowEnabled"));
        }
        if ((undoLayer = viewer.getLayer(MindMapUI.LAYER_UNDO)) != null) {
            this.undoService = new UndoRedoTipsService(viewer);
            viewer.installService(UndoRedoTipsService.class, (IViewerService)this.undoService);
            this.undoService.setLayer((IFigure)undoLayer);
            this.undoService.setActive(true);
        }
        MindMapTopicContextService contextService = new MindMapTopicContextService((IGraphicalEditorPage)this, (IViewer)viewer);
        viewer.installService(TopicContextService.class, (IViewerService)contextService);
        contextService.setActive(true);
    }

    public void setEditDomain(EditDomain domain) {
        if (this.getEditDomain() != null) {
            this.getEditDomain().removeEditDomainListener((IEditDomainListener)this);
            this.deactivateContext();
        }
        super.setEditDomain(domain);
        if (this.getEditDomain() != null) {
            this.getEditDomain().addEditDomainListener((IEditDomainListener)this);
            this.changeContext(this.getEditDomain().getActiveTool());
        }
    }

    public void activeToolChanged(ITool oldTool, ITool newTool) {
        this.changeContext(newTool);
    }

    public void setActive(boolean active) {
        boolean oldActive = this.isActive();
        super.setActive(active);
        boolean newActive = this.isActive();
        if (oldActive && !newActive) {
            if (this.getEditDomain() != null) {
                this.getEditDomain().handleRequest("cancel", (IViewer)this.getViewer());
            }
            this.deactivateContext();
        } else if (!oldActive && newActive && this.getEditDomain() != null) {
            this.changeContext(this.getEditDomain().getActiveTool());
        }
    }

    private void changeContext(ITool newTool) {
        if (!this.isActive()) {
            return;
        }
        this.deactivateContext();
        this.activateContext(newTool == null ? null : newTool.getContextId());
    }

    private void activateContext(String contextId) {
        if (contextId == null) {
            return;
        }
        this.contextService = (IContextService)this.getParentEditor().getSite().getService(IContextService.class);
        if (this.contextService != null) {
            this.contextActivation = this.contextService.activateContext(contextId);
        }
    }

    private void deactivateContext() {
        if (this.contextService != null && this.contextActivation != null) {
            this.contextService.deactivateContext(this.contextActivation);
        }
        this.contextService = null;
        this.contextActivation = null;
    }

    public void focusGained(FocusEvent e) {
        this.changeContext(this.getEditDomain().getActiveTool());
    }

    public void focusLost(FocusEvent e) {
        this.changeContext(null);
    }

    protected void initPageActions(IActionRegistry actionRegistry) {
        super.initPageActions(actionRegistry);
        InsertTopicAction insertTopicAction = new InsertTopicAction((IGraphicalEditorPage)this);
        actionRegistry.addAction((IAction)insertTopicAction);
        this.addSelectionAction(insertTopicAction);
        InsertSubtopicAction insertSubtopicAction = new InsertSubtopicAction((IGraphicalEditorPage)this);
        actionRegistry.addAction((IAction)insertSubtopicAction);
        this.addSelectionAction(insertSubtopicAction);
        InsertTopicBeforeAction insertTopicBeforeAction = new InsertTopicBeforeAction((IGraphicalEditorPage)this);
        actionRegistry.addAction((IAction)insertTopicBeforeAction);
        this.addSelectionAction(insertTopicBeforeAction);
        InsertParentTopicAction insertParentTopicAction = new InsertParentTopicAction((IGraphicalEditorPage)this);
        actionRegistry.addAction((IAction)insertParentTopicAction);
        this.addSelectionAction(insertParentTopicAction);
        InsertSheetAction insertSheetAction = new InsertSheetAction((IGraphicalEditorPage)this);
        actionRegistry.addAction((IAction)insertSheetAction);
        this.addSelectionAction(insertSheetAction);
        ExtendAction extendAction = new ExtendAction((IGraphicalEditorPage)this);
        actionRegistry.addAction((IAction)extendAction);
        this.addSelectionAction(extendAction);
        CollapseAction collapseAction = new CollapseAction((IGraphicalEditorPage)this);
        actionRegistry.addAction((IAction)collapseAction);
        this.addSelectionAction(collapseAction);
        ExtendAllAction extendAllAction = new ExtendAllAction((IGraphicalEditorPage)this);
        actionRegistry.addAction((IAction)extendAllAction);
        this.addSelectionAction(extendAllAction);
        CollapseAllAction collapseAllAction = new CollapseAllAction((IGraphicalEditorPage)this);
        actionRegistry.addAction((IAction)collapseAllAction);
        this.addSelectionAction(collapseAllAction);
        ModifyHyperlinkAction modifyHyperlinkAction = new ModifyHyperlinkAction((IGraphicalEditorPage)this);
        actionRegistry.addAction((IAction)modifyHyperlinkAction);
        this.addSelectionAction(modifyHyperlinkAction);
        OpenHyperlinkAction openHyperlinkAction = new OpenHyperlinkAction((IGraphicalEditorPage)this);
        actionRegistry.addAction((IAction)openHyperlinkAction);
        this.addSelectionAction(openHyperlinkAction);
        InsertAttachmentAction insertAttachmentAction = new InsertAttachmentAction((IGraphicalEditorPage)this);
        actionRegistry.addAction((IAction)insertAttachmentAction);
        this.addSelectionAction(insertAttachmentAction);
        InsertImageAction insertImageAction = new InsertImageAction((IGraphicalEditorPage)this);
        actionRegistry.addAction((IAction)insertImageAction);
        this.addSelectionAction(insertImageAction);
        DeleteAction deleteAction = new DeleteAction((IGraphicalEditorPage)this);
        actionRegistry.addAction((IAction)deleteAction);
        this.addSelectionAction((ISelectionAction)deleteAction);
        CreateRelationshipAction createRelationshipAction = new CreateRelationshipAction((IGraphicalEditorPage)this);
        actionRegistry.addAction((IAction)createRelationshipAction);
        CopyAction copyAction = new CopyAction((IGraphicalEditorPage)this);
        actionRegistry.addAction((IAction)copyAction);
        CutAction cutAction = new CutAction((IGraphicalEditorPage)this);
        actionRegistry.addAction((IAction)cutAction);
        this.addSelectionAction((ISelectionAction)cutAction);
        PasteAction pasteAction = new PasteAction((IGraphicalEditorPage)this);
        actionRegistry.addAction((IAction)pasteAction);
        this.addSelectionAction((ISelectionAction)pasteAction);
        ZoomInAction zoomInAction = new ZoomInAction((IGraphicalEditorPage)this);
        actionRegistry.addAction((IAction)zoomInAction);
        ZoomOutAction zoomOutAction = new ZoomOutAction((IGraphicalEditorPage)this);
        actionRegistry.addAction((IAction)zoomOutAction);
        ActualSizeAction actualSizeAction = new ActualSizeAction((IGraphicalEditorPage)this);
        actionRegistry.addAction((IAction)actualSizeAction);
        SelectAllAction selectAllAction = new SelectAllAction((IGraphicalEditorPage)this);
        actionRegistry.addAction((IAction)selectAllAction);
        SelectBrothersAction selectBrothersAction = new SelectBrothersAction((IGraphicalEditorPage)this);
        actionRegistry.addAction((IAction)selectBrothersAction);
        this.addSelectionAction(selectBrothersAction);
        SelectChildrenAction selectChildrenAction = new SelectChildrenAction((IGraphicalEditorPage)this);
        actionRegistry.addAction((IAction)selectChildrenAction);
        this.addSelectionAction(selectChildrenAction);
        DrillDownAction drillDownAction = new DrillDownAction((IGraphicalEditorPage)this);
        actionRegistry.addAction((IAction)drillDownAction);
        this.addSelectionAction(drillDownAction);
        DrillUpAction drillUpAction = new DrillUpAction((IGraphicalEditorPage)this);
        actionRegistry.addAction((IAction)drillUpAction);
        CreateBoundaryAction createBoundaryAction = new CreateBoundaryAction((IGraphicalEditorPage)this);
        actionRegistry.addAction((IAction)createBoundaryAction);
        CreateSummaryAction createSummaryAction = new CreateSummaryAction((IGraphicalEditorPage)this);
        actionRegistry.addAction((IAction)createSummaryAction);
        EditTitleAction editTitleAction = new EditTitleAction((IGraphicalEditorPage)this);
        actionRegistry.addAction((IAction)editTitleAction);
        this.addSelectionAction(editTitleAction);
        EditLabelAction editLabelAction = new EditLabelAction((IGraphicalEditorPage)this);
        actionRegistry.addAction((IAction)editLabelAction);
        this.addSelectionAction(editLabelAction);
        EditNotesAction editNotesAction = new EditNotesAction((IGraphicalEditorPage)this);
        actionRegistry.addAction((IAction)editNotesAction);
        this.addSelectionAction(editNotesAction);
        AddMarkerAction addMarkerAction = new AddMarkerAction("org.xmind.ui.addMarker", (IGraphicalEditorPage)this);
        actionRegistry.addAction((IAction)addMarkerAction);
        this.addSelectionAction(addMarkerAction);
        TraverseAction raverseAction = new TraverseAction((IGraphicalEditorPage)this);
        actionRegistry.addAction((IAction)raverseAction);
        this.addSelectionAction(raverseAction);
        FinishAction finishAction = new FinishAction(MindMapActionFactory.FINISH.getId(), (IGraphicalEditorPage)this);
        actionRegistry.addAction((IAction)finishAction);
        TileAction tileAction = new TileAction((IGraphicalEditorPage)this);
        actionRegistry.addAction((IAction)tileAction);
        ResetPositionAction resetPositionAction = new ResetPositionAction((IGraphicalEditorPage)this);
        actionRegistry.addAction((IAction)resetPositionAction);
        this.addSelectionAction(resetPositionAction);
        actionRegistry.addAction((IAction)new RequestAction(MindMapActionFactory.MOVE_UP.getId(), (IGraphicalEditorPage)this, "move up"));
        actionRegistry.addAction((IAction)new RequestAction(MindMapActionFactory.MOVE_DOWN.getId(), (IGraphicalEditorPage)this, "move down"));
        actionRegistry.addAction((IAction)new RequestAction(MindMapActionFactory.MOVE_LEFT.getId(), (IGraphicalEditorPage)this, "move left"));
        actionRegistry.addAction((IAction)new RequestAction(MindMapActionFactory.MOVE_RIGHT.getId(), (IGraphicalEditorPage)this, "move right"));
        actionRegistry.addAction((IAction)new RequestAction(MindMapActionFactory.GO_HOME.getId(), (IGraphicalEditorPage)this, "select central"));
        actionRegistry.addAction((IAction)new InsertFloatingTopicAction(MindMapActionFactory.INSERT_FLOATING_TOPIC.getId(), (IGraphicalEditorPage)this));
        actionRegistry.addAction((IAction)new InsertFloatingTopicAction(MindMapActionFactory.INSERT_FLOATING_CENTRAL_TOPIC.getId(), (IGraphicalEditorPage)this));
        CancelHyperlinkAction cancelHyperlinkAction = new CancelHyperlinkAction((IGraphicalEditorPage)this);
        actionRegistry.addAction((IAction)cancelHyperlinkAction);
        this.addSelectionAction(cancelHyperlinkAction);
        SaveAttachmentAsAction saveAttachmentAsAction = new SaveAttachmentAsAction((IGraphicalEditorPage)this);
        actionRegistry.addAction((IAction)saveAttachmentAsAction);
        this.addSelectionAction(saveAttachmentAsAction);
        this.addAlignmentAction(1, actionRegistry);
        this.addAlignmentAction(2, actionRegistry);
        this.addAlignmentAction(4, actionRegistry);
        this.addAlignmentAction(8, actionRegistry);
        this.addAlignmentAction(16, actionRegistry);
        this.addAlignmentAction(32, actionRegistry);
        PrintMapAction printMapAction = new PrintMapAction((IGraphicalEditorPage)this);
        actionRegistry.addAction((IAction)printMapAction);
    }

    private void addAlignmentAction(int alignment, IActionRegistry actionRegistry) {
        AlignmentRequestAction action = new AlignmentRequestAction((IGraphicalEditorPage)this, alignment);
        actionRegistry.addAction((IAction)action);
        this.addSelectionAction(action);
    }

    public void dispose() {
        if (this.selectionStack != null) {
            this.selectionStack.setCommandStack(null);
            this.selectionStack.setSelectionProvider(null);
            this.selectionStack = null;
        }
        this.deactivateContext();
        super.dispose();
    }

    public Object getAdapter(Class adapter) {
        if (adapter == ISheet.class) {
            return this.getCastedInput();
        }
        if (adapter == IMindMap.class) {
            return this.getViewer().getInput();
        }
        return super.getAdapter(adapter);
    }

    public void handleCoreEvent(CoreEvent event) {
        String type = event.getType();
        if ("titleText".equals(type)) {
            this.updatePageTitle();
        }
    }

    public Color getBackground(Object element) {
        if (IFeedbackService.PreselectionColor.equals(element) || IFeedbackService.DisabledPreselectionColor.equals(element)) {
            return ColorUtils.getColor((String)"#80c0d0");
        }
        return null;
    }

    public Color getForeground(Object element) {
        if (IFeedbackService.FocusColor.equals(element)) {
            return ColorUtils.getColor((String)"#1020f0");
        }
        if (IFeedbackService.SelectionColor.equals(element)) {
            return ColorUtils.getColor((String)"#1040a8");
        }
        if (IFeedbackService.PreselectionColor.equals(element) || IFeedbackService.DisabledPreselectionColor.equals(element)) {
            return ColorUtils.getColor((String)"#a8c0d8");
        }
        if (IFeedbackService.DisabledFocusColor.equals(element)) {
            return ColorUtils.getColor((String)"#606060");
        }
        if (IFeedbackService.DisabledSelectionColor.equals(element)) {
            return ColorUtils.getColor((String)"#808080");
        }
        return null;
    }
}

