/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.editor;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.xmind.ui.internal.MindMapMessages;
import org.xmind.ui.resources.FontUtils;

public class ErrorDetailsDialog
extends Dialog {
    private Throwable error;
    private String title;
    private long time;
    private String text;

    public ErrorDetailsDialog(Throwable error, String title, long time) {
        super(null);
        this.error = error;
        this.title = title;
        this.time = time;
        this.setShellStyle(0xC70 | ErrorDetailsDialog.getDefaultOrientation());
        this.setBlockOnOpen(false);
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(MindMapMessages.ErrorDetailDialog_title);
        newShell.addTraverseListener(new TraverseListener(){

            public void keyTraversed(TraverseEvent e) {
                if (e.detail == 2) {
                    ErrorDetailsDialog.this.setReturnCode(1);
                    ErrorDetailsDialog.this.close();
                }
            }
        });
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        this.createErrorLogArea(composite);
        return composite;
    }

    private void createErrorLogArea(Composite parent) {
        StyledText logControl = new StyledText(parent, 2826);
        logControl.setLayoutData((Object)new GridData(4, 4, true, true));
        logControl.setText(this.getLogText());
        if ("carbon".equals(SWT.getPlatform())) {
            logControl.setFont(FontUtils.getRelativeHeight((String)"org.eclipse.jface.dialogfont", (int)1));
        }
    }

    protected boolean isResizable() {
        return true;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 16, MindMapMessages.Finish_button_text, false);
        this.createButton(parent, 12, IDialogConstants.CLOSE_LABEL, true);
    }

    protected void buttonPressed(int buttonId) {
        if (buttonId == 16) {
            this.copyToClipboard();
        } else if (buttonId == 12) {
            this.okPressed();
        } else {
            super.buttonPressed(buttonId);
        }
    }

    private void copyToClipboard() {
        Clipboard clipboard = new Clipboard(Display.getCurrent());
        try {
            clipboard.setContents(new Object[]{this.getLogText()}, new Transfer[]{TextTransfer.getInstance()});
        }
        finally {
            clipboard.dispose();
        }
    }

    protected Point getInitialSize() {
        return new Point(500, 420);
    }

    private String getLogText() {
        if (this.text != null) {
            return this.text;
        }
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        PrintStream ps = new PrintStream(out);
        ps.println(this.title);
        ps.println("-----------------------------");
        ps.println("Time: " + String.format("%1$tF %1$tT", this.time));
        ps.print("XMind: 3.0.3");
        if (ErrorDetailsDialog.isPro()) {
            ps.println(" Pro");
        } else {
            ps.println();
        }
        ps.println("Java Version: " + System.getProperty("java.version"));
        ps.println("Java Vendor: " + System.getProperty("java.vendor"));
        ps.println("Java Runtime: " + System.getProperty("java.runtime.name"));
        ps.println("    Version: " + System.getProperty("java.runtime.version"));
        ps.println("Java VM: " + System.getProperty("java.vm.name"));
        ps.println("    Version: " + System.getProperty("java.vm.version"));
        ps.println("    Vendor: " + System.getProperty("java.vm.vendor"));
        ps.println("    Info: " + System.getProperty("java.vm.info"));
        ps.println("Operating System: " + System.getProperty("os.name") + " " + System.getProperty("os.version") + " (" + System.getProperty("os.arch") + ")");
        ps.println("Language: " + System.getProperty("user.language"));
        ps.println("Country: " + System.getProperty("user.country"));
        ps.println("-----------------------------");
        this.error.printStackTrace(ps);
        ps.close();
        this.text = out.toString();
        return this.text;
    }

    private static boolean isPro() {
        return Platform.getBundle((String)"org.xmind.meggy") != null;
    }
}

