/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.editor;

import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.xmind.ui.internal.editor.DialogPane;

public class DialogPaneContainer {
    private Composite composite;
    private DialogPane currentDialog;

    public Control getControl() {
        return this.composite;
    }

    public void createControl(Composite parent) {
        this.composite = new Composite(parent, 0);
        Display display = parent.getDisplay();
        final Color background = new Color((Device)display, 56, 56, 56);
        this.composite.setBackground(background);
        GridLayout gridLayout = new GridLayout(1, false);
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        gridLayout.verticalSpacing = 0;
        gridLayout.horizontalSpacing = 0;
        this.composite.setLayout((Layout)gridLayout);
        this.composite.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                background.dispose();
                DialogPaneContainer.this.handleDispose();
            }
        });
    }

    protected void handleDispose() {
        this.hideCurrentDialog();
    }

    protected void showDialog(DialogPane dialog) {
        if (this.composite == null || this.composite.isDisposed()) {
            return;
        }
        this.doHideCurrentDialog();
        this.currentDialog = dialog;
        this.currentDialog.createControl(this.composite);
        this.currentDialog.setFocus();
        this.composite.layout(true);
    }

    protected DialogPane getCurrentDialog() {
        return this.currentDialog;
    }

    protected void hideCurrentDialog() {
        this.doHideCurrentDialog();
        if (this.composite != null && !this.composite.isDisposed()) {
            this.composite.layout(true);
        }
    }

    private void doHideCurrentDialog() {
        if (this.currentDialog != null) {
            Control pageControl = this.currentDialog.getControl();
            this.currentDialog.dispose();
            if (pageControl != null && !pageControl.isDisposed()) {
                pageControl.dispose();
            }
            this.currentDialog = null;
        }
    }

    public void dispose() {
        this.hideCurrentDialog();
        if (this.composite != null) {
            this.composite.dispose();
        }
    }

    public void setFocus() {
        if (this.currentDialog != null) {
            this.currentDialog.setFocus();
        } else {
            this.composite.setFocus();
        }
    }
}

