/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.dnd;

import java.util.ArrayList;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.swt.dnd.URLTransfer;
import org.xmind.core.ISheet;
import org.xmind.core.ITopic;
import org.xmind.core.IWorkbook;
import org.xmind.core.util.FileUtils;
import org.xmind.gef.ISourceProvider;
import org.xmind.gef.IViewer;
import org.xmind.gef.Request;
import org.xmind.gef.command.Command;
import org.xmind.gef.command.CompoundCommand;
import org.xmind.gef.command.ICommandStack;
import org.xmind.gef.dnd.DndData;
import org.xmind.gef.dnd.IDndClient;
import org.xmind.gef.part.IPart;
import org.xmind.ui.commands.AddTopicCommand;
import org.xmind.ui.commands.CommandMessages;
import org.xmind.ui.commands.CreateTopicCommand;
import org.xmind.ui.commands.ModifyPositionCommand;
import org.xmind.ui.commands.ModifyTopicHyperlinkCommand;
import org.xmind.ui.internal.mindmap.ImageDownloadCenter;
import org.xmind.ui.mindmap.IMindMapDndClient;
import org.xmind.ui.mindmap.ITopicPart;
import org.xmind.ui.mindmap.MindMapUI;
import org.xmind.ui.util.ImageFormat;
import org.xmind.ui.util.MindMapUtils;

public class URLDndClient
implements IDndClient,
IMindMapDndClient {
    private URLTransfer transfer = URLTransfer.getInstance();

    public Object getData(Transfer transfer, TransferData data) {
        if (transfer == this.transfer) {
            return this.transfer.nativeToJava(data);
        }
        return null;
    }

    public Transfer getTransfer() {
        return this.transfer;
    }

    public Object toTransferData(Object[] viewerElements, IViewer viewer) {
        return null;
    }

    public Object[] toViewerElements(Object transferData, IViewer viewer, Object target) {
        String url = (String)transferData;
        IWorkbook workbook = (IWorkbook)viewer.getAdapter(IWorkbook.class);
        if (workbook != null) {
            ITopic topic = workbook.createTopic();
            topic.setTitleText(url);
            topic.setHyperlink(url);
            return new Object[]{topic};
        }
        return null;
    }

    public boolean handleRequest(Request request, DndData dndData) {
        String url = (String)dndData.parsedData;
        IPart target = request.getPrimaryTarget();
        IPart parent = (IPart)request.getParameter("parent");
        ITopicPart targetTopic = MindMapUtils.findTopicPart(target);
        ITopicPart parentTopic = MindMapUtils.findTopicPart(parent);
        if (targetTopic != null && targetTopic.equals(parentTopic)) {
            if (MindMapUI.getProtocolManager().isHyperlinkModifiable(targetTopic.getTopic(), url)) {
                return this.handleAddURLToTopic(request.getTargetCommandStack(), targetTopic.getTopic(), url);
            }
        } else if (this.isImageURL(url)) {
            return this.handleAddImageTopic(request, parentTopic, url);
        }
        return false;
    }

    private boolean handleAddImageTopic(Request request, ITopicPart parent, String url) {
        ISheet sheet = (ISheet)request.getTargetViewer().getAdapter(ISheet.class);
        if (sheet == null) {
            return false;
        }
        CreateTopicCommand create = new CreateTopicCommand(sheet.getOwnedWorkbook());
        ArrayList<Object> commands = new ArrayList<Object>();
        commands.add((Object)create);
        boolean detached = parent == null;
        ITopic parentTopic = detached ? sheet.getRootTopic() : parent.getTopic();
        int index = request.getIntParameter("index", -1);
        AddTopicCommand add = new AddTopicCommand((ISourceProvider)create, parentTopic, index, detached ? "detached" : "attached");
        commands.add((Object)add);
        if (detached) {
            Point pos = (Point)request.getParameter("position");
            commands.add((Object)new ModifyPositionCommand((ISourceProvider)create, MindMapUtils.toModelPosition(pos)));
        }
        CompoundCommand cmd = new CompoundCommand(CommandMessages.Command_CreateTopic, commands);
        request.getTargetCommandStack().execute((Command)cmd);
        ITopic targetTopic = (ITopic)create.getSource();
        request.getTargetViewer().setSelection((ISelection)new StructuredSelection((Object)targetTopic), true);
        this.addImageToTopic(targetTopic, url);
        return true;
    }

    private boolean handleAddURLToTopic(ICommandStack commandStack, ITopic topic, String url) {
        if (this.isImageURL(url)) {
            this.addImageToTopic(topic, url);
        } else {
            this.changeTopicHyperlink(commandStack, topic, url);
        }
        return true;
    }

    private void changeTopicHyperlink(ICommandStack commandStack, ITopic topic, String url) {
        ModifyTopicHyperlinkCommand command = new ModifyTopicHyperlinkCommand(topic, url);
        command.setLabel(CommandMessages.Command_ModifyTopicHyperlink);
        commandStack.execute((Command)command);
    }

    private boolean isImageURL(String url) {
        return url != null && ImageFormat.findByExtension((String)FileUtils.getExtension((String)url), null) != null;
    }

    private void addImageToTopic(ITopic topic, String url) {
        ImageDownloadCenter.getInstance().startDownload(topic, url);
    }
}

