/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.dialogs;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.xmind.core.ISheet;
import org.xmind.core.ITopic;
import org.xmind.core.IWorkbook;
import org.xmind.ui.dialogs.HyperlinkPage;
import org.xmind.ui.internal.dialogs.DialogMessages;
import org.xmind.ui.internal.protocols.TopicProtocol;
import org.xmind.ui.mindmap.MindMapUI;
import org.xmind.ui.util.MindMapUtils;
import org.xmind.ui.viewers.ImageCachedLabelProvider;

public class TopicHyperlinkPage
extends HyperlinkPage {
    public Composite composite;
    public IWorkbook workbook;
    public boolean isModifyValue = false;
    public String str;
    private TreeViewer topicViewer;

    public void init(IStructuredSelection selection) {
        this.workbook = this.findWorkbook(selection);
    }

    private IWorkbook findWorkbook(IStructuredSelection selection) {
        Object[] objectArray = selection.toArray();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object o = objectArray[n2];
            IWorkbook workbook = MindMapUtils.findWorkbook(o);
            if (workbook != null) {
                return workbook;
            }
            ++n2;
        }
        return null;
    }

    public void createControl(Composite parent) {
        this.composite = new Composite(parent, 0);
        this.composite.setLayout((Layout)new GridLayout(1, false));
        this.createLabel(this.composite);
        this.createTopicViewer(this.composite);
    }

    private void createLabel(Composite parent) {
        Label label = new Label(parent, 64);
        label.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        label.setText(DialogMessages.TopicHyperlinkPage_label);
    }

    private void createTopicViewer(Composite parent) {
        this.topicViewer = new TreeViewer(parent, 2052);
        this.topicViewer.getControl().setLayoutData((Object)new GridData(4, 4, true, true));
        this.topicViewer.setAutoExpandLevel(2);
        this.topicViewer.setContentProvider((IContentProvider)new TopicPageContentProvider());
        this.topicViewer.setLabelProvider((IBaseLabelProvider)new TopicPageLabelProvider());
        if (this.workbook != null) {
            this.topicViewer.setInput((Object)this.workbook);
        }
        this.topicViewer.addSelectionChangedListener((ISelectionChangedListener)new TopicSelectionListener());
    }

    public void setValue(String value) {
        super.setValue(value);
        if (!this.isModifyValue && this.topicViewer != null && this.topicViewer.getControl() != null && !this.topicViewer.getControl().isDisposed()) {
            Object element = this.getElement(value);
            if (element != null) {
                this.topicViewer.setSelection((ISelection)new StructuredSelection(element), true);
            } else {
                this.topicViewer.setSelection((ISelection)StructuredSelection.EMPTY);
            }
        }
    }

    private Object getElement(String value) {
        if (value == null) {
            return null;
        }
        if (this.workbook == null) {
            return null;
        }
        return TopicProtocol.findElement(value, this.workbook);
    }

    public void dispose() {
    }

    public Control getControl() {
        return this.composite;
    }

    public void setFocus() {
        Control control;
        if (this.topicViewer != null && (control = this.topicViewer.getControl()) != null && !control.isDisposed()) {
            control.setFocus();
        }
    }

    private class TopicPageContentProvider
    implements ITreeContentProvider {
        private TopicPageContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            if (inputElement instanceof IWorkbook) {
                List sheets = ((IWorkbook)inputElement).getSheets();
                ArrayList<ITopic> rootTopics = new ArrayList<ITopic>(sheets.size());
                for (ISheet sheet : sheets) {
                    rootTopics.add(sheet.getRootTopic());
                }
                return rootTopics.toArray();
            }
            return new Object[0];
        }

        public boolean hasChildren(Object element) {
            if (element instanceof ITopic) {
                return !((ITopic)element).getAllChildren().isEmpty();
            }
            return false;
        }

        public Object[] getChildren(Object parentElement) {
            if (parentElement instanceof ITopic) {
                return ((ITopic)parentElement).getAllChildren().toArray();
            }
            return new Object[0];
        }

        public Object getParent(Object element) {
            if (element instanceof ITopic) {
                ITopic topic = (ITopic)element;
                if (topic.isRoot()) {
                    return topic.getOwnedWorkbook();
                }
                return topic.getParent();
            }
            return null;
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    private class TopicPageLabelProvider
    extends ImageCachedLabelProvider {
        private TopicPageLabelProvider() {
        }

        public String getText(Object element) {
            if (element instanceof ITopic) {
                ITopic topic = (ITopic)element;
                if (topic.isRoot()) {
                    return String.valueOf(topic.getTitleText()) + " (" + topic.getOwnedSheet().getTitleText() + ")";
                }
                return topic.getTitleText();
            }
            return super.getText(element);
        }

        protected Image createImage(Object element) {
            ImageDescriptor icon = MindMapUI.getImages().getElementIcon(element, true);
            if (icon == null) {
                return null;
            }
            return icon.createImage(false);
        }
    }

    private class TopicSelectionListener
    implements ISelectionChangedListener {
        private TopicSelectionListener() {
        }

        public void selectionChanged(SelectionChangedEvent event) {
            IStructuredSelection ss;
            Object element;
            ISelection selection = event.getSelection();
            if (selection instanceof IStructuredSelection && (element = (ss = (IStructuredSelection)selection).getFirstElement()) instanceof ITopic) {
                TopicHyperlinkPage.this.isModifyValue = true;
                TopicHyperlinkPage.this.setValue(TopicProtocol.toXmindURL((ITopic)element));
                TopicHyperlinkPage.this.isModifyValue = false;
                TopicHyperlinkPage.this.setCanFinish(true);
            }
        }
    }
}

