/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.decorators;

import org.eclipse.draw2d.IFigure;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.graphics.TextStyle;
import org.xmind.core.ITitled;
import org.xmind.gef.draw2d.IMinimizable;
import org.xmind.gef.draw2d.ITextFigure;
import org.xmind.gef.graphicalpolicy.IStyleSelector;
import org.xmind.gef.part.Decorator;
import org.xmind.gef.part.IGraphicalPart;
import org.xmind.gef.part.IPart;
import org.xmind.ui.style.StyleUtils;
import org.xmind.ui.util.MindMapUtils;

public class TitleTextDecorator
extends Decorator {
    public void activate(IGraphicalPart part, IFigure figure) {
        super.activate(part, figure);
        figure.setMinimumSize(IMinimizable.DEFAULT_MIN_SIZE);
    }

    public void decorate(IGraphicalPart part, IFigure figure) {
        if (figure instanceof ITextFigure) {
            ITextFigure textFigure = (ITextFigure)figure;
            ITitled titled = this.getTitledModel(part);
            String text = this.getText(part, titled);
            if (text != null) {
                textFigure.setText(text);
            }
            textFigure.setVisible(this.isVisible(part, titled));
            this.decorateTextFigure(part, textFigure);
            this.decorateTextAlignment(part, textFigure);
        }
    }

    private void decorateTextAlignment(IGraphicalPart part, ITextFigure textFigure) {
        IGraphicalPart parent = this.getOwnerPart(part);
        if (parent != null) {
            part = parent;
        }
        this.decorateTextAlignment(part, StyleUtils.getStyleSelector(part), textFigure);
    }

    private void decorateTextAlignment(IGraphicalPart part, IStyleSelector ss, ITextFigure textFigure) {
        int align = StyleUtils.getAlign(part, ss, null);
        if (align != 0) {
            textFigure.setTextAlignment(align);
        } else {
            textFigure.setTextAlignment(1);
        }
    }

    private ITitled getTitledModel(IGraphicalPart part) {
        Object model = MindMapUtils.getRealModel((IPart)part);
        if (model == null || !(model instanceof ITitled)) {
            model = part.getAdapter(ITitled.class);
        }
        if (model instanceof ITitled) {
            return (ITitled)model;
        }
        return null;
    }

    protected String getText(IGraphicalPart part, ITitled titled) {
        if (titled != null) {
            if (!this.hasTitle(titled)) {
                return this.getUntitledText(part, titled);
            }
            return titled.getTitleText();
        }
        return null;
    }

    protected boolean hasTitle(ITitled titled) {
        return titled.hasTitle();
    }

    protected String getUntitledText(IGraphicalPart part, ITitled titled) {
        return titled.getTitleText();
    }

    protected boolean isVisible(IGraphicalPart part, ITitled titled) {
        return titled != null && this.hasTitle(titled);
    }

    protected void decorateTextFigure(IGraphicalPart part, ITextFigure figure) {
        IGraphicalPart parent = this.getOwnerPart(part);
        if (parent != null) {
            part = parent;
        }
        this.decorateTextFigure(part, StyleUtils.getStyleSelector(part), figure);
    }

    protected void decorateTextFigure(IGraphicalPart ownerPart, IStyleSelector ss, ITextFigure figure) {
        TextStyle style = StyleUtils.getTextStyle(ownerPart, ss);
        if (style != null) {
            figure.setStyle(style);
        } else {
            figure.setFont(StyleUtils.getCompositeFont(ownerPart, ss, JFaceResources.getDefaultFont()));
            figure.setForegroundColor(StyleUtils.getColor(ownerPart, ss, "fo:color", null, "#000000"));
        }
    }

    protected IGraphicalPart getOwnerPart(IGraphicalPart part) {
        return null;
    }
}

