/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.decorators;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Layer;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Image;
import org.xmind.core.ISheet;
import org.xmind.core.IWorkbook;
import org.xmind.core.util.HyperlinkUtils;
import org.xmind.gef.GEF;
import org.xmind.gef.IGraphicalViewer;
import org.xmind.gef.IViewer;
import org.xmind.gef.graphicalpolicy.IStyleSelector;
import org.xmind.gef.part.Decorator;
import org.xmind.gef.part.IGraphicalPart;
import org.xmind.gef.part.IPart;
import org.xmind.ui.internal.AttachmentImageDescriptor;
import org.xmind.ui.internal.layers.BackgroundLayer;
import org.xmind.ui.mindmap.IMindMapViewer;
import org.xmind.ui.style.StyleUtils;
import org.xmind.ui.util.MindMapUtils;

public class SheetDecorator
extends Decorator {
    private static final SheetDecorator instance = new SheetDecorator();
    private static final String CACHE_WALLPAPER_KEY = "org.xmind.ui.cache.wallpaperKey";
    private WallpaperImageRegistry imageRegistry = null;

    protected SheetDecorator() {
    }

    public void decorate(IGraphicalPart part, IFigure figure) {
        super.decorate(part, figure);
        IStyleSelector ss = StyleUtils.getStyleSelector(part);
        this.decorateSheet(part, ss, figure);
    }

    private void decorateSheet(IGraphicalPart part, IStyleSelector ss, IFigure figure) {
        IGraphicalViewer viewer = (IGraphicalViewer)part.getSite().getViewer();
        Layer layer = viewer.getLayer(GEF.LAYER_BACKGROUND);
        if (layer != null) {
            this.decorateBackground(part, ss, layer);
        }
    }

    private void decorateBackground(IGraphicalPart part, IStyleSelector ss, Layer layer) {
        layer.setBackgroundColor(StyleUtils.getColor(part, ss, "svg:fill", null, "#ffffff"));
        if (layer instanceof BackgroundLayer) {
            BackgroundLayer bgLayer = (BackgroundLayer)layer;
            bgLayer.setWallpaper(this.getWallpaper(part, ss));
            bgLayer.setSubAlpha(this.getWallpaperAlpha(part, ss));
        }
    }

    private int getWallpaperAlpha(IGraphicalPart part, IStyleSelector ss) {
        double opacity = StyleUtils.getDouble(part, ss, "svg:opacity", 0.8);
        return (int)Math.round(opacity * 255.0);
    }

    private Image getWallpaper(IGraphicalPart part, IStyleSelector ss) {
        if (this.imageRegistry == null) {
            this.imageRegistry = new WallpaperImageRegistry();
        }
        return this.imageRegistry.getImage(part, ss);
    }

    public void deactivate(IGraphicalPart part, IFigure figure) {
        IGraphicalViewer viewer = (IGraphicalViewer)part.getSite().getViewer();
        Layer layer = viewer.getLayer(GEF.LAYER_BACKGROUND);
        if (layer instanceof BackgroundLayer) {
            ((BackgroundLayer)layer).setWallpaper(null);
        }
        if (this.imageRegistry != null) {
            this.imageRegistry.removeHost(part, StyleUtils.getStyleSelector(part));
        }
        super.deactivate(part, figure);
    }

    public static SheetDecorator getInstance() {
        return instance;
    }

    private static class WallpaperImageRegistry {
        private Map<Key, Entry> map = new HashMap<Key, Entry>();

        private WallpaperImageRegistry() {
        }

        public Image getImage(IGraphicalPart host, IStyleSelector ss) {
            Key oldKey = (Key)MindMapUtils.getCache((IPart)host, SheetDecorator.CACHE_WALLPAPER_KEY);
            Key newKey = this.createKey(host, ss);
            MindMapUtils.setCache((IPart)host, SheetDecorator.CACHE_WALLPAPER_KEY, newKey);
            if (oldKey != null && !oldKey.equals(newKey)) {
                this.remove(host, oldKey);
            }
            if (newKey != null) {
                Entry entry = this.map.get(newKey);
                if (entry == null) {
                    entry = new Entry(newKey);
                    this.map.put(newKey, entry);
                }
                if (entry != null) {
                    return entry.getImage(host);
                }
            }
            return null;
        }

        private Key createKey(IGraphicalPart host, IStyleSelector ss) {
            IWorkbook workbook;
            String entryPath = this.getWallpaperAttachmentPath(host, ss);
            if (entryPath != null && (workbook = this.getWorkbook(host)) != null) {
                return new Key(workbook, entryPath);
            }
            return null;
        }

        public void removeHost(IGraphicalPart host, IStyleSelector ss) {
            Key key = this.createKey(host, ss);
            if (key != null) {
                this.remove(host, key);
            }
        }

        private void remove(IGraphicalPart host, Key key) {
            Entry entry = this.map.get(key);
            if (entry != null) {
                entry.remove(host);
                if (entry.isEmpty()) {
                    this.map.remove(key);
                    entry.dispose();
                }
            }
        }

        private String getWallpaperAttachmentPath(IGraphicalPart host, IStyleSelector ss) {
            String value = ss.getStyleValue(host, "background");
            if (value != null && HyperlinkUtils.isAttachmentURL((String)value)) {
                return HyperlinkUtils.toAttachmentPath((String)value);
            }
            return null;
        }

        private IWorkbook getWorkbook(IGraphicalPart host) {
            ISheet sheet;
            IViewer viewer = host.getSite().getViewer();
            if (viewer instanceof IMindMapViewer && (sheet = ((IMindMapViewer)viewer).getSheet()) != null) {
                return sheet.getOwnedWorkbook();
            }
            return null;
        }

        public boolean isEmpty() {
            return this.map.isEmpty();
        }

        private static class Entry {
            Key key;
            ImageDescriptor imageDescriptor;
            Image image;
            Set<IGraphicalPart> hosts;

            public Entry(Key key) {
                this.key = key;
                this.imageDescriptor = this.createImageDescriptor();
            }

            private ImageDescriptor createImageDescriptor() {
                return AttachmentImageDescriptor.createFromEntryPath(this.key.workbook, this.key.entryPath);
            }

            public Image getImage(IGraphicalPart host) {
                if (this.hosts == null) {
                    this.hosts = new HashSet<IGraphicalPart>();
                }
                this.hosts.add(host);
                if (this.image == null) {
                    this.image = this.imageDescriptor.createImage(false);
                }
                return this.image;
            }

            public void remove(IGraphicalPart host) {
                if (this.hosts != null) {
                    this.hosts.remove(host);
                }
            }

            public boolean isEmpty() {
                return this.hosts == null || this.hosts.isEmpty();
            }

            public void dispose() {
                if (this.image != null) {
                    this.image.dispose();
                    this.image = null;
                }
            }
        }

        private static class Key {
            IWorkbook workbook;
            String entryPath;

            public Key(IWorkbook workbook, String entryPath) {
                this.workbook = workbook;
                this.entryPath = entryPath;
            }

            public int hashCode() {
                return this.workbook.hashCode() ^ this.entryPath.hashCode();
            }

            public boolean equals(Object obj) {
                if (obj == this) {
                    return true;
                }
                if (obj == null || !(obj instanceof Key)) {
                    return false;
                }
                Key that = (Key)obj;
                return this.workbook.equals(that.workbook) && this.entryPath.equals(that.entryPath);
            }
        }
    }
}

