/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.decorations;

import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.geometry.Rectangle;
import org.xmind.gef.draw2d.decoration.ICorneredDecoration;
import org.xmind.gef.draw2d.geometry.Geometry;
import org.xmind.gef.draw2d.graphics.Path;
import org.xmind.ui.decorations.AbstractTopicDecoration;

public class RoundedRectTopicDecoration
extends AbstractTopicDecoration
implements ICorneredDecoration {
    private static final double M = (1.0 - Math.sqrt(2.0) / 2.0) * 0.8;
    private int cornerSize = 0;

    public RoundedRectTopicDecoration() {
    }

    public RoundedRectTopicDecoration(String id) {
        super(id);
    }

    protected void sketch(IFigure figure, Path shape, Rectangle box, int purpose) {
        float c = this.getAppliedCornerSize();
        if (c == 0.0f) {
            shape.addRectangle((float)box.x, (float)box.y, (float)box.width, (float)box.height);
        } else {
            shape.addRoundedRectangle(box, c);
        }
    }

    public Insets getPreferredInsets(IFigure figure, int width, int height) {
        int c = (int)(M * (double)this.getAppliedCornerSize()) + this.getLineWidth();
        return Geometry.union((Insets)super.getPreferredInsets(figure, width, height), (int)c, (int)c, (int)c, (int)c);
    }

    public int getCornerSize() {
        return this.cornerSize;
    }

    protected int getAppliedCornerSize() {
        return this.getCornerSize();
    }

    public void setCornerSize(IFigure figure, int cornerSize) {
        if (cornerSize == this.cornerSize) {
            return;
        }
        this.cornerSize = cornerSize;
        this.invalidate();
        if (figure != null) {
            figure.revalidate();
            figure.repaint();
        }
    }
}

