/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.decorations;

import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.geometry.Rectangle;
import org.xmind.gef.draw2d.decoration.ICorneredDecoration;
import org.xmind.gef.draw2d.geometry.Geometry;
import org.xmind.gef.draw2d.graphics.Path;
import org.xmind.ui.decorations.AbstractTopicDecoration;

public class RoundedRectCalloutTopicDecoration
extends AbstractTopicDecoration
implements ICorneredDecoration {
    private static final double M = 1.0 - Math.sqrt(2.0) / 2.0;
    private static final float X = 0.2f;
    private int cornerSize = 0;

    public RoundedRectCalloutTopicDecoration() {
    }

    public RoundedRectCalloutTopicDecoration(String id) {
        super(id);
    }

    protected void sketch(IFigure figure, Path shape, Rectangle box, int purpose) {
        float x = box.x;
        float y = box.y;
        float width = box.width;
        float height = box.height;
        float tailHeight = this.getTailHeight(figure.getBounds().height - figure.getInsets().getHeight());
        float r = x + width;
        float b = y + (height -= tailHeight);
        float x0 = x + width / 2.0f;
        float y0 = y + height / 2.0f;
        float corner = this.getAppliedCornerSize();
        float y1 = Math.min(y + corner, y0);
        shape.moveTo(x, y1);
        float x1 = Math.min(x + corner, x0);
        float cx1 = x + (x1 - x) / 4.0f;
        float cy1 = y + (y1 - y) / 4.0f;
        shape.cubicTo(x, cy1, cx1, y, x1, y);
        float x2 = Math.max(r - corner, x0);
        shape.lineTo(x2, y);
        float cx2 = r - (r - x2) / 4.0f;
        shape.cubicTo(cx2, y, r, cy1, r, y1);
        float y2 = Math.max(b - corner, y0);
        shape.lineTo(r, y2);
        float cy2 = b - (b - y2) / 4.0f;
        shape.cubicTo(r, cy2, cx2, b, x2, b);
        shape.lineTo(x + width * 0.2f, b);
        shape.lineTo(x, b + tailHeight);
        shape.lineTo(x1, b);
        shape.cubicTo(cx1, b, x, cy2, x, y2);
        shape.close();
    }

    public Insets getPreferredInsets(IFigure figure, int width, int height) {
        int c = (int)(M * (double)this.getAppliedCornerSize()) + this.getLineWidth();
        Insets ins = super.getPreferredInsets(figure, width, height);
        ins = Geometry.union((Insets)ins, (int)c, (int)c, (int)c, (int)c);
        ins.bottom += this.getTailHeight(height);
        return ins;
    }

    private int getTailHeight(int clientHeight) {
        return clientHeight / 3;
    }

    public int getCornerSize() {
        return this.cornerSize;
    }

    protected int getAppliedCornerSize() {
        return this.getCornerSize();
    }

    public void setCornerSize(IFigure figure, int cornerSize) {
        if (cornerSize == this.cornerSize) {
            return;
        }
        this.cornerSize = cornerSize;
        this.invalidate();
        if (figure != null) {
            figure.revalidate();
            figure.repaint();
        }
    }
}

