/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.decorations;

import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Path;
import org.eclipse.swt.widgets.Display;
import org.xmind.gef.draw2d.geometry.PrecisionPoint;
import org.xmind.ui.internal.decorations.CurveBranchConnection;

public class ArrowedCurveBranchConnection
extends CurveBranchConnection {
    private static final double CPRatio = 0.1;
    private static final double ARROW_WING_WIDTH = 2.0;
    private static final double ARROW_LENGTH = 5.0;
    private PrecisionPoint realTarget = new PrecisionPoint();

    public ArrowedCurveBranchConnection() {
    }

    public ArrowedCurveBranchConnection(String id) {
        super(id);
    }

    protected double getControlPointRatio() {
        return 0.1;
    }

    protected double getArrowWidth() {
        return 2.0 + (double)this.getArrowSizeAdjustment();
    }

    protected double getArrowLength() {
        return 5.0 + (double)this.getArrowSizeAdjustment();
    }

    private int getArrowSizeAdjustment() {
        return this.getLineWidth() - 1;
    }

    protected void calculateTerminalPoints(IFigure figure, PrecisionPoint sourcePos, PrecisionPoint targetPos) {
        super.calculateTerminalPoints(figure, sourcePos, targetPos);
        this.realTarget.setLocation(targetPos);
        if (this.isTargetHorizontal()) {
            targetPos.x = targetPos.x > sourcePos.x ? (targetPos.x -= this.getArrowLength()) : (targetPos.x += this.getArrowLength());
        } else {
            targetPos.y = targetPos.y > sourcePos.y ? (targetPos.y -= this.getArrowLength()) : (targetPos.y += this.getArrowLength());
        }
    }

    protected void drawLine(IFigure figure, Graphics g) {
        super.drawLine(figure, g);
        org.xmind.gef.draw2d.graphics.Path arrow = new org.xmind.gef.draw2d.graphics.Path((Device)Display.getCurrent());
        this.shapeArrow(figure, arrow);
        Color bg = g.getBackgroundColor();
        g.setBackgroundColor(g.getForegroundColor());
        g.fillPath((Path)arrow);
        g.setBackgroundColor(bg);
        arrow.dispose();
    }

    private void shapeArrow(IFigure figure, org.xmind.gef.draw2d.graphics.Path shape) {
        PrecisionPoint sp = this.getSourcePosition(figure);
        PrecisionPoint tp = this.realTarget;
        shape.moveTo(tp);
        double w = this.getArrowWidth();
        double l = this.getArrowLength();
        if (this.isTargetHorizontal()) {
            if (tp.x > sp.x) {
                shape.lineTo((float)(tp.x - l), (float)(tp.y - w));
                shape.lineTo((float)(tp.x - l), (float)(tp.y + w));
            } else {
                shape.lineTo((float)(tp.x + l), (float)(tp.y - w));
                shape.lineTo((float)(tp.x + l), (float)(tp.y + w));
            }
        } else if (tp.y > sp.y) {
            shape.lineTo((float)(tp.x - w), (float)(tp.y - l));
            shape.lineTo((float)(tp.x + w), (float)(tp.y - l));
        } else {
            shape.lineTo((float)(tp.x - w), (float)(tp.y + l));
            shape.lineTo((float)(tp.x + w), (float)(tp.y + l));
        }
    }
}

