/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.branch;

import org.eclipse.draw2d.geometry.Point;
import org.xmind.gef.graphicalpolicy.IStructure;
import org.xmind.gef.part.IPart;
import org.xmind.ui.branch.IBranchHook;
import org.xmind.ui.branch.IBranchStructure;
import org.xmind.ui.internal.branch.AbstractBranchPolicy;
import org.xmind.ui.internal.branch.BranchPolicyManager;
import org.xmind.ui.internal.branch.MapBranchHook;
import org.xmind.ui.internal.branch.RadialStructure;
import org.xmind.ui.mindmap.IBranchPart;
import org.xmind.ui.util.MindMapUtils;

public class DefaultBranchPolicy
extends AbstractBranchPolicy {
    protected static final String RADIAL_STRUCTURE_ID = "org.xmind.ui.branchStructure.radial";
    protected static IBranchStructure radial = null;

    DefaultBranchPolicy(BranchPolicyManager manager) {
        super(manager, "org.xmind.ui.map");
    }

    protected IBranchHook createHook(IBranchPart branch) {
        return new MapBranchHook();
    }

    protected IBranchStructure getPredefinedStructure(String structureId) {
        if (RADIAL_STRUCTURE_ID.equals(structureId)) {
            if (radial == null) {
                radial = new RadialStructure();
            }
            return radial;
        }
        return super.getPredefinedStructure(structureId);
    }

    protected IStructure createDefaultStructureAlgorithm() {
        return this.getPredefinedStructure(this.getDefaultStructureId());
    }

    protected boolean isUnmodifiableProperty(IBranchPart branch, String propertyKey, String secondaryKey) {
        return false;
    }

    protected String calcAdditionalStructureId(IBranchPart branch, IBranchPart parent) {
        if (branch.isCentral()) {
            return RADIAL_STRUCTURE_ID;
        }
        String branchType = branch.getBranchType();
        if ("floatingBranch".equals(branchType)) {
            Point p = (Point)MindMapUtils.getCache((IPart)branch, "org.xmind.ui.cache.preferredPosition");
            if (p != null && p.x < 0) {
                return "org.xmind.ui.branchStructure.left";
            }
            return this.getDefaultStructureId();
        }
        if (parent == null) {
            return this.getDefaultStructureId();
        }
        if (this.getPolicyId().equals(parent.getBranchPolicyId())) {
            IStructure sa;
            if ("subBranch".equals(branchType)) {
                String id = (String)MindMapUtils.getCache((IPart)parent, "org.xmind.ui.branchCache.structureId");
                return id == null ? this.getDefaultStructureId() : id;
            }
            if ("mainBranch".equals(branchType) && (sa = parent.getBranchPolicy().getStructure(parent)) instanceof RadialStructure) {
                RadialStructure rsa = (RadialStructure)sa;
                if (rsa.isChildLeft(parent, branch)) {
                    return "org.xmind.ui.branchStructure.left";
                }
                return this.getDefaultStructureId();
            }
        }
        return null;
    }

    protected String getDefaultStructureId() {
        return "org.xmind.ui.branchStructure.right";
    }
}

