/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.actions;

import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.jface.util.SafeRunnable;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.FileDialog;
import org.xmind.core.IFileEntry;
import org.xmind.core.ITopic;
import org.xmind.core.util.FileUtils;
import org.xmind.core.util.HyperlinkUtils;
import org.xmind.gef.ui.actions.ISelectionAction;
import org.xmind.gef.ui.actions.PageAction;
import org.xmind.gef.ui.editor.IGraphicalEditorPage;
import org.xmind.ui.actions.MindMapActionFactory;
import org.xmind.ui.internal.dialogs.DialogMessages;
import org.xmind.ui.util.MindMapUtils;

public class SaveAttachmentAsAction
extends PageAction
implements ISelectionAction {
    private ITopic topic = null;

    public SaveAttachmentAsAction(IGraphicalEditorPage page) {
        super(MindMapActionFactory.SAVE_ATTACHMENT_AS.getId(), page);
    }

    public void run() {
        String targetPath;
        InputStream is;
        block16: {
            if (this.isDisposed()) {
                return;
            }
            if (this.topic == null) {
                return;
            }
            ITopic sourceTopic = this.topic;
            String url = sourceTopic.getHyperlink();
            if (url == null || !HyperlinkUtils.isAttachmentURL((String)url)) {
                return;
            }
            String entryPath = HyperlinkUtils.toAttachmentPath((String)url);
            IFileEntry entry = sourceTopic.getOwnedWorkbook().getManifest().getFileEntry(entryPath);
            if (entry == null) {
                return;
            }
            is = entry.getInputStream();
            if (is == null) {
                return;
            }
            try {
                String ext = FileUtils.getExtension((String)entryPath);
                FileDialog dialog = new FileDialog(this.getPage().getControl().getShell(), 8192);
                dialog.setFilterExtensions(new String[]{"*.*"});
                dialog.setFilterNames(new String[]{NLS.bind((String)"{0} (*.*)", (Object)DialogMessages.AllFilesFilterName)});
                String name = sourceTopic.getTitleText();
                if (name != null && !name.endsWith(ext)) {
                    name = String.valueOf(name) + ext;
                }
                if (name != null) {
                    dialog.setFileName(name);
                }
                if ((targetPath = dialog.open()) != null) break block16;
            }
            catch (Throwable throwable) {
                try {
                    is.close();
                }
                catch (IOException iOException) {}
                throw throwable;
            }
            try {
                is.close();
            }
            catch (IOException iOException) {}
            return;
        }
        SafeRunner.run((ISafeRunnable)new SafeRunnable(){

            public void run() throws Exception {
                FileOutputStream os = new FileOutputStream(targetPath);
                FileUtils.transfer((InputStream)is, (OutputStream)os, (boolean)true);
            }
        });
        try {
            is.close();
        }
        catch (IOException iOException) {}
    }

    public void setSelection(ISelection selection) {
        this.topic = this.getTopic(selection);
        this.setEnabled(MindMapUtils.isSingleTopic(selection) && this.hasAttachment(selection));
    }

    private ITopic getTopic(ISelection selection) {
        Object o;
        if (selection instanceof IStructuredSelection && (o = ((IStructuredSelection)selection).getFirstElement()) instanceof ITopic) {
            return (ITopic)o;
        }
        return null;
    }

    private boolean hasAttachment(ISelection selection) {
        ITopic topic = (ITopic)((IStructuredSelection)selection).getFirstElement();
        if (topic == null) {
            return false;
        }
        String url = topic.getHyperlink();
        if (url == null) {
            return false;
        }
        return HyperlinkUtils.isAttachmentURL((String)url);
    }
}

