/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.actions;

import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.xmind.core.ITopic;
import org.xmind.gef.Request;
import org.xmind.gef.ui.actions.ISelectionAction;
import org.xmind.gef.ui.actions.PageAction;
import org.xmind.gef.ui.editor.IGraphicalEditorPage;
import org.xmind.ui.actions.MindMapActionFactory;
import org.xmind.ui.mindmap.MindMapUI;
import org.xmind.ui.util.MindMapUtils;

public class CancelHyperlinkAction
extends PageAction
implements ISelectionAction {
    public CancelHyperlinkAction(IGraphicalEditorPage page) {
        super(MindMapActionFactory.CANCEL_HYPERLINK.getId(), page);
    }

    public void run() {
        if (this.isDisposed()) {
            return;
        }
        this.sendRequest(new Request("modify hyperlink").setParameter("text", null));
    }

    public void setSelection(ISelection selection) {
        this.setEnabled(MindMapUtils.isSingleTopic(selection) && this.hasModifiableHyperlink(selection));
    }

    private boolean hasModifiableHyperlink(ISelection selection) {
        ITopic topic = (ITopic)((IStructuredSelection)selection).getFirstElement();
        if (topic == null) {
            return false;
        }
        String hyperlink = topic.getHyperlink();
        if (hyperlink == null) {
            return false;
        }
        return MindMapUI.getProtocolManager().isHyperlinkModifiable(topic, hyperlink);
    }
}

