/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal;

import java.util.HashMap;
import java.util.Map;
import org.xmind.core.ISheet;
import org.xmind.gef.part.IPart;
import org.xmind.gef.part.PartRegistry;
import org.xmind.ui.mindmap.IBoundaryPart;
import org.xmind.ui.mindmap.IImagePart;
import org.xmind.ui.mindmap.IMarkerPart;
import org.xmind.ui.mindmap.IMindMap;
import org.xmind.ui.mindmap.IRelationshipPart;
import org.xmind.ui.mindmap.ITopicPart;
import org.xmind.ui.mindmap.IViewerModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MindMapPartRegistry
extends PartRegistry {
    private Map<Object, Object> realModelToViewerModel = new HashMap<Object, Object>();

    public void register(Object model, IPart p) {
        super.register(model, p);
        if (model instanceof IViewerModel) {
            IViewerModel wm = (IViewerModel)model;
            Class<? extends IPart> partType = wm.getPartType();
            if (this.isPartSelectable(partType)) {
                model = wm.getRealModel();
                this.realModelToViewerModel.put(model, wm);
            }
        } else if (model instanceof IMindMap) {
            IMindMap viewerInput = (IMindMap)model;
            ISheet sheet = viewerInput.getSheet();
            this.realModelToViewerModel.put(sheet, model);
        }
    }

    public void unregister(Object model, IPart p) {
        if (model instanceof IViewerModel) {
            IViewerModel wm = (IViewerModel)model;
            Class<? extends IPart> partType = wm.getPartType();
            if (this.isPartSelectable(partType)) {
                model = wm.getRealModel();
                this.realModelToViewerModel.remove(model);
            }
        } else if (model instanceof IMindMap) {
            IMindMap viewerInput = (IMindMap)model;
            ISheet sheet = viewerInput.getSheet();
            this.realModelToViewerModel.remove(sheet);
        }
        super.unregister(model, p);
    }

    public IPart getPartByModel(Object model) {
        IPart part = super.getPartByModel(model);
        if (part == null && (model = this.toViewerModel(model)) != null) {
            part = super.getPartByModel(model);
        }
        return part;
    }

    private Object toViewerModel(Object model) {
        return this.realModelToViewerModel.get(model);
    }

    private boolean isPartSelectable(Class<? extends IPart> partType) {
        return ITopicPart.class.isAssignableFrom(partType) || IRelationshipPart.class.isAssignableFrom(partType) || IBoundaryPart.class.isAssignableFrom(partType) || IMarkerPart.class.isAssignableFrom(partType) || IImagePart.class.isAssignableFrom(partType);
    }
}

