/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.IEditorActionDelegate;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.internal.registry.IWorkbenchRegistryConstants;
import org.eclipse.ui.internal.registry.RegistryReader;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.xmind.ui.internal.IActionBuilder;
import org.xmind.ui.util.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ImageActionExtensionManager
extends RegistryReader
implements IWorkbenchRegistryConstants {
    private static final ImageActionExtensionManager instance = new ImageActionExtensionManager();
    private List<IActionBuilder> actionBuilders;

    private ImageActionExtensionManager() {
    }

    public List<IActionBuilder> getActionBuilders() {
        this.ensureLoaded();
        return this.actionBuilders;
    }

    private void ensureLoaded() {
        if (this.actionBuilders != null) {
            return;
        }
        this.lazyLoad();
        if (this.actionBuilders == null) {
            this.actionBuilders = Collections.emptyList();
        }
    }

    private void lazyLoad() {
        this.readRegistry(Platform.getExtensionRegistry(), "org.xmind.ui", "imageActions");
    }

    protected boolean readElement(IConfigurationElement element) {
        String name = element.getName();
        if ("action".equals(name)) {
            this.readChooser(element);
            this.readElementChildren(element);
            return true;
        }
        return false;
    }

    private void readChooser(IConfigurationElement element) {
        try {
            ActionBuilder actionBuilder = new ActionBuilder(element);
            this.register(actionBuilder);
        }
        catch (CoreException e) {
            Logger.log(e);
        }
    }

    private void register(IActionBuilder actionBuilder) {
        if (this.actionBuilders == null) {
            this.actionBuilders = new ArrayList<IActionBuilder>();
        }
        this.actionBuilders.add(actionBuilder);
    }

    public static ImageActionExtensionManager getInstance() {
        return instance;
    }

    public static class ActionBuilder
    implements IActionBuilder {
        private IConfigurationElement element;
        private String id;
        private IEditorActionDelegate delegate;
        private boolean delegateFailed = false;
        private ImageDescriptor icon;
        private boolean iconFailed = false;
        private ImageDescriptor disabledIcon;
        private boolean disabledIconFailed = false;

        public ActionBuilder(IConfigurationElement element) throws CoreException {
            this.element = element;
            if (ImageActionExtensionManager.getClassValue((IConfigurationElement)element, (String)"class") == null) {
                throw new CoreException((IStatus)new Status(4, element.getNamespaceIdentifier(), "Invalid extension (missing class)"));
            }
            this.id = element.getAttribute("id");
        }

        public String getId() {
            return this.id;
        }

        public String getLabel() {
            return this.element.getAttribute("label");
        }

        public IEditorActionDelegate getDelegate() {
            if (this.delegate == null && !this.delegateFailed) {
                this.delegate = this.createDelegate();
                if (this.delegate == null) {
                    this.delegateFailed = true;
                }
            }
            return this.delegate;
        }

        private IEditorActionDelegate createDelegate() {
            try {
                return (IEditorActionDelegate)this.element.createExecutableExtension("class");
            }
            catch (CoreException e) {
                Logger.log(e);
                return null;
            }
        }

        public String getDefinitionId() {
            return this.element.getAttribute("definitionId");
        }

        public String getTooltip() {
            return this.element.getAttribute("tooltip");
        }

        public ImageDescriptor getIcon() {
            if (this.icon == null && !this.iconFailed) {
                this.icon = this.createIcon();
                if (this.icon == null) {
                    this.iconFailed = true;
                }
            }
            return this.icon;
        }

        private ImageDescriptor createIcon() {
            String iconPath = this.element.getAttribute("icon");
            if (iconPath != null) {
                return AbstractUIPlugin.imageDescriptorFromPlugin((String)this.element.getNamespaceIdentifier(), (String)iconPath);
            }
            return null;
        }

        public ImageDescriptor getDisabledIcon() {
            if (this.disabledIcon == null && !this.disabledIconFailed) {
                this.disabledIcon = this.createDisabledIcon();
                if (this.disabledIcon == null) {
                    this.disabledIconFailed = true;
                }
            }
            return this.disabledIcon;
        }

        private ImageDescriptor createDisabledIcon() {
            String iconPath = this.element.getAttribute("disabledIcon");
            if (iconPath != null) {
                return AbstractUIPlugin.imageDescriptorFromPlugin((String)this.element.getNamespaceIdentifier(), (String)iconPath);
            }
            return null;
        }

        public ActionFactory.IWorkbenchAction createAction(IWorkbenchPage page) {
            return new DelegatedAction(this, page);
        }
    }

    private static class DelegatedAction
    extends Action
    implements ActionFactory.IWorkbenchAction,
    IPartListener,
    ISelectionListener {
        private IWorkbenchPage page;
        private IActionBuilder builder;
        private IEditorPart targetEditor;

        public DelegatedAction(IActionBuilder builder, IWorkbenchPage page) {
            this.builder = builder;
            this.page = page;
            this.setId(builder.getId());
            this.setText(builder.getLabel());
            this.setToolTipText(builder.getTooltip());
            this.setImageDescriptor(builder.getIcon());
            this.setDisabledImageDescriptor(builder.getDisabledIcon());
            this.setActionDefinitionId(builder.getDefinitionId());
            page.addPartListener((IPartListener)this);
            page.addSelectionListener((ISelectionListener)this);
        }

        public void run() {
            IEditorActionDelegate delegate = this.builder.getDelegate();
            if (delegate != null) {
                delegate.run((IAction)this);
            }
        }

        public void dispose() {
            this.page.removeSelectionListener((ISelectionListener)this);
            this.page.removePartListener((IPartListener)this);
        }

        public void partActivated(IWorkbenchPart part) {
            if (part instanceof IEditorPart) {
                this.targetEditor = (IEditorPart)part;
                IEditorActionDelegate delegate = this.builder.getDelegate();
                if (delegate != null) {
                    delegate.setActiveEditor((IAction)this, this.targetEditor);
                }
            }
        }

        public void partBroughtToTop(IWorkbenchPart part) {
        }

        public void partClosed(IWorkbenchPart part) {
            IEditorActionDelegate delegate;
            if (part == this.targetEditor && (delegate = this.builder.getDelegate()) != null) {
                delegate.setActiveEditor((IAction)this, null);
            }
        }

        public void partDeactivated(IWorkbenchPart part) {
        }

        public void partOpened(IWorkbenchPart part) {
        }

        public void selectionChanged(IWorkbenchPart part, ISelection selection) {
            IEditorActionDelegate delegate;
            if (part == this.targetEditor && (delegate = this.builder.getDelegate()) != null) {
                delegate.selectionChanged((IAction)this, selection);
            }
        }
    }
}

