/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.internal.registry.RegistryReader;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.xmind.core.ITopic;
import org.xmind.ui.mindmap.IIconTipContributor;
import org.xmind.ui.mindmap.IIconTipPart;
import org.xmind.ui.mindmap.ITopicPart;
import org.xmind.ui.util.Logger;

public class IconTipContributorProxy
implements IIconTipContributor {
    private static final IIconTipContributor NULL_CONTRIBUTOR = new NullIconTipContributor();
    private IConfigurationElement element;
    private String id;
    private ImageDescriptor icon;
    private String label;
    private String tooltip;
    private IIconTipContributor implementation;

    public IconTipContributorProxy(IConfigurationElement element) throws CoreException {
        this.element = element;
        this.id = element.getAttribute("id");
        this.label = element.getAttribute("label");
        this.tooltip = element.getAttribute("tooltip");
        if (RegistryReader.getClassValue((IConfigurationElement)element, (String)"contributorClass") == null) {
            throw new CoreException((IStatus)new Status(4, element.getNamespaceIdentifier(), 0, "Invalid extension (missing class name): " + this.id, null));
        }
    }

    public IAction createAction(ITopicPart topicPart, ITopic topic) {
        IAction action = this.getImplementation().createAction(topicPart, topic);
        if (action != null) {
            if (action.getImageDescriptor() == null) {
                action.setImageDescriptor(this.getIcon());
            }
            if (action.getText() == null) {
                action.setText(this.getLabel());
            }
            if (action.getToolTipText() == null) {
                action.setToolTipText(this.getTooltip());
            }
        }
        return action;
    }

    public ImageDescriptor getIcon() {
        if (this.icon == null) {
            this.icon = this.createIcon();
        }
        return this.icon;
    }

    public String getLabel() {
        return this.label;
    }

    public String getTooltip() {
        return this.tooltip;
    }

    private ImageDescriptor createIcon() {
        String iconName = this.element.getAttribute("icon");
        if (iconName != null) {
            String plugId = this.element.getNamespaceIdentifier();
            return AbstractUIPlugin.imageDescriptorFromPlugin((String)plugId, (String)iconName);
        }
        return null;
    }

    public IIconTipContributor getImplementation() {
        if (this.implementation == null) {
            try {
                this.implementation = (IIconTipContributor)this.element.createExecutableExtension("contributorClass");
            }
            catch (CoreException e) {
                Logger.log(e, "Failed to create icon tip contributor from class: " + RegistryReader.getClassValue((IConfigurationElement)this.element, (String)"contributorClass"));
                this.implementation = NULL_CONTRIBUTOR;
            }
        }
        return this.implementation;
    }

    public void fillContextMenu(IIconTipPart part) {
        this.getImplementation().fillContextMenu(part);
    }

    public void topicActivated(ITopicPart topicPart) {
        this.getImplementation().topicActivated(topicPart);
    }

    public void topicDeactivated(ITopicPart topicPart) {
        this.getImplementation().topicDeactivated(topicPart);
    }

    private static class NullIconTipContributor
    implements IIconTipContributor {
        private NullIconTipContributor() {
        }

        public IAction createAction(ITopicPart topicPart, ITopic topic) {
            return null;
        }

        public void fillContextMenu(IIconTipPart part) {
        }

        public void topicActivated(ITopicPart topicPart) {
        }

        public void topicDeactivated(ITopicPart topicPart) {
        }
    }
}

