/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.decorations;

import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.geometry.Rectangle;
import org.xmind.gef.draw2d.ITextFigure;
import org.xmind.gef.draw2d.ITitledFigure;
import org.xmind.gef.draw2d.decoration.IShadowedDecoration;
import org.xmind.gef.draw2d.decoration.PathShapeDecoration;
import org.xmind.gef.draw2d.graphics.Path;
import org.xmind.ui.decorations.IBoundaryDecoration;

public abstract class AbstractBoundaryDecoration
extends PathShapeDecoration
implements IBoundaryDecoration,
IShadowedDecoration {
    private static final Rectangle CLIP = new Rectangle();
    private static final int MARGIN_WIDTH = 10;
    private static final int MARGIN_HEIGHT = 10;
    protected static final int TITLE_MARGIN = 5;

    protected AbstractBoundaryDecoration() {
    }

    protected AbstractBoundaryDecoration(String id) {
        super(id);
    }

    public boolean containsPoint(IFigure figure, int x, int y) {
        return this.containsPoint(figure, x, y, true);
    }

    protected int getCheckingLineWidth() {
        return super.getCheckingLineWidth() * 2 + 4;
    }

    protected void paintPath(IFigure figure, Graphics graphics, Path path, boolean fill) {
        ITextFigure titleFigure = this.getTitleFigure(figure);
        if (titleFigure != null && titleFigure.isShowing()) {
            Rectangle bounds = figure.getBounds();
            Rectangle titleArea = titleFigure.getBounds();
            if (titleArea.intersects(bounds)) {
                graphics.pushState();
                try {
                    this.paintPathAroundTitle(figure, graphics, path, fill, bounds, titleArea);
                }
                finally {
                    graphics.popState();
                }
                return;
            }
        }
        super.paintPath(figure, graphics, path, fill);
    }

    protected void paintPathAroundTitle(IFigure figure, Graphics graphics, Path path, boolean fill, Rectangle bounds, Rectangle titleArea) {
        int w = bounds.x + bounds.width - titleArea.x - titleArea.width;
        int h = titleArea.y + titleArea.height - bounds.y;
        if (w > 0 && h > 0) {
            CLIP.setSize(w, h);
            CLIP.setLocation(titleArea.x + titleArea.width, bounds.y);
            this.paintPathWithClip(figure, graphics, path, fill, CLIP);
        }
        w = bounds.width;
        h = bounds.y + bounds.height - titleArea.y - titleArea.height;
        if (w > 0 && h > 0) {
            CLIP.setSize(w, h);
            CLIP.setLocation(bounds.x, titleArea.y + titleArea.height);
            this.paintPathWithClip(figure, graphics, path, fill, CLIP);
        }
    }

    protected void paintPathWithClip(IFigure figure, Graphics graphics, Path path, boolean fill, Rectangle clip) {
        graphics.clipRect(clip);
        super.paintPath(figure, graphics, path, fill);
        graphics.restoreState();
    }

    protected ITextFigure getTitleFigure(IFigure figure) {
        if (figure instanceof ITitledFigure) {
            return ((ITitledFigure)figure).getTitle();
        }
        return null;
    }

    protected Rectangle getOutlineBox(IFigure figure) {
        Rectangle r = super.getOutlineBox(figure);
        ITextFigure titleFigure = this.getTitleFigure(figure);
        if (titleFigure != null && titleFigure.isShowing()) {
            r.x += 5;
            r.width -= 5;
            int height = titleFigure.getPreferredSize().height;
            height = Math.min(5, height / 2);
            r.y += height;
            r.height -= height;
        }
        return r;
    }

    public void paintShadow(IFigure figure, Graphics graphics) {
        if (!this.isVisible()) {
            return;
        }
        this.checkValidation(figure);
        graphics.setAlpha(this.getAlpha());
        graphics.setBackgroundColor(ColorConstants.black);
        graphics.setForegroundColor(ColorConstants.black);
        this.paintFill(figure, graphics);
    }

    public Insets getPreferredInsets(IFigure figure, int width, int height) {
        return new Insets(10, 10, 10, 10);
    }
}

