/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.branch;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.xmind.gef.draw2d.IDecoratedFigure;
import org.xmind.gef.draw2d.IReferencedFigure;
import org.xmind.gef.draw2d.IRotatableFigure;
import org.xmind.gef.draw2d.ReferencedLayoutData;
import org.xmind.gef.draw2d.decoration.IDecoration;
import org.xmind.gef.draw2d.geometry.Geometry;
import org.xmind.gef.draw2d.geometry.PrecisionDimension;
import org.xmind.gef.draw2d.geometry.PrecisionRectangle;
import org.xmind.gef.draw2d.geometry.PrecisionRotator;
import org.xmind.gef.graphicalpolicy.IStyleSelector;
import org.xmind.gef.part.IGraphicalPart;
import org.xmind.gef.part.IPart;
import org.xmind.ui.branch.BoundaryLayoutHelper;
import org.xmind.ui.branch.IBranchStructure;
import org.xmind.ui.branch.IBranchStructureExtension;
import org.xmind.ui.branch.IInsertableBranchStructureExtension;
import org.xmind.ui.branch.IInsertion;
import org.xmind.ui.branch.INavigableBranchStructureExtension;
import org.xmind.ui.decorations.ISummaryDecoration;
import org.xmind.ui.internal.figures.BranchFigure;
import org.xmind.ui.mindmap.IBoundaryPart;
import org.xmind.ui.mindmap.IBranchPart;
import org.xmind.ui.mindmap.IBranchRangePart;
import org.xmind.ui.mindmap.ILabelPart;
import org.xmind.ui.mindmap.INodePart;
import org.xmind.ui.mindmap.IPlusMinusPart;
import org.xmind.ui.mindmap.ISummaryPart;
import org.xmind.ui.mindmap.ITopicPart;
import org.xmind.ui.style.StyleUtils;
import org.xmind.ui.tools.ParentSearchKey;
import org.xmind.ui.util.MindMapUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractBranchStructure
implements IBranchStructure,
IBranchStructureExtension,
INavigableBranchStructureExtension,
IInsertableBranchStructureExtension {
    protected static final String CACHE_STRUCTURE_DATA = "org.xmind.ui.branchCache.structureData";
    protected static final String CACHE_BOUNDARY_LAYOUT_HELPER = "org.xmind.ui.branchCache.boundaryLayoutHelper";

    @Override
    public void fillLayoutData(IBranchPart branch, ReferencedLayoutData data) {
        BranchFigure figure = (BranchFigure)branch.getFigure();
        boolean folded = figure.isFolded();
        boolean minimized = figure.isMinimized();
        LayoutInfo info = new LayoutInfo(data, folded, minimized);
        this.fillLayoutInfo(branch, info);
    }

    protected void fillLayoutInfo(IBranchPart branch, LayoutInfo info) {
        this.fillTopic(branch, info);
        this.fillPlusMinus(branch, info);
        this.fillLabel(branch, info);
        List<IBranchPart> subBranches = branch.getSubBranches();
        this.fillSubBranches(branch, subBranches, info);
        List<IBoundaryPart> boundaries = branch.getBoundaries();
        this.fillBoundaries(branch, boundaries, subBranches, info);
        List<ISummaryPart> summaries = branch.getSummaries();
        ArrayList<IBranchPart> summaryBranches = new ArrayList<IBranchPart>(branch.getSummaryBranches());
        this.fillSummaries(branch, summaries, summaryBranches, subBranches, info);
        this.fillUnhandledSummaryBranches(branch, summaryBranches, info);
        this.addExtraSpaces(branch, info);
        this.fillOverallBoundary(branch, boundaries, info);
    }

    protected void fillTopic(IBranchPart branch, LayoutInfo info) {
        ITopicPart topic = branch.getTopicPart();
        if (topic != null) {
            if (info.isMinimized()) {
                info.putMinArea(topic.getFigure());
            } else {
                this.doFillTopic(branch, topic, info);
            }
        }
    }

    protected void doFillTopic(IBranchPart branch, ITopicPart topicPart, LayoutInfo info) {
        IFigure fig = topicPart.getFigure();
        if (fig instanceof IReferencedFigure) {
            IReferencedFigure refFig = (IReferencedFigure)fig;
            info.put((IFigure)refFig, refFig.getPreferredBounds(info.getReference()));
        } else {
            Dimension size = fig.getPreferredSize();
            Point ref = info.getReference();
            Rectangle r = new Rectangle(ref.x - size.width / 2, ref.y - size.height / 2, size.width, size.height);
            info.put(fig, r);
        }
    }

    protected void fillPlusMinus(IBranchPart branch, LayoutInfo info) {
        IPlusMinusPart plusMinus = branch.getPlusMinus();
        if (plusMinus != null) {
            IFigure pmFigure = plusMinus.getFigure();
            if (info.isMinimized()) {
                info.putMinArea(pmFigure);
            } else {
                this.doFillPlusMinus(branch, plusMinus, info);
                if (info.get(pmFigure) == null) {
                    info.putMinArea(pmFigure);
                }
            }
        }
    }

    protected abstract void doFillPlusMinus(IBranchPart var1, IPlusMinusPart var2, LayoutInfo var3);

    protected void fillLabel(IBranchPart branch, LayoutInfo info) {
        ILabelPart label = branch.getLabel();
        if (label != null) {
            if (info.isMinimized() || !label.getFigure().isVisible()) {
                info.putMinArea(label.getFigure());
            } else {
                this.doFillLabel(branch, label, info);
            }
        }
    }

    protected void doFillLabel(IBranchPart branch, ILabelPart label, LayoutInfo info) {
        IRotatableFigure f;
        double angle;
        IFigure figure = label.getFigure();
        ITopicPart topicPart = branch.getTopicPart();
        Rectangle area = topicPart != null ? info.get(topicPart.getFigure()) : info.createInitBounds();
        if (figure instanceof IRotatableFigure && !Geometry.isSameAngleDegree((double)(angle = (f = (IRotatableFigure)figure).getRotationDegrees()), (double)0.0, (double)1.0E-5)) {
            Point ref = info.getReference();
            PrecisionRotator r = new PrecisionRotator();
            r.setOrigin((double)ref.x, (double)ref.y);
            r.setAngle(angle);
            PrecisionRectangle rect = r.r(new PrecisionRectangle(area));
            PrecisionDimension size = f.getNormalPreferredSize(-1, -1);
            rect.x += (rect.width - size.width) / 2.0;
            rect.y = rect.bottom() - 2.0;
            rect.width = size.width;
            rect.height = size.height;
            r.t(rect);
            info.put(figure, rect.toDraw2DRectangle());
            return;
        }
        Dimension size = figure.getPreferredSize();
        Rectangle r = new Rectangle(area.x + (area.width - size.width) / 2, area.bottom() - 2, size.width, size.height);
        info.put(figure, r);
    }

    protected void fillSubBranches(IBranchPart branch, List<IBranchPart> subBranches, LayoutInfo info) {
        if (subBranches.isEmpty()) {
            return;
        }
        if ((info.isFolded() || info.isMinimized()) && this.minimizesSubBranchesToOnePoint()) {
            if (info.isFolded() && !info.isMinimized()) {
                info.setMinArea(info.createInitBounds(this.calcSubBranchesMinPoint(branch, subBranches, info)));
            }
            for (IBranchPart subBranch : subBranches) {
                info.putMinArea(subBranch.getFigure());
            }
        } else {
            this.doFillSubBranches(branch, subBranches, info);
            for (IBranchPart subBranch : subBranches) {
                IFigure subBranchFigure = subBranch.getFigure();
                if (info.get(subBranchFigure) != null) continue;
                info.putMinArea(subBranchFigure);
            }
        }
    }

    protected abstract void doFillSubBranches(IBranchPart var1, List<IBranchPart> var2, LayoutInfo var3);

    protected boolean minimizesSubBranchesToOnePoint() {
        return true;
    }

    protected Point calcSubBranchesMinPoint(IBranchPart branch, List<IBranchPart> subBranches, LayoutInfo info) {
        Rectangle pmBounds;
        IPlusMinusPart plusMinus = branch.getPlusMinus();
        if (plusMinus != null && (pmBounds = info.get(plusMinus.getFigure())) != null) {
            return pmBounds.getCenter();
        }
        return info.getReference();
    }

    protected void fillBoundaries(IBranchPart branch, List<IBoundaryPart> boundaries, List<IBranchPart> subBranches, LayoutInfo info) {
        if (boundaries.isEmpty()) {
            return;
        }
        if (subBranches.isEmpty() || (info.isFolded() || info.isMinimized()) && this.minimizesSubBranchesToOnePoint()) {
            for (IBoundaryPart b : boundaries) {
                info.putMinArea(b.getFigure());
            }
        } else {
            this.doFillBoundaries(branch, boundaries, info);
        }
    }

    protected void doFillBoundaries(IBranchPart branch, List<IBoundaryPart> boundaries, LayoutInfo info) {
        for (IBoundaryPart boundary : boundaries) {
            this.doFillBoundary(branch, boundary, info);
        }
    }

    protected void doFillBoundary(IBranchPart branch, IBoundaryPart boundary, LayoutInfo info) {
        BoundaryLayoutHelper helper = this.getBoundaryLayoutHelper(branch);
        BoundaryLayoutHelper.BoundaryData d = helper.getBoundaryData(boundary);
        if (d.isOverall()) {
            if (d != helper.getOverallBoundary()) {
                info.putMinArea(boundary.getFigure());
            }
            return;
        }
        Rectangle area = null;
        for (IBranchPart subBranch : d.getSubBranches()) {
            Insets ins = helper.getInnerInsets(helper.getSubBranchData(subBranch), d);
            Rectangle r2 = info.get(subBranch.getFigure());
            area = Geometry.union(area, (Rectangle)r2.getExpanded(ins));
        }
        if (area != null) {
            area.expand(boundary.getFigure().getInsets());
        }
        if (area == null) {
            info.putMinArea(boundary.getFigure());
        } else {
            info.put(boundary.getFigure(), area);
        }
    }

    protected void fillSummaries(IBranchPart branch, List<ISummaryPart> summaries, List<IBranchPart> summaryBranches, List<IBranchPart> subBranches, LayoutInfo info) {
        if (!summaries.isEmpty()) {
            if (subBranches.isEmpty() || (info.isFolded() || info.isMinimized()) && this.minimizesSubBranchesToOnePoint()) {
                for (ISummaryPart s : summaries) {
                    info.putMinArea(s.getFigure());
                }
            } else {
                this.doFillSummaries(branch, summaries, summaryBranches, info);
            }
        }
    }

    private void doFillSummaries(IBranchPart branch, List<ISummaryPart> summaries, List<IBranchPart> summaryBranches, LayoutInfo info) {
        for (ISummaryPart summary : summaries) {
            this.doFillSummary(branch, summary, summaryBranches, info);
        }
    }

    private void doFillSummary(IBranchPart branch, ISummaryPart summary, List<IBranchPart> summaryBranches, LayoutInfo info) {
        int direction = this.getSummaryDirection(branch, summary);
        Rectangle area = this.getSummaryArea(branch, summary, direction, info);
        if (area != null) {
            info.put(summary.getFigure(), area);
        } else {
            info.putMinArea(summary.getFigure());
        }
        IBranchPart conclusionBranch = this.getConclusionBranch(branch, summary, summaryBranches);
        if (conclusionBranch != null) {
            if (area == null) {
                info.putMinArea(conclusionBranch.getFigure());
            } else {
                int y;
                int x;
                Insets ins = this.getConclusionReferenceDescription(branch, summary, conclusionBranch);
                switch (direction) {
                    case 1: {
                        x = area.x + area.width / 2;
                        y = area.y - ins.bottom;
                        break;
                    }
                    case 4: {
                        x = area.x + area.width / 2;
                        y = area.bottom() + ins.top;
                        break;
                    }
                    case 8: {
                        x = area.x - ins.right;
                        y = area.y + area.height / 2;
                        break;
                    }
                    default: {
                        x = area.right() + ins.left;
                        y = area.y + area.height / 2;
                    }
                }
                info.put(conclusionBranch.getFigure(), Geometry.getExpanded((int)x, (int)y, (Insets)ins));
            }
        }
    }

    private IBranchPart getConclusionBranch(IBranchPart branch, ISummaryPart summary, List<IBranchPart> summaryBranches) {
        IBranchPart conclusionBranch;
        INodePart part = summary.getNode();
        if (part instanceof ITopicPart && (conclusionBranch = ((ITopicPart)((Object)part)).getOwnerBranch()) != null && summaryBranches.contains(conclusionBranch)) {
            summaryBranches.remove(conclusionBranch);
            return conclusionBranch;
        }
        return null;
    }

    private Insets getConclusionReferenceDescription(IBranchPart branch, ISummaryPart summary, IGraphicalPart conclusion) {
        IFigure fig = conclusion.getFigure();
        if (fig instanceof IReferencedFigure) {
            return ((IReferencedFigure)fig).getReferenceDescription();
        }
        Dimension size = fig.getPreferredSize();
        int w = size.width / 2;
        int h = size.height / 2;
        return new Insets(h, w, size.height - h, size.width - w);
    }

    protected Rectangle getSummaryArea(IBranchPart branch, ISummaryPart summary, int direction, ReferencedLayoutData data) {
        Rectangle r = null;
        for (IBranchPart subBranch : summary.getEnclosingBranches()) {
            r = Geometry.union(r, (Rectangle)data.get((Object)subBranch.getFigure()));
        }
        if (r == null) {
            return null;
        }
        Rectangle area = data.createInitBounds();
        int width = this.getPreferredSummaryWidth(summary);
        switch (direction) {
            case 1: {
                area.x = r.x;
                area.width = r.width;
                area.y = r.y - width;
                area.height = width;
                break;
            }
            case 4: {
                area.x = r.x;
                area.width = r.width;
                area.y = r.bottom();
                area.height = width;
                break;
            }
            case 8: {
                area.x = r.x - width;
                area.width = width;
                area.y = r.y;
                area.height = r.height;
                break;
            }
            default: {
                area.x = r.right();
                area.width = width;
                area.y = r.y;
                area.height = r.height;
            }
        }
        IStyleSelector ss = StyleUtils.getStyleSelector(summary);
        String shape = StyleUtils.getString(summary, ss, "shape-class", null);
        int lineWidth = StyleUtils.getInteger(summary, ss, "line-width", shape, 1);
        return area.expand(lineWidth, lineWidth);
    }

    private int getPreferredSummaryWidth(ISummaryPart summary) {
        IDecoration decoration;
        IFigure figure = summary.getFigure();
        if (figure instanceof IDecoratedFigure && (decoration = ((IDecoratedFigure)figure).getDecoration()) instanceof ISummaryDecoration) {
            return ((ISummaryDecoration)decoration).getPreferredWidth(figure);
        }
        return 30;
    }

    protected void fillUnhandledSummaryBranches(IBranchPart branch, List<IBranchPart> summaryBranches, LayoutInfo info) {
        if (!summaryBranches.isEmpty()) {
            for (IBranchPart summaryBranch : summaryBranches) {
                info.putMinArea(summaryBranch.getFigure());
            }
        }
    }

    protected void addExtraSpaces(IBranchPart branch, ReferencedLayoutData data) {
    }

    @Override
    public int getSummaryDirection(IBranchPart branch, ISummaryPart summary) {
        return 16;
    }

    protected void fillOverallBoundary(IBranchPart branch, List<IBoundaryPart> boundaries, LayoutInfo info) {
        if (boundaries.isEmpty()) {
            return;
        }
        BoundaryLayoutHelper helper = this.getBoundaryLayoutHelper(branch);
        BoundaryLayoutHelper.BoundaryData overallBoundary = helper.getOverallBoundary();
        if (overallBoundary == null) {
            return;
        }
        if (info.isMinimized()) {
            info.putMinArea(overallBoundary.boundaryFigure);
        } else {
            Rectangle area = info.getCheckedClientArea();
            area = overallBoundary.expanded(area.getCopy());
            info.put(overallBoundary.boundaryFigure, area);
        }
    }

    @Override
    public int getRangeGrowthDirection(IBranchPart branch, IBranchRangePart range) {
        return 4;
    }

    public void invalidate(IGraphicalPart part) {
        if (part instanceof IBranchPart) {
            this.invalidateBranch((IBranchPart)part);
        }
    }

    protected void invalidateBranch(IBranchPart branch) {
        IFigure topicFigure;
        MindMapUtils.flushCache((IPart)branch, CACHE_STRUCTURE_DATA);
        MindMapUtils.flushCache((IPart)branch, CACHE_BOUNDARY_LAYOUT_HELPER);
        ITopicPart topic = branch.getTopicPart();
        if (topic != null && (topicFigure = topic.getFigure()) != null) {
            topicFigure.invalidate();
        }
    }

    protected BoundaryLayoutHelper getBoundaryLayoutHelper(IBranchPart branch) {
        BoundaryLayoutHelper helper = (BoundaryLayoutHelper)MindMapUtils.getCache((IPart)branch, CACHE_BOUNDARY_LAYOUT_HELPER);
        if (helper == null) {
            helper = new BoundaryLayoutHelper(branch, this);
            MindMapUtils.setCache((IPart)branch, CACHE_BOUNDARY_LAYOUT_HELPER, helper);
        }
        return helper;
    }

    protected Dimension getBorderedSize(IBranchPart branch, IBranchPart subBranch) {
        return this.getBoundaryLayoutHelper(branch).getBorderedSize(subBranch);
    }

    protected int getMinorSpacing(IBranchPart branch) {
        return StyleUtils.getInteger(branch, branch.getBranchPolicy().getStyleSelector(branch), "spacing-minor", 5);
    }

    protected int getMajorSpacing(IBranchPart branch) {
        return StyleUtils.getMajorSpacing(branch, 5);
    }

    protected Object getStructureData(IBranchPart branch) {
        Object data = MindMapUtils.getCache((IPart)branch, CACHE_STRUCTURE_DATA);
        if (!this.isValidStructureData(branch, data) && (data = this.createStructureData(branch)) != null) {
            MindMapUtils.setCache((IPart)branch, CACHE_STRUCTURE_DATA, data);
        }
        return data;
    }

    protected Object createStructureData(IBranchPart branch) {
        return null;
    }

    protected boolean isValidStructureData(IBranchPart branch, Object data) {
        return data != null;
    }

    @Override
    public int getSourceOrientation(IBranchPart branch) {
        return 0;
    }

    @Override
    public int getChildTargetOrientation(IBranchPart branch, IBranchPart subBranch) {
        return 0;
    }

    @Override
    public int calcChildIndex(IBranchPart branch, ParentSearchKey key) {
        return -1;
    }

    @Override
    public int calcChildDistance(IBranchPart branch, ParentSearchKey key) {
        return -1;
    }

    @Override
    public IInsertion calcInsertion(IBranchPart branch, ParentSearchKey key) {
        return null;
    }

    @Override
    public IPart calcNavigation(IBranchPart branch, String navReqType) {
        return null;
    }

    @Override
    public IPart calcChildNavigation(IBranchPart branch, IBranchPart sourceChild, String navReqType, boolean sequential) {
        if ("navigate beginning".equals(navReqType)) {
            return this.getSubTopicPart(branch, 0);
        }
        if ("navigate end".equals(navReqType)) {
            return this.getSubTopicPart(branch, branch.getSubBranches().size() - 1);
        }
        return null;
    }

    @Override
    public void calcSequentialNavigation(IBranchPart branch, IBranchPart startChild, IBranchPart endChild, List<IBranchPart> results) {
        this.addSubBranches(branch, startChild.getBranchIndex(), endChild.getBranchIndex(), results);
    }

    @Override
    public void calcTraversableBranches(IBranchPart branch, IBranchPart sourceChild, List<IBranchPart> results) {
        this.addSubBranch(branch, sourceChild.getBranchIndex() + 1, results);
        results.add(branch);
        this.addSubBranch(branch, sourceChild.getBranchIndex() - 1, results);
    }

    @Override
    public void calcTraversableChildren(IBranchPart branch, List<IBranchPart> results) {
        this.addSubBranches(branch, 0, branch.getSubBranches().size() - 1, results);
    }

    protected void addSubBranches(IBranchPart branch, IBranchPart fromChild, IBranchPart toChild, List<IBranchPart> results) {
        this.addSubBranches(branch, branch.getSubBranches().indexOf(fromChild), branch.getSubBranches().indexOf(toChild), results);
    }

    protected void addSubBranches(IBranchPart branch, int fromIndex, int toIndex, List<IBranchPart> results) {
        boolean decreasing = fromIndex > toIndex;
        int i = fromIndex;
        while (!(decreasing ? i < toIndex : i > toIndex)) {
            this.addSubBranch(branch, i, results);
            if (decreasing) {
                --i;
                continue;
            }
            ++i;
        }
    }

    protected void addSubBranch(IBranchPart branch, int index, List<IBranchPart> results) {
        if (index < 0 || index >= branch.getSubBranches().size()) {
            return;
        }
        results.add(branch.getSubBranches().get(index));
    }

    protected IBranchPart getSubBranch(IBranchPart branch, int index) {
        if (index >= 0 && index < branch.getSubBranches().size()) {
            return branch.getSubBranches().get(index);
        }
        return null;
    }

    protected ITopicPart getSubTopicPart(IBranchPart branch, int index) {
        IBranchPart subBranch = this.getSubBranch(branch, index);
        if (subBranch != null) {
            return subBranch.getTopicPart();
        }
        return null;
    }

    protected IInsertion getCurrentInsertion(IBranchPart branch) {
        return (IInsertion)MindMapUtils.getCache((IPart)branch, "org.xmind.ui.branchCache.insertion");
    }

    @Override
    public int getQuickMoveOffset(IBranchPart branch, IBranchPart child, int direction) {
        return 0;
    }

    protected static class LayoutInfo
    extends ReferencedLayoutData {
        private ReferencedLayoutData delegate;
        private boolean folded;
        private boolean minimized;
        private Rectangle minArea;

        public LayoutInfo(ReferencedLayoutData delegate, boolean folded, boolean minimized) {
            this.delegate = delegate;
            this.folded = folded;
            this.minimized = minimized;
            this.minArea = null;
        }

        public boolean isFolded() {
            return this.folded;
        }

        public boolean isMinimized() {
            return this.minimized;
        }

        public Rectangle getMinArea() {
            return this.minArea;
        }

        public void setMinArea(Rectangle minArea) {
            this.minArea = minArea;
        }

        public void putMinArea(IFigure figure) {
            if (this.minArea == null) {
                this.delegate.put(figure, this.delegate.createInitBounds());
            } else {
                this.delegate.put(figure, this.minArea.getCopy());
            }
        }

        public void add(Rectangle blankArea) {
            this.delegate.add(blankArea);
        }

        public void addMargins(Insets margin) {
            this.delegate.addMargins(margin);
        }

        public void addMargins(int top, int left, int bottom, int right) {
            this.delegate.addMargins(top, left, bottom, right);
        }

        public Rectangle createInitBounds() {
            return this.delegate.createInitBounds();
        }

        public Rectangle createInitBounds(Point ref) {
            return this.delegate.createInitBounds(ref);
        }

        public Rectangle get(Object figure) {
            return this.delegate.get(figure);
        }

        public Rectangle getCheckedClientArea() {
            return this.delegate.getCheckedClientArea();
        }

        public Rectangle getClientArea() {
            return this.delegate.getClientArea();
        }

        public Point getReference() {
            return this.delegate.getReference();
        }

        public void put(IFigure figure, Rectangle preferredBounds) {
            this.delegate.put(figure, preferredBounds);
        }

        public void translate(int dx, int dy) {
            this.delegate.translate(dx, dy);
        }
    }
}

